/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.projectplanningmodule2.client.adapterlib.gui;

import com.arcway.cockpit.projectplanningmodule2.client.adapterlib.gui.IProgressListener;
import org.eclipse.swt.widgets.ProgressBar;

public class ProgressListener
implements IProgressListener {
    ProgressBar progressBar;
    int maximum = 0;
    int currentProgress = 0;
    boolean errorOccured = false;
    boolean currentPartComplete = false;

    public ProgressListener(ProgressBar progressBar) {
        assert (progressBar != null);
        this.progressBar = progressBar;
    }

    @Override
    public void setProgressParts(int parts) {
        assert (parts > 0);
        this.maximum = parts * 100;
        this.progressBar.setMaximum(this.maximum);
    }

    @Override
    public void setCurrentPartProgress(int progress) {
        assert (progress >= 0 && progress <= 100);
        this.currentPartComplete = false;
        int newProgress = this.currentProgress + progress;
        if (newProgress <= this.maximum) {
            this.progressBar.setSelection(newProgress);
        }
        if (progress == 100) {
            this.currentProgress += 100;
            this.currentPartComplete = true;
        }
    }

    @Override
    public boolean isCurrentPartComplete() {
        return this.currentPartComplete;
    }

    @Override
    public void errorOccurred() {
        this.errorOccured = true;
        this.progressBar.setSelection(0);
    }

    @Override
    public boolean hasErrorOccured() {
        return this.errorOccured;
    }
}

