/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.projectplanningmodule2.client.adapterlib.gui;

import com.arcway.cockpit.modulelib2.client.gui.ImageDescriptorRegistry;
import com.arcway.cockpit.modulelib2.client.messages.IModuleData;
import com.arcway.cockpit.projectplanningmodule2.client.Messages;
import com.arcway.cockpit.projectplanningmodule2.client.ProjectPlanningModule2Plugin;
import com.arcway.cockpit.projectplanningmodule2.client.core.project.ModelController;
import com.arcway.cockpit.projectplanningmodule2.client.messages.ProjectPlan;
import com.arcway.cockpit.projectplanningmodule2.client.messages.Task;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.swt.graphics.Image;

public class ExportTaskLabelProvider
implements ILabelProvider {
    private final ImageDescriptorRegistry imageDescriptorRegistry = ProjectPlanningModule2Plugin.getDefault().getImageDescriptorRegistry();
    private final ImageDescriptor unsynchronizedPlanImageDescriptor = ProjectPlanningModule2Plugin.getImageDescriptor("Project.gif");
    private final ImageDescriptor synchronizesPlanImageDescriptor = ProjectPlanningModule2Plugin.getImageDescriptor("Project_synchronized.gif");
    private final ImageDescriptor taskImageDescriptor = ProjectPlanningModule2Plugin.getImageDescriptor("Task.gif");
    private final ImageDescriptor understimatedTaskImageDescriptor = ProjectPlanningModule2Plugin.getImageDescriptor("TaskUnderestimated.gif");
    private final ImageDescriptor milestoneImageDescriptor = ProjectPlanningModule2Plugin.getImageDescriptor("Milestone.gif");

    public Image getImage(Object element) {
        if (element instanceof ProjectPlan) {
            ProjectPlan plan = (ProjectPlan)((Object)element);
            ModelController modelController = (ModelController)ProjectPlanningModule2Plugin.getDefault().getProjectManager().getModelController(plan.getProjectUID());
            ImageDescriptor descriptor = this.isSynchronized(modelController, plan) ? this.synchronizesPlanImageDescriptor : this.unsynchronizedPlanImageDescriptor;
            return this.imageDescriptorRegistry.get(descriptor);
        }
        if (element instanceof Task) {
            Task task = (Task)((Object)element);
            if (task.isMilestone().getValue()) {
                return this.imageDescriptorRegistry.get(this.milestoneImageDescriptor);
            }
            ModelController modelController = (ModelController)ProjectPlanningModule2Plugin.getDefault().getProjectManager().getModelController(task.getProjectUID());
            long workRemaining = task.getWorkRemaining().getValue();
            long originalWork = task.getOriginalWork().getValue();
            if (originalWork < workRemaining) {
                return this.imageDescriptorRegistry.get(this.understimatedTaskImageDescriptor);
            }
            return this.imageDescriptorRegistry.get(this.taskImageDescriptor);
        }
        return null;
    }

    public String getText(Object element) {
        if (element instanceof ProjectPlan) {
            ProjectPlan plan = (ProjectPlan)((Object)element);
            ModelController modelController = (ModelController)ProjectPlanningModule2Plugin.getDefault().getProjectManager().getModelController(plan.getProjectUID());
            String text = modelController.isSynchronized(plan) ? String.valueOf(plan.getName().getDisplayStringRepresentation()) + Messages.getString("ExportTaskLabelProvider.0") : plan.getName().getDisplayStringRepresentation();
            return text;
        }
        if (element instanceof Task) {
            Task task = (Task)((Object)element);
            return task.getName().getDisplayStringRepresentation();
        }
        return null;
    }

    public void addListener(ILabelProviderListener listener) {
    }

    public void dispose() {
    }

    public boolean isLabelProperty(Object element, String property) {
        return false;
    }

    public void removeListener(ILabelProviderListener listener) {
    }

    private boolean isSynchronized(ModelController modelController, ProjectPlan plan) {
        return modelController.getLinksForModuleDataItem((IModuleData)plan, "ProjectSourceFile").size() != 0;
    }
}

