/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.projectplanningmodule2.client.adapterlib.gui;

import com.arcway.cockpit.modulelib2.client.core.project.IModelController;
import com.arcway.cockpit.modulelib2.client.gui.dataview.jfaceviewer.tree.standard.StandardTreeDataViewSorter;
import com.arcway.cockpit.modulelib2.client.messages.IModuleData;
import com.arcway.cockpit.projectplanningmodule2.client.Messages;
import com.arcway.cockpit.projectplanningmodule2.client.adapterlib.gui.DataExchangeTaskTreeContentProvider;
import com.arcway.cockpit.projectplanningmodule2.client.adapterlib.gui.IProgressListener;
import com.arcway.cockpit.projectplanningmodule2.client.adapterlib.gui.ProgressListener;
import com.arcway.cockpit.projectplanningmodule2.client.adapterlib.gui.SynchronizeTaskLabelProvider;
import com.arcway.cockpit.projectplanningmodule2.client.core.project.ModelController;
import com.arcway.cockpit.projectplanningmodule2.client.messages.ProjectPlan;
import com.arcway.cockpit.projectplanningmodule2.client.messages.Task;
import com.arcway.lib.eclipse.gui.viewers.UsableCheckboxTreeViewer;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.ProgressBar;

public class ExportSelectTasksPage
extends WizardPage
implements IMenuListener {
    protected UsableCheckboxTreeViewer treeViewer;
    protected ProgressBar progressBar = null;
    protected ModelController modelController;
    private final MenuManager contextMenuMgr = new MenuManager("SelectTasksMenu");

    public ExportSelectTasksPage(String pageName, ModelController modelController) {
        super(pageName);
        this.setTitle(pageName);
        this.modelController = modelController;
        this.setPageComplete(false);
    }

    public void createControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        this.createTaskTree(composite);
        this.createProgressBar(composite);
        this.setControl((Control)composite);
    }

    protected void createTaskTree(Composite composite) {
        composite.setLayout((Layout)new GridLayout(2, false));
        GridData gridData = new GridData(1808);
        composite.setLayoutData((Object)gridData);
        this.treeViewer = new UsableCheckboxTreeViewer(composite);
        this.setContentProvider();
        this.treeViewer.setLabelProvider((IBaseLabelProvider)new SynchronizeTaskLabelProvider());
        this.treeViewer.getTree().setLayout((Layout)new GridLayout());
        gridData = new GridData(1808);
        gridData.horizontalSpan = 2;
        this.treeViewer.getTree().setLayoutData((Object)gridData);
        Menu menu = this.contextMenuMgr.createContextMenu(this.treeViewer.getControl());
        this.treeViewer.getControl().setMenu(menu);
        this.contextMenuMgr.addMenuListener((IMenuListener)this);
        this.contextMenuMgr.setRemoveAllWhenShown(true);
        this.treeViewer.setSorter((ViewerSorter)StandardTreeDataViewSorter.getSorterForNaturalOrder((IModelController)this.modelController));
        this.treeViewer.addCheckStateListener(new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent event) {
                Object element = event.getElement();
                ExportSelectTasksPage.this.treeViewer.expandToLevel(element, -1);
                ExportSelectTasksPage.this.treeViewer.setSubtreeChecked(element, event.getChecked());
                ExportSelectTasksPage.this.checkState();
            }
        });
    }

    public void checkState() {
        if (this.getSelectedTasks().isEmpty()) {
            this.setPageComplete(false);
        } else {
            this.setPageComplete(true);
        }
    }

    public void setContentProvider() {
        this.treeViewer.setContentProvider((IContentProvider)new DataExchangeTaskTreeContentProvider(true));
    }

    protected void createProgressBar(Composite composite) {
        Label progressLabel = new Label(composite, 0);
        progressLabel.setText(Messages.getString("ExportSelectTasksPage.0"));
        this.progressBar = new ProgressBar(composite, 0);
        GridData gridData = new GridData(768);
        this.progressBar.setLayoutData((Object)gridData);
    }

    public void setInput(ProjectPlan projectPlan) {
        if (this.treeViewer != null) {
            this.treeViewer.setInput((Object)projectPlan);
            this.treeViewer.expandAll();
            this.treeViewer.setSubtreeChecked((Object)projectPlan, true);
        }
        this.checkState();
    }

    public List getSelectedTasks() {
        ArrayList<Object> selectedTasks = new ArrayList<Object>();
        if (this.treeViewer != null) {
            Object[] checkedElements;
            Object[] objectArray = checkedElements = this.treeViewer.getCheckedElements();
            int n = checkedElements.length;
            int n2 = 0;
            while (n2 < n) {
                Object checkedElement = objectArray[n2];
                if (checkedElement instanceof Task) {
                    Task task = (Task)((Object)checkedElement);
                    selectedTasks.add(checkedElement);
                }
                ++n2;
            }
        }
        return selectedTasks;
    }

    public IProgressListener getProgressListener() {
        return new ProgressListener(this.progressBar);
    }

    public void menuAboutToShow(IMenuManager manager) {
        this.contextMenuMgr.add((IAction)new SelectAllAction());
        this.contextMenuMgr.add((IAction)new DeSelectAllAction());
    }

    private class DeSelectAllAction
    extends Action {
        public DeSelectAllAction() {
            super(Messages.getString("ExportSelectTasksPage.2"));
        }

        public void run() {
            Object data = ExportSelectTasksPage.this.treeViewer.getInput();
            if (data instanceof ProjectPlan) {
                ProjectPlan projectPlan = (ProjectPlan)((Object)data);
                for (Object element : ExportSelectTasksPage.this.modelController.getChildren((IModuleData)projectPlan, "ppm2.task")) {
                    ExportSelectTasksPage.this.treeViewer.setChecked(element, false);
                    ExportSelectTasksPage.this.treeViewer.setSubtreeChecked(element, false);
                    ExportSelectTasksPage.this.checkState();
                }
            }
        }
    }

    private class SelectAllAction
    extends Action {
        public SelectAllAction() {
            super(Messages.getString("ExportSelectTasksPage.1"));
        }

        public void run() {
            Object data = ExportSelectTasksPage.this.treeViewer.getInput();
            if (data instanceof ProjectPlan) {
                ProjectPlan projectPlan = (ProjectPlan)((Object)data);
                for (Object element : ExportSelectTasksPage.this.modelController.getChildren((IModuleData)projectPlan, "ppm2.task")) {
                    ExportSelectTasksPage.this.treeViewer.setChecked(element, true);
                    ExportSelectTasksPage.this.treeViewer.setSubtreeChecked(element, true);
                    ExportSelectTasksPage.this.checkState();
                }
            }
        }
    }
}

