/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.projectplanningmodule2.client.adapterlib.gui;

import com.arcway.cockpit.modulelib2.client.messages.IModuleData;
import com.arcway.cockpit.projectplanningmodule2.client.ProjectPlanningModule2Plugin;
import com.arcway.cockpit.projectplanningmodule2.client.core.project.ModelController;
import com.arcway.cockpit.projectplanningmodule2.client.messages.ProjectPlan;
import com.arcway.cockpit.projectplanningmodule2.client.messages.Task;
import com.arcway.cockpit.projectplanningmodule2.client.messages.WorkItem;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;

public class DataExchangeTaskTreeContentProvider
implements ITreeContentProvider {
    private boolean allTasks = true;

    public DataExchangeTaskTreeContentProvider(boolean allTasks) {
        this.allTasks = allTasks;
    }

    public Object[] getChildren(Object parentElement) {
        if (parentElement instanceof ProjectPlan) {
            ProjectPlan projectPlan = (ProjectPlan)((Object)parentElement);
            ModelController modelController = (ModelController)ProjectPlanningModule2Plugin.getDefault().getProjectManager().getModelController(projectPlan.getProjectUID());
            ArrayList<Task> children = new ArrayList<Task>();
            for (Object name : modelController.getChildren((IModuleData)projectPlan, "ppm2.task")) {
                Task subTask = (Task)((Object)name);
                if (!this.allTasks && subTask.hasExternalRepresentation() && !this.checkHasWorkItemInTaskTree(modelController, subTask)) continue;
                children.add(subTask);
            }
            return children.toArray();
        }
        if (parentElement instanceof Task) {
            Task task = (Task)((Object)parentElement);
            ModelController modelController = (ModelController)ProjectPlanningModule2Plugin.getDefault().getProjectManager().getModelController(task.getProjectUID());
            ArrayList<Task> children = new ArrayList<Task>();
            for (Task subTask : modelController.getTaskChildren(task)) {
                if (!this.allTasks && subTask.getExternalUID() != null && !this.checkHasWorkItemInTaskTree(modelController, subTask)) continue;
                children.add(subTask);
            }
            return children.toArray();
        }
        if (parentElement instanceof List) {
            List rootElements = (List)parentElement;
            return rootElements.toArray();
        }
        return new Object[0];
    }

    public Object getParent(Object element) {
        if (element instanceof Task) {
            Task task = (Task)((Object)element);
            ModelController modelController = (ModelController)ProjectPlanningModule2Plugin.getDefault().getProjectManager().getModelController(task.getProjectUID());
            return modelController.getParent((IModuleData)task);
        }
        return null;
    }

    public boolean hasChildren(Object element) {
        if (element instanceof ProjectPlan) {
            ProjectPlan projectPlan = (ProjectPlan)((Object)element);
            ModelController modelController = (ModelController)ProjectPlanningModule2Plugin.getDefault().getProjectManager().getModelController(projectPlan.getProjectUID());
            return !modelController.getChildren((IModuleData)projectPlan, "ppm2.task").isEmpty();
        }
        if (element instanceof Task) {
            Task task = (Task)((Object)element);
            ModelController modelController = (ModelController)ProjectPlanningModule2Plugin.getDefault().getProjectManager().getModelController(task.getProjectUID());
            return !modelController.getTaskChildren(task).isEmpty();
        }
        if (element instanceof List) {
            return ((List)element).size() > 0;
        }
        return false;
    }

    public Object[] getElements(Object inputElement) {
        return this.getChildren(inputElement);
    }

    public void dispose() {
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
    }

    private boolean checkHasWorkItemInTaskTree(ModelController modelController, Task task) {
        assert (modelController != null) : "modellController must not be null";
        assert (task != null) : "task must not be null";
        boolean hasWorkItems = false;
        Collection<WorkItem> workItems = modelController.getWorkItemChildren(task);
        if (!workItems.isEmpty()) {
            hasWorkItems = true;
        } else {
            Collection subTasks = modelController.getTaskChildren(task);
            for (Task subTask : subTasks) {
                boolean bl = hasWorkItems = hasWorkItems || this.checkHasWorkItemInTaskTree(modelController, subTask);
                if (hasWorkItems) break;
            }
        }
        return hasWorkItems;
    }
}

