/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.projectplanningmodule2.client.adapterlib.gui;

import com.arcway.cockpit.modulelib2.client.messages.IModuleData;
import com.arcway.cockpit.projectplanningmodule2.client.Messages;
import com.arcway.cockpit.projectplanningmodule2.client.adapterlib.SelectionWrapper;
import com.arcway.cockpit.projectplanningmodule2.client.core.project.ModelController;
import com.arcway.cockpit.projectplanningmodule2.client.messages.ProjectPlan;
import com.arcway.lib.io.FileSystemDefaultPaths;
import java.io.File;
import java.util.Collection;
import java.util.List;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.ProgressBar;
import org.eclipse.swt.widgets.Text;

public abstract class AbstractSelectProjectPage
extends WizardPage {
    public static final int MODE_SYNCHRONISATION = 1;
    public static final int MODE_EXPORT = 2;
    protected ModelController modelController;
    protected List<String> fileExtensions;
    private final int mode;
    protected ProgressBar progressBar;
    public org.eclipse.swt.widgets.List projectPlanList;
    private Text txtFile;
    protected boolean modifiedFileNameManually = false;

    public AbstractSelectProjectPage(String pageName, int mode, List<String> fileExtensions, ModelController modelController, boolean createProgressBar) {
        super(pageName);
        this.setTitle(pageName);
        this.setPageComplete(false);
        this.modelController = modelController;
        this.fileExtensions = fileExtensions;
        this.mode = mode;
    }

    public void createControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout gl = new GridLayout();
        gl.numColumns = 1;
        composite.setLayout((Layout)gl);
        composite.setLayoutData((Object)new GridData(1808));
        this.createProjectList(composite);
        this.createProjectPlanEntries(composite);
        this.createSelectFileWidget(composite);
        this.setControl((Control)composite);
    }

    private void createProjectList(Composite composite) {
        this.projectPlanList = new org.eclipse.swt.widgets.List(composite, 260);
        this.projectPlanList.setLayoutData((Object)new GridData(1808));
        this.projectPlanList.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetDefaultSelected(SelectionEvent e) {
                AbstractSelectProjectPage.this.projectSelectionChanged();
                AbstractSelectProjectPage.this.checkPageComplete();
            }

            public void widgetSelected(SelectionEvent e) {
                AbstractSelectProjectPage.this.projectSelectionChanged();
                AbstractSelectProjectPage.this.checkPageComplete();
            }
        });
    }

    private void createSelectFileWidget(Composite composite) {
        Composite c = new Composite(composite, 0);
        c.setLayoutData((Object)new GridData(768));
        c.setLayout((Layout)new GridLayout(3, false));
        Label lblFile = new Label(c, 0);
        lblFile.setText(Messages.getString("AbstractSelectProjectPage.1"));
        this.txtFile = new Text(c, 2048);
        this.txtFile.setLayoutData((Object)new GridData(768));
        this.txtFile.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                AbstractSelectProjectPage.this.checkPageComplete();
            }
        });
        this.txtFile.addKeyListener(new KeyListener(){

            public void keyPressed(KeyEvent e) {
                AbstractSelectProjectPage.this.modifiedFileNameManually = true;
            }

            public void keyReleased(KeyEvent e) {
                AbstractSelectProjectPage.this.modifiedFileNameManually = true;
            }
        });
        Button browseButton = new Button(c, 0);
        browseButton.setLayoutData((Object)new GridData(128));
        browseButton.setText(Messages.getString("AbstractSelectProjectPage.2"));
        browseButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                String name = AbstractSelectProjectPage.this.startFileSelectionDialog();
                if (name != "") {
                    AbstractSelectProjectPage.this.txtFile.setText(name);
                    AbstractSelectProjectPage.this.modifiedFileNameManually = true;
                }
            }
        });
    }

    protected int getSelectedProjectIndex() {
        return this.projectPlanList.getSelectionIndex();
    }

    protected String getFileName() {
        return this.txtFile.getText().trim();
    }

    protected void setFileName(String name) {
        this.txtFile.setText(name);
    }

    protected abstract void writeMessageNoProjects();

    protected abstract void createProjectPlanEntries(Composite var1);

    protected abstract void projectSelectionChanged();

    protected void addRow(ProjectPlan projectPlan) {
        assert (projectPlan != null) : "projectPlan is null";
        String name = projectPlan.getName().getDisplayStringRepresentation();
        if (this.modelController.isSynchronized(projectPlan)) {
            name = String.valueOf(name) + Messages.getString("AbstractSelectProjectPage.0");
        }
        this.projectPlanList.add(name);
    }

    private String startFileSelectionDialog() {
        FileDialog dialog = new FileDialog(this.getShell(), this.mode == 1 ? 4096 : 8192);
        String[] extensions = AbstractSelectProjectPage.getExtensionFilterForFileChooserDialogue(this.fileExtensions);
        dialog.setFilterExtensions(extensions);
        File startPath = this.mode == 1 ? FileSystemDefaultPaths.getDefaultUserPathForSynchronising() : FileSystemDefaultPaths.getDefaultUserPathForSaving();
        dialog.setFilterPath(startPath.getAbsolutePath());
        dialog.open();
        String fileName = dialog.getFileName();
        if (fileName == "") {
            return "";
        }
        if (!AbstractSelectProjectPage.filenameHasAllowedExtension(fileName, this.fileExtensions)) {
            int separatorIndex = fileName.lastIndexOf(46);
            if (separatorIndex > 0) {
                fileName = fileName.substring(0, separatorIndex);
            }
            fileName = String.valueOf(fileName) + this.fileExtensions.get(0);
        }
        String filePathName = String.valueOf(dialog.getFilterPath()) + File.separator + fileName;
        return filePathName;
    }

    protected abstract void checkPageComplete();

    protected abstract void selectionChanged();

    public SelectionWrapper getWrapper() {
        ProjectPlan projectPlan = this.getSelectedProjectPlan();
        if (projectPlan != null) {
            SelectionWrapper wrapper = new SelectionWrapper();
            wrapper.setProjectPlan(projectPlan);
            wrapper.setFileName(this.getFileName());
            Collection wrapperTasks = this.modelController.getChildren((IModuleData)projectPlan, "ppm2.task");
            wrapper.setTasksToExport(wrapperTasks);
            return wrapper;
        }
        return null;
    }

    public abstract ProjectPlan getSelectedProjectPlan();

    public static boolean filenameHasAllowedExtension(String filename, List<String> extensions) {
        String filenameLowerCase = filename.toLowerCase();
        for (String extension : extensions) {
            if (!filenameLowerCase.endsWith("." + extension.toLowerCase())) continue;
            return true;
        }
        return false;
    }

    public static String[] getExtensionFilterForFileChooserDialogue(List<String> allowedExtensions) {
        String filterString = "";
        if (allowedExtensions == null) {
            filterString = "*.*";
        } else {
            boolean first = true;
            for (String extension : allowedExtensions) {
                filterString = String.valueOf(filterString) + (!first ? ";" : "") + "*." + extension;
                if (!first) continue;
                first = false;
            }
        }
        return new String[]{filterString};
    }
}

