/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.projectplanningmodule2.client.adapterlib.gui;

import com.arcway.cockpit.projectplanningmodule2.client.Messages;
import com.arcway.cockpit.projectplanningmodule2.client.adapterlib.gui.AbstractSelectProjectPage;
import com.arcway.cockpit.projectplanningmodule2.client.adapterlib.gui.ExportWizard;
import com.arcway.cockpit.projectplanningmodule2.client.adapterlib.gui.IProgressListener;
import com.arcway.cockpit.projectplanningmodule2.client.adapterlib.gui.ProgressListener;
import com.arcway.cockpit.projectplanningmodule2.client.core.project.ModelController;
import com.arcway.cockpit.projectplanningmodule2.client.messages.ProjectPlan;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.eclipse.swt.widgets.Composite;

public abstract class AbstractExportSelectProjectPage
extends AbstractSelectProjectPage {
    private final List projectPlanCollection;
    private final ExportWizard exportWizard;

    public AbstractExportSelectProjectPage(String pageName, List<String> fileExtensions, ExportWizard exportWizard, ModelController modelController) {
        super(pageName, 2, fileExtensions, modelController, false);
        this.setPageComplete(false);
        this.exportWizard = exportWizard;
        this.projectPlanCollection = new ArrayList(modelController.getAllProjectPlans());
        Collections.sort(this.projectPlanCollection, new Comparator(){

            public int compare(Object o1, Object o2) {
                ProjectPlan p1 = (ProjectPlan)((Object)o1);
                ProjectPlan p2 = (ProjectPlan)((Object)o2);
                return p1.getName().getDisplayStringRepresentation().compareTo(p2.getName().getDisplayStringRepresentation());
            }
        });
    }

    @Override
    protected void createProjectPlanEntries(Composite parent) {
        for (ProjectPlan projectPlan : this.projectPlanCollection) {
            this.addRow(projectPlan);
        }
    }

    @Override
    protected void checkPageComplete() {
        boolean selection = false;
        boolean fileSpecified = false;
        boolean validFile = false;
        int index = this.getSelectedProjectIndex();
        if (index >= 0) {
            selection = true;
            String fileName = this.getFileName();
            if (fileName.length() > 0) {
                fileSpecified = true;
                if (AbstractSelectProjectPage.filenameHasAllowedExtension(fileName, this.fileExtensions)) {
                    validFile = true;
                }
            }
        }
        if (selection && validFile) {
            this.setMessage(null, 3);
            this.setPageComplete(true);
        } else if (!selection) {
            this.setMessage(Messages.getString("AbstractExportSelectProjectPage.2"), 3);
            this.setPageComplete(false);
        } else if (!fileSpecified) {
            this.setMessage(Messages.getString("AbstractExportSelectProjectPage.3"), 3);
            this.setPageComplete(false);
        } else {
            this.setMessage(String.valueOf(Messages.getString("AbstractExportSelectProjectPage.0")) + (String)this.fileExtensions.get(0), 3);
            this.setPageComplete(false);
        }
    }

    @Override
    public ProjectPlan getSelectedProjectPlan() {
        int index = this.getSelectedProjectIndex();
        if (index >= 0 && index < this.projectPlanCollection.size()) {
            return (ProjectPlan)((Object)this.projectPlanCollection.get(index));
        }
        return null;
    }

    @Override
    protected void projectSelectionChanged() {
        this.exportWizard.selectionChanged();
    }

    IProgressListener getProgressListener() {
        assert (this.progressBar != null);
        return new ProgressListener(this.progressBar);
    }

    @Override
    protected void selectionChanged() {
        this.exportWizard.selectionChanged();
    }

    @Override
    protected void writeMessageNoProjects() {
    }
}

