/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.projectplanningmodule2.client.adapterlib;

import com.arcway.cockpit.interFace.ICockpitProjectData;
import com.arcway.cockpit.modulelib2.client.core.project.AbstractLockManager;
import com.arcway.cockpit.modulelib2.client.core.project.LockAccess;
import com.arcway.cockpit.modulelib2.client.messages.IModuleData;
import com.arcway.cockpit.projectplanningmodule2.client.core.project.ModelController;
import com.arcway.cockpit.projectplanningmodule2.client.gui.preferences.PreferenceManager;
import com.arcway.cockpit.projectplanningmodule2.client.messages.ProjectPlan;
import com.arcway.cockpit.projectplanningmodule2.client.messages.SourceFile;
import com.arcway.cockpit.projectplanningmodule2.client.messages.Task;
import com.arcway.cockpit.projectplanningmodule2.client.messages.WorkItem;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class SynchronizeHelper {
    private final ModelController modelController;
    private final List modifiedTasks = new ArrayList();
    private final List newTasks = new ArrayList();
    Collection existingTasks;
    private final List parentChildRelationships = new ArrayList();
    private final ProjectPlan projectPlan;
    private final List locks = new ArrayList();
    private final File msProjectFile;

    public SynchronizeHelper(ModelController modelController, ProjectPlan projectPlan, File msProjectFile) {
        assert (modelController != null) : "modelController must not be null";
        assert (projectPlan != null) : "projectPlan must not be null";
        this.modelController = modelController;
        this.projectPlan = projectPlan;
        this.msProjectFile = msProjectFile;
        this.existingTasks = modelController.getAllTasksOfProject(projectPlan);
    }

    public boolean requestLocks() {
        AbstractLockManager lockMgr = this.modelController.getLockMgr();
        for (Task task : this.existingTasks) {
            LockAccess lockAccess = lockMgr.acquireEditLock((ICockpitProjectData)task);
            if (!lockAccess.hasLock()) {
                this.releaseLocks();
                return false;
            }
            this.locks.add(lockAccess);
            lockAccess = lockMgr.acquireRemoveLock((ICockpitProjectData)task);
            if (lockAccess.hasLock()) {
                this.locks.add(lockAccess);
                continue;
            }
            this.releaseLocks();
            return false;
        }
        return true;
    }

    public void releaseLocks() {
        for (LockAccess lockAccess : this.locks) {
            lockAccess.releaseLocks();
        }
    }

    public Task getExistingTaskByExternalUID(String externalUID) {
        for (Task task : this.existingTasks) {
            if (!externalUID.equals(task.getExternalUID().getValue())) continue;
            return task;
        }
        return null;
    }

    public void addImportedTask(Task task) {
        if (this.existingTasks.contains((Object)task)) {
            this.modifiedTasks.add(task);
        } else {
            this.newTasks.add(task);
        }
    }

    public void addNewTask(Task task) {
        this.newTasks.add(task);
    }

    public void taskCreatedInMSProject(Task task) {
        Task existingTask = this.findTaskByUID(task.getUID());
        if (existingTask != null) {
            existingTask.getExternalUID().setValue(task.getExternalUID().getValue());
            this.modifiedTasks.add(existingTask);
        }
    }

    public void addParentChildRelationShip(int parentID, int childID) {
        this.parentChildRelationships.add(new ParentChildIDs(parentID, childID));
    }

    public void setExternalUIDOfProjectPlan(String externalUID) {
        this.projectPlan.getExternalUID().setValue(externalUID);
    }

    public void commitToModelController() {
        this.modelController.executeTransaction(new Runnable(){

            @Override
            public void run() {
                Collection linkableObjects;
                int i = 0;
                while (i < SynchronizeHelper.this.newTasks.size()) {
                    Task task = (Task)((Object)SynchronizeHelper.this.newTasks.get(i));
                    SynchronizeHelper.this.modelController.addItem((IModuleData)task);
                    ++i;
                }
                for (Task task : SynchronizeHelper.this.modifiedTasks) {
                    SynchronizeHelper.this.modelController.itemPropertiesModified((IModuleData)task, null);
                }
                for (Task task : SynchronizeHelper.this.existingTasks) {
                    if (task.getExternalUID().getValue() == null || task.getExternalUID().getValue().length() <= 0 || SynchronizeHelper.this.modifiedTasks.contains((Object)task)) continue;
                    Collection<WorkItem> workItems = SynchronizeHelper.this.modelController.getWorkItemChildren(task);
                    if (!workItems.isEmpty()) {
                        SynchronizeHelper.this.assignWorkItemsToParentOrSibling(task, workItems);
                    }
                    SynchronizeHelper.this.modelController.deleteItem((IModuleData)task);
                }
                for (Task task : SynchronizeHelper.this.existingTasks) {
                    if (task.getExternalUID().getValue() == null || task.getExternalUID().getValue().length() <= 0) continue;
                    linkableObjects = SynchronizeHelper.this.modelController.getLinkableObjects((IModuleData)task, "TaskTask");
                    for (Task subtask : linkableObjects) {
                        if (subtask.getExternalUID().getValue() == null || subtask.getExternalUID().getValue().length() <= 0) continue;
                        SynchronizeHelper.this.modelController.deleteLink(subtask.getUID(), task.getUID(), "TaskTask");
                    }
                }
                for (Task task : SynchronizeHelper.this.existingTasks) {
                    if (task.getExternalUID().getValue() == null || task.getExternalUID().getValue().length() <= 0) continue;
                    linkableObjects = SynchronizeHelper.this.modelController.getLinkableObjects((IModuleData)task, "TaskProjectPlan");
                    for (IModuleData data : linkableObjects) {
                        SynchronizeHelper.this.modelController.deleteLink(data.getUID(), task.getUID(), "TaskProjectPlan");
                    }
                }
                i = 0;
                while (i < SynchronizeHelper.this.parentChildRelationships.size()) {
                    ParentChildIDs parentChildRelationship = (ParentChildIDs)SynchronizeHelper.this.parentChildRelationships.get(i);
                    Task parent = SynchronizeHelper.this.findTaskByID(parentChildRelationship.parentID);
                    Task child = SynchronizeHelper.this.findTaskByID(parentChildRelationship.childID);
                    if (parent != null) {
                        SynchronizeHelper.this.modelController.createLink(parent.getUID(), (IModuleData)child, "TaskTask");
                        Collection<WorkItem> workItems = SynchronizeHelper.this.modelController.getWorkItemChildren(parent);
                        if (!workItems.isEmpty()) {
                            for (WorkItem wi : workItems) {
                                SynchronizeHelper.this.modelController.deleteLink(parent.getUID(), wi.getUID(), "WorkItemTask");
                                SynchronizeHelper.this.modelController.createLink(child.getUID(), (IModuleData)wi, "WorkItemTask");
                            }
                        }
                    } else {
                        SynchronizeHelper.this.modelController.createLink(SynchronizeHelper.this.projectPlan.getUID(), (IModuleData)child, "TaskProjectPlan");
                    }
                    ++i;
                }
                SourceFile sourceFile = SynchronizeHelper.this.modelController.getSourceFile(SynchronizeHelper.this.projectPlan);
                if (sourceFile != null) {
                    if (!sourceFile.getPath().getValue().toFile().getAbsolutePath().equals(SynchronizeHelper.this.msProjectFile.getAbsolutePath())) {
                        sourceFile.getPath().setValueViaDisplayStringRepresentation(SynchronizeHelper.this.msProjectFile.getAbsolutePath());
                        SynchronizeHelper.this.modelController.itemPropertiesModified((IModuleData)sourceFile, null);
                    }
                } else {
                    sourceFile = new SourceFile();
                    sourceFile.setProjectUID(SynchronizeHelper.this.modelController.getProjectUID());
                    sourceFile.getPath().setValueViaDisplayStringRepresentation(SynchronizeHelper.this.msProjectFile.getAbsolutePath());
                    SynchronizeHelper.this.modelController.addItem((IModuleData)sourceFile);
                    SynchronizeHelper.this.modelController.createLink(sourceFile.getUID(), (IModuleData)SynchronizeHelper.this.projectPlan, "ProjectSourceFile");
                }
                SynchronizeHelper.this.modelController.propagateAttributes_completely(SynchronizeHelper.this.projectPlan, PreferenceManager.getBottomUpWorkUnit(), PreferenceManager.getTopDownWorkUnit());
            }
        });
    }

    private void assignWorkItemsToParentOrSibling(Task task, Collection workItems) {
        IModuleData o = this.modelController.getParent((IModuleData)task);
        if (o != null && o instanceof Task) {
            Task parent = (Task)o;
            for (Task child : this.modelController.getTaskChildren(parent)) {
                if (child.equals((Object)task)) continue;
                this.moveWorkItems(task, child, workItems);
                return;
            }
            this.moveWorkItems(task, parent, workItems);
            return;
        }
    }

    private void moveWorkItems(Task taskFrom, Task taskTo, Collection workItems) {
        for (WorkItem wi : workItems) {
            this.modelController.deleteLink(taskFrom.getUID(), wi.getUID(), "WorkItemTask");
            this.modelController.createLink(taskTo.getUID(), (IModuleData)wi, "WorkItemTask");
        }
    }

    private Task findTaskByID(int id) {
        for (Task task : this.newTasks) {
            if (task.getID().getValue() != id) continue;
            return task;
        }
        for (Task task : this.modifiedTasks) {
            if (task.getID().getValue() != id) continue;
            return task;
        }
        for (Task task : this.existingTasks) {
            if (task.getID().getValue() != id) continue;
            return task;
        }
        return null;
    }

    private Task findTaskByUID(String uid) {
        assert (uid != null) : "uid must not be null";
        for (Task task : this.existingTasks) {
            if (!task.getUID().equals(uid)) continue;
            return task;
        }
        return null;
    }

    private class ParentChildIDs {
        private final int parentID;
        private final int childID;

        private ParentChildIDs(int parentID, int childID) {
            this.parentID = parentID;
            this.childID = childID;
        }
    }
}

