/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.projectplanningmodule2.client.adapterlib;

import com.arcway.cockpit.modulelib2.client.messages.IModuleData;
import com.arcway.cockpit.projectplanningmodule2.client.core.project.ModelController;
import com.arcway.cockpit.projectplanningmodule2.client.gui.preferences.PreferenceManager;
import com.arcway.cockpit.projectplanningmodule2.client.messages.ProjectPlan;
import com.arcway.cockpit.projectplanningmodule2.client.messages.Task;
import java.util.ArrayList;
import java.util.List;

public class ImportHelper {
    private final ModelController modelController;
    private final List importedTasks = new ArrayList();
    private final List parentChildRelationships = new ArrayList();
    private final ProjectPlan newProjectPlan;

    public ImportHelper(ModelController modelController, ProjectPlan newProjectPlan) {
        this.modelController = modelController;
        this.newProjectPlan = newProjectPlan;
        newProjectPlan.setProjectUID(modelController.getProjectUID());
    }

    public void addTask(Task task) {
        task.setProjectUID(this.modelController.getProjectUID());
        this.importedTasks.add(task);
    }

    public void addParentChildRelationShip(int parentID, int childID) {
        this.parentChildRelationships.add(new ParentChildIDs(parentID, childID));
    }

    public void commitToModelController() {
        this.modelController.executeTransaction(new Runnable(){

            @Override
            public void run() {
                ImportHelper.this.modelController.addItem((IModuleData)ImportHelper.this.newProjectPlan);
                int i = 0;
                while (i < ImportHelper.this.importedTasks.size()) {
                    Task task = (Task)((Object)ImportHelper.this.importedTasks.get(i));
                    ImportHelper.this.modelController.addItem((IModuleData)task);
                    ++i;
                }
                i = 0;
                while (i < ImportHelper.this.parentChildRelationships.size()) {
                    ParentChildIDs parentChildRelationship = (ParentChildIDs)ImportHelper.this.parentChildRelationships.get(i);
                    Task parent = ImportHelper.this.findTaskByID(parentChildRelationship.parentID);
                    Task child = ImportHelper.this.findTaskByID(parentChildRelationship.childID);
                    if (parent != null) {
                        ImportHelper.this.modelController.createLink(parent.getUID(), (IModuleData)child, "TaskTask");
                    } else {
                        ImportHelper.this.modelController.createLink(ImportHelper.this.newProjectPlan.getUID(), (IModuleData)child, "TaskProjectPlan");
                    }
                    ++i;
                }
                ImportHelper.this.modelController.propagateAttributes_completely(ImportHelper.this.newProjectPlan, PreferenceManager.getBottomUpWorkUnit(), PreferenceManager.getTopDownWorkUnit());
            }
        });
    }

    public boolean checkIDExists(int id) {
        return this.findTaskByID(id) != null;
    }

    public int getNextFreeID(int startID) {
        int i = startID;
        while (this.checkIDExists(i)) {
            ++i;
        }
        return i;
    }

    private Task findTaskByID(int id) {
        for (Task task : this.importedTasks) {
            if (task.getID().getValue() != id) continue;
            return task;
        }
        return null;
    }

    private class ParentChildIDs {
        private final int parentID;
        private final int childID;

        private ParentChildIDs(int parentID, int childID) {
            this.parentID = parentID;
            this.childID = childID;
        }
    }
}

