/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.projectplanningmodule2.msexceladapter.importer;

import com.arcway.cockpit.frame.client.global.Icons;
import com.arcway.cockpit.frame.client.global.gui.wizards.NoLicenseWizardPage;
import com.arcway.cockpit.frame.client.global.license.IClientFunctionLicenseType;
import com.arcway.cockpit.projectplanningmodule2.client.core.project.ModelController;
import com.arcway.cockpit.projectplanningmodule2.msexceladapter.PPM2ExcelImExportLicsenseType;
import com.arcway.cockpit.projectplanningmodule2.msexceladapter.importer.MSExcelImportManager;
import com.arcway.cockpit.projectplanningmodule2.msexceladapter.importer.MSExcelImportSelectFilePage;
import com.arcway.cockpit.projectplanningmodule2.msexceladapter.importer.Messages;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;

public class MSExcelImportWizard
extends Wizard {
    private final ModelController modelController;
    private MSExcelImportSelectFilePage selectFilePage;

    public MSExcelImportWizard(ModelController modelController, String projectUID) {
        this.modelController = modelController;
        this.setWindowTitle("Import");
        this.setDefaultPageImageDescriptor(Icons.getImageDescriptorForBigImportLogo());
        this.addPages();
    }

    public void addPages() {
        if (this.modelController.getProjectAgent().getServerLicenseManager().isLicenseOperationAllowed((IClientFunctionLicenseType)PPM2ExcelImExportLicsenseType.getInstance())) {
            String title = Messages.getString("MSExcelImportWizard.0");
            this.selectFilePage = new MSExcelImportSelectFilePage(title, this.modelController);
            this.addPage((IWizardPage)this.selectFilePage);
        } else {
            NoLicenseWizardPage noLicenseWizardPage = new NoLicenseWizardPage(Messages.getString("MSExcelImportWizard.import_from_excel"), (IClientFunctionLicenseType)PPM2ExcelImExportLicsenseType.getInstance());
            this.addPage((IWizardPage)noLicenseWizardPage);
        }
    }

    public boolean performFinish() {
        if (this.selectFilePage != null) {
            String projectName = this.selectFilePage.getProjectName();
            String fileName = this.selectFilePage.getImportFileName();
            this.importTasks(projectName, fileName);
        }
        return true;
    }

    protected void importTasks(String projectName, String fileName) {
        MSExcelImportManager importManager = new MSExcelImportManager();
        importManager.importTasks(this.getShell(), projectName, fileName, this.selectFilePage.getProgressListener(), this.modelController);
    }
}

