/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.projectplanningmodule2.msexceladapter.importer;

import com.arcway.cockpit.projectplanningmodule2.client.adapterlib.gui.AbstractSelectProjectPage;
import com.arcway.cockpit.projectplanningmodule2.client.adapterlib.gui.IProgressListener;
import com.arcway.cockpit.projectplanningmodule2.client.adapterlib.gui.ProgressListener;
import com.arcway.cockpit.projectplanningmodule2.client.core.project.ModelController;
import com.arcway.cockpit.projectplanningmodule2.client.core.project.PermissionMgr;
import com.arcway.cockpit.projectplanningmodule2.msexceladapter.importer.Messages;
import com.arcway.lib.eclipse.ole.excel.util.MSExcelVersionAndSettingsHelper;
import com.arcway.lib.io.FileSystemDefaultPaths;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.ProgressBar;
import org.eclipse.swt.widgets.Text;

public class MSExcelImportSelectFilePage
extends WizardPage {
    private static final List<String> EXCEL_FILE_EXTENSIONS = new ArrayList<String>();
    protected ModelController modelController;
    protected ProgressBar progressBar;
    private Text txtProjectName;
    private Text txtFile;
    private boolean noPermission = true;

    static {
        EXCEL_FILE_EXTENSIONS.add("xls");
        if (MSExcelVersionAndSettingsHelper.getInstalledVersionOfMSExcel() >= 12) {
            EXCEL_FILE_EXTENSIONS.add("xlsx");
        }
    }

    public MSExcelImportSelectFilePage(String pageName, ModelController modelController) {
        super(pageName);
        this.modelController = modelController;
        this.setDescription(Messages.getString("MSExcelImportSelectFilePage.1"));
        this.setPageComplete(false);
        PermissionMgr permissionMgr = (PermissionMgr)modelController.getPermissionMgr();
        if (permissionMgr.mayCreateProjectPlans()) {
            this.noPermission = false;
        } else {
            this.noPermission = true;
            this.checkPageComplete();
        }
    }

    public void createControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout(3, false));
        Label lblProjectName = new Label(composite, 0);
        lblProjectName.setText(Messages.getString("MSExcelImportSelectFilePage.2"));
        this.txtProjectName = new Text(composite, 2048);
        GridData gd = new GridData();
        gd.grabExcessHorizontalSpace = true;
        gd.horizontalAlignment = 4;
        gd.horizontalSpan = 1;
        this.txtProjectName.setLayoutData((Object)gd);
        this.txtProjectName.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                MSExcelImportSelectFilePage.this.checkPageComplete();
            }
        });
        new Label(composite, 0);
        Label lblFile = new Label(composite, 0);
        lblFile.setText(Messages.getString("MSExcelImportSelectFilePage.3"));
        this.txtFile = new Text(composite, 2048);
        gd = new GridData();
        gd.grabExcessHorizontalSpace = true;
        gd.horizontalAlignment = 4;
        this.txtFile.setLayoutData((Object)gd);
        this.txtFile.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                MSExcelImportSelectFilePage.this.checkPageComplete();
            }
        });
        Button browseButton = new Button(composite, 0);
        browseButton.setLayoutData((Object)new GridData(128));
        browseButton.setText(Messages.getString("MSExcelImportSelectFilePage.4"));
        browseButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                File file = MSExcelImportSelectFilePage.this.startFileSelectionDialog();
                if (file != null) {
                    MSExcelImportSelectFilePage.this.txtFile.setText(file.getAbsolutePath());
                    if (MSExcelImportSelectFilePage.this.txtProjectName.getText().length() == 0) {
                        MSExcelImportSelectFilePage.this.txtProjectName.setText(file.getName());
                    }
                }
            }
        });
        Label progressLabel = new Label(composite, 0);
        progressLabel.setText(Messages.getString("MSExcelImportSelectFilePage.8"));
        GridData gridData = new GridData();
        gridData.horizontalSpan = 2;
        progressLabel.setLayoutData((Object)gridData);
        this.progressBar = new ProgressBar(composite, 0);
        gridData = new GridData(776);
        gridData.horizontalSpan = 2;
        this.progressBar.setLayoutData((Object)gridData);
        this.setControl((Control)composite);
    }

    private File startFileSelectionDialog() {
        FileDialog dialog = new FileDialog(this.getShell());
        String[] extensions = AbstractSelectProjectPage.getExtensionFilterForFileChooserDialogue(EXCEL_FILE_EXTENSIONS);
        dialog.setFilterExtensions(extensions);
        dialog.setFilterPath(FileSystemDefaultPaths.getDefaultUserPathForLoading().getAbsolutePath());
        dialog.open();
        String fileName = dialog.getFileName();
        if (fileName == "") {
            return null;
        }
        if (!AbstractSelectProjectPage.filenameHasAllowedExtension((String)fileName, EXCEL_FILE_EXTENSIONS)) {
            int separatorIndex = fileName.lastIndexOf(46);
            if (separatorIndex > 0) {
                fileName = fileName.substring(0, separatorIndex);
            }
            fileName = String.valueOf(fileName) + EXCEL_FILE_EXTENSIONS.get(0);
        }
        String filePathName = String.valueOf(dialog.getFilterPath()) + File.separator + fileName;
        return new File(filePathName);
    }

    protected void checkPageComplete() {
        if (this.noPermission) {
            this.setMessage(Messages.getString("MSExcelImportSelectFilePage.0"), 3);
            this.setPageComplete(false);
            return;
        }
        String projectName = this.getProjectName();
        if (projectName.length() == 0) {
            this.setMessage(Messages.getString("MSExcelImportSelectFilePage.5"), 3);
            this.setPageComplete(false);
            return;
        }
        String fileName = this.txtFile.getText().trim();
        if (fileName.length() == 0) {
            this.setMessage(Messages.getString("MSExcelImportSelectFilePage.6"), 3);
            this.setPageComplete(false);
            return;
        }
        File importFile = new File(fileName);
        if (!importFile.exists()) {
            this.setMessage(Messages.getString("MSExcelImportSelectFilePage.7"), 3);
            this.setPageComplete(false);
            return;
        }
        this.setMessage(null, 3);
        this.setPageComplete(true);
    }

    public String getProjectName() {
        return this.txtProjectName.getText().trim();
    }

    public String getImportFileName() {
        return this.txtFile.getText().trim();
    }

    IProgressListener getProgressListener() {
        assert (this.progressBar != null);
        return new ProgressListener(this.progressBar);
    }
}

