/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.projectplanningmodule2.msexceladapter.importer;

import au.com.swz.swttocom.swt.ResourceManager;
import au.com.swz.swttocom.swt.types.AutomationObjectImpl;
import com.arcway.cockpit.projectplanningmodule2.client.adapterlib.ImportHelper;
import com.arcway.cockpit.projectplanningmodule2.client.adapterlib.gui.IProgressListener;
import com.arcway.cockpit.projectplanningmodule2.client.core.project.ModelController;
import com.arcway.cockpit.projectplanningmodule2.client.messages.ProjectPlan;
import com.arcway.cockpit.projectplanningmodule2.client.messages.Task;
import com.arcway.cockpit.projectplanningmodule2.msexceladapter.MSExcelConstants;
import com.arcway.cockpit.projectplanningmodule2.msexceladapter.importer.Messages;
import com.arcway.lib.UUIDGenerator;
import com.arcway.lib.eclipse.adapter.excel.ExcelBugWorkarounds;
import com.arcway.lib.eclipse.ole.excel.Application;
import com.arcway.lib.eclipse.ole.excel.Range;
import com.arcway.lib.eclipse.ole.excel.Sheets;
import com.arcway.lib.eclipse.ole.excel.Workbook;
import com.arcway.lib.eclipse.ole.excel.Workbooks;
import com.arcway.lib.eclipse.ole.excel.Worksheet;
import com.arcway.lib.eclipse.ole.excel._Application;
import com.arcway.lib.eclipse.ole.excel.impl.RangeImpl;
import com.arcway.lib.eclipse.ole.excel.util.TypeLibPatches;
import com.arcway.lib.logging.ILogger;
import com.arcway.lib.logging.Logger;
import de.plans.lib.util.valueranges.ValueRangeHelperDuration;
import de.plans.psc.client.dialogs.swt.ExceptionDialog;
import java.io.File;
import java.io.FileNotFoundException;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.Map;
import java.util.TimeZone;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.ole.win32.Variant;
import org.eclipse.swt.widgets.Shell;

public class MSExcelImportManager {
    private static final ILogger logger = Logger.getLogger(MSExcelImportManager.class);
    private _Application app;
    private Workbooks workBooks;
    private final Map<String, String> taskColumnMap = new HashMap<String, String>();
    private static UUIDGenerator uuidGenerator = new UUIDGenerator();
    private IProgressListener progressListener = null;

    protected void importTasks(Shell shell, String newPMPName, String newPMPFile, IProgressListener p_progressListener, ModelController p_modelController) {
        assert (shell != null) : "shell is null";
        assert (p_progressListener != null);
        this.progressListener = p_progressListener;
        int parts = 2;
        if (newPMPName != null && newPMPFile != null) {
            ++parts;
        }
        p_progressListener.setProgressParts(parts);
        ResourceManager resourceManager = new ResourceManager();
        try {
            try {
                p_progressListener.setCurrentPartProgress(10);
                boolean appCreated = false;
                try {
                    this.app = Application.create((int)6, (ResourceManager)resourceManager, (boolean)true);
                    p_progressListener.setCurrentPartProgress(100);
                    appCreated = true;
                }
                catch (Exception e) {
                    p_progressListener.errorOccurred();
                    MessageDialog mDialog = new MessageDialog(shell, Messages.getString("MSExcelImportManager.Import_failed_!_2"), null, Messages.getString("MSExcelImportManager.MS_Excel_is_not_installed_on_this_computer._3"), 2, new String[]{IDialogConstants.OK_LABEL}, 0);
                    mDialog.open();
                }
                if (appCreated) {
                    this.workBooks = this.app.get_Workbooks();
                    if (newPMPName != null && newPMPFile != null) {
                        ProjectPlan newProjectPlan = new ProjectPlan();
                        newProjectPlan.getName().setValue(newPMPName);
                        newProjectPlan.setProjectUID(p_modelController.getProjectUID());
                        ImportHelper importHelper = new ImportHelper(p_modelController, newProjectPlan);
                        boolean success = this.importTasksFromMSExcel(shell, newPMPFile, importHelper, p_modelController.getProjectUID());
                        if (success) {
                            importHelper.commitToModelController();
                        }
                    }
                }
            }
            catch (Exception e) {
                p_progressListener.errorOccurred();
                ExceptionDialog dialog = new ExceptionDialog(shell, (Throwable)e);
                dialog.create();
                dialog.setTitle(Messages.getString("MSExcelImportManager.Import_failed_!_4"));
                dialog.setMessage(Messages.getString("MSExcelImportManager.Sorry,_an_unexpected_exception_occured._5"));
                dialog.open();
                if (this.app != null) {
                    this.app.Quit();
                    if (!p_progressListener.hasErrorOccured()) {
                        p_progressListener.setCurrentPartProgress(50);
                    }
                    this.app = null;
                }
                resourceManager.shutdown();
                if (!p_progressListener.hasErrorOccured()) {
                    p_progressListener.setCurrentPartProgress(100);
                }
            }
        }
        finally {
            if (this.app != null) {
                this.app.Quit();
                if (!p_progressListener.hasErrorOccured()) {
                    p_progressListener.setCurrentPartProgress(50);
                }
                this.app = null;
            }
            resourceManager.shutdown();
            if (!p_progressListener.hasErrorOccured()) {
                p_progressListener.setCurrentPartProgress(100);
            }
        }
    }

    private boolean importTasksFromMSExcel(Shell shell, String excelFile, ImportHelper importHelper, String projectUID) {
        Worksheet taskSheet;
        block14: {
            boolean requiredColumnNamesFound;
            block13: {
                assert (shell != null) : "shell is null";
                assert (excelFile != null) : "projectFile is null";
                File file = new File(excelFile);
                if (!file.exists()) {
                    throw new FileNotFoundException(Messages.getString("MSExcelImportManager.Cannot_find_the_file_specified_!_8"));
                }
                Workbook workBook = this.workBooks.Open(file.getAbsolutePath());
                Sheets workSheets = workBook.get_Sheets();
                taskSheet = null;
                requiredColumnNamesFound = false;
                int i = 1;
                while (i <= workSheets.get_Count()) {
                    Worksheet sheet = new Worksheet(((AutomationObjectImpl)workSheets.get_Item((Object)i)).getOleAutomation(), workSheets.getResourceManager());
                    String sheetName = sheet.get_Name();
                    if (MSExcelConstants.SHEET_TASKS.equals(sheetName)) {
                        taskSheet = sheet;
                        Range headerRange = sheet.get_Range((Object)"A1:T1");
                        int j = 1;
                        while (j <= 20) {
                            String columnName;
                            RangeImpl headerCell = new RangeImpl(headerRange.get_Item((Object)j), headerRange.getResourceManager());
                            String address = TypeLibPatches.Range_GetAddress((Range)headerCell);
                            String columnChar = address.substring(1, 2);
                            Variant columnNameVariant = headerCell.get_Value();
                            String string = columnName = columnNameVariant != null ? columnNameVariant.getString() : null;
                            if (MSExcelConstants.TASK_COLUMN_NAME.equals(columnName) || MSExcelConstants.TASK_COLUMN_ID.equals(columnName)) {
                                requiredColumnNamesFound = true;
                            }
                            this.taskColumnMap.put(columnName, columnChar);
                            ++j;
                        }
                    }
                    ++i;
                }
                this.progressListener.setCurrentPartProgress(50);
                if (taskSheet != null) break block13;
                MessageDialog mDialog = new MessageDialog(shell, Messages.getString("MSExcelImportManager.Import_failed_!_10"), null, String.valueOf(Messages.getString("MSExcelImportManager.The_import_from_file___11")) + excelFile + Messages.getString("MSExcelImportManager._failed._12") + Messages.getString("MSExcelImportManager.No_sheet_with_name__13") + MSExcelConstants.SHEET_TASKS + Messages.getString("MSExcelImportManager.found._14"), 2, new String[]{IDialogConstants.OK_LABEL}, 0);
                mDialog.open();
                this.progressListener.setCurrentPartProgress(100);
                return false;
            }
            if (requiredColumnNamesFound) break block14;
            MessageDialog mDialog = new MessageDialog(shell, Messages.getString("MSExcelImportManager.1"), null, String.valueOf(Messages.getString("MSExcelImportManager.2")) + excelFile + Messages.getString("MSExcelImportManager.3") + Messages.getString("MSExcelImportManager.4") + Messages.getString("MSExcelImportManager.5"), 2, new String[]{IDialogConstants.OK_LABEL}, 0);
            mDialog.open();
            this.progressListener.setCurrentPartProgress(100);
            return false;
        }
        try {
            int emptyRows = 0;
            int row = 2;
            while (emptyRows < 11) {
                emptyRows = !this.readTaskRow(shell, taskSheet, row, importHelper, projectUID) ? ++emptyRows : 0;
                ++row;
            }
            this.progressListener.setCurrentPartProgress(100);
            return true;
        }
        catch (FileNotFoundException e) {
            MessageDialog mDialog = new MessageDialog(shell, Messages.getString("MSExcelImportManager.Import_failed_!_15"), null, String.valueOf(Messages.getString("MSExcelImportManager.The_import_from_file___16")) + excelFile + Messages.getString("MSExcelImportManager._failed._17") + e.getMessage(), 2, new String[]{IDialogConstants.OK_LABEL}, 0);
            mDialog.open();
            if (!this.progressListener.isCurrentPartComplete()) {
                this.progressListener.setCurrentPartProgress(100);
            }
            return false;
        }
    }

    private boolean readTaskRow(Shell shell, Worksheet sheet, int row, ImportHelper importHelper, String projectUID) {
        assert (shell != null);
        assert (sheet != null);
        assert (row > 0);
        Task task = new Task();
        String nameColumn = this.taskColumnMap.get(MSExcelConstants.TASK_COLUMN_NAME);
        Range nameCell = sheet.get_Range((Object)(nameColumn + row));
        String name = ExcelBugWorkarounds.cell_get_Text((Range)nameCell);
        if (name == null || "".equals(name.trim())) {
            return false;
        }
        name = name.trim();
        task.getName().setValue(name);
        try {
            for (String columnName : this.taskColumnMap.keySet()) {
                Variant variant;
                String columnChar = this.taskColumnMap.get(columnName);
                Range currentCell = sheet.get_Range((Object)(columnChar + row));
                if (MSExcelConstants.TASK_COLUMN_ID.equals(columnName)) {
                    String value = ExcelBugWorkarounds.cell_get_Text((Range)nameCell);
                    int id = 0;
                    try {
                        id = Integer.parseInt(value);
                    }
                    catch (NumberFormatException e) {
                        id = 1;
                    }
                    if (importHelper.checkIDExists(id)) {
                        id = importHelper.getNextFreeID(id);
                    }
                    task.getID().setValue(id);
                    continue;
                }
                if (MSExcelConstants.TASK_COLUMN_WORK.equals(columnName)) {
                    ValueRangeHelperDuration vrh;
                    variant = currentCell.get_Value();
                    Number obj = null;
                    if (variant != null && variant.getType() == 4) {
                        obj = Float.valueOf(variant.getFloat());
                    } else if (variant != null && variant.getType() == 5) {
                        obj = variant.getDouble();
                    }
                    if (obj instanceof Float) {
                        Float value = obj;
                        vrh = (ValueRangeHelperDuration)task.getOriginalWork().getValueRangeHelper();
                        vrh.setDurationInSpecificUnit(1, (long)value.floatValue());
                        continue;
                    }
                    if (obj instanceof Double) {
                        Double value = (Double)obj;
                        vrh = (ValueRangeHelperDuration)task.getOriginalWork().getValueRangeHelper();
                        vrh.setDurationInSpecificUnit(1, (long)value.doubleValue());
                        continue;
                    }
                    task.getOriginalWork().setValue(0L);
                    logger.warn("PMM - Excel Import - readTaskRow(int row = " + row + ") Failed parsing field: columnName = " + columnName + " for Task: " + task.getName().getDisplayStringRepresentation(), null);
                    continue;
                }
                if (MSExcelConstants.TASK_COLUMN_RESOURCE_NAMES.equals(columnName)) {
                    String obj;
                    variant = currentCell.get_Value();
                    String string = obj = variant != null && variant.getType() == 8 ? variant.getString() : null;
                    if (obj instanceof String) {
                        String value = obj;
                        task.getResourceNames().setValue(value);
                        continue;
                    }
                    task.getResourceNames().setValue("");
                    continue;
                }
                if (MSExcelConstants.TASK_COLUMN_START.equals(columnName)) {
                    variant = currentCell.get_Value();
                    Object obj = null;
                    if (variant != null && variant.getType() == 4) {
                        obj = Float.valueOf(variant.getFloat());
                    } else if (variant != null && variant.getType() != 1) {
                        obj = new Object();
                    }
                    if (obj == null) {
                        task.isMilestone().setValue(true);
                        continue;
                    }
                    if (obj instanceof Float) {
                        long value = this.computeDate((Float)obj);
                        task.getStart().setValue(value);
                        continue;
                    }
                    logger.warn("PMM - Excel Import - readTaskRow(int row = " + row + ") Failed parsing field: columnName = " + columnName + " for Task: " + task.getName().getDisplayStringRepresentation(), null);
                    continue;
                }
                if (MSExcelConstants.TASK_COLUMN_FINISH.equals(columnName)) {
                    Float obj;
                    variant = currentCell.get_Value();
                    Float f = obj = variant != null && variant.getType() == 4 ? Float.valueOf(variant.getFloat()) : null;
                    if (obj instanceof Float) {
                        long value = this.computeDate(obj);
                        task.getFinish().setValue(value);
                        continue;
                    }
                    logger.warn("PMM - Excel Import - readTaskRow(int row = " + row + ") Failed parsing field: columnName = " + columnName + " for Task: " + task.getName().getDisplayStringRepresentation(), null);
                    continue;
                }
                if (MSExcelConstants.TASK_COLUMN_PRIORITY.equals(columnName)) {
                    variant = currentCell.get_Value();
                    Number obj = null;
                    if (variant != null && variant.getType() == 4) {
                        obj = Float.valueOf(variant.getFloat());
                    } else if (variant != null && variant.getType() == 5) {
                        obj = variant.getDouble();
                    }
                    if (obj instanceof Float) {
                        Float value = obj;
                        task.getPriority().setValue(value.intValue());
                        continue;
                    }
                    if (obj instanceof Double) {
                        Double value = (Double)obj;
                        task.getPriority().setValue(value.intValue());
                        continue;
                    }
                    task.getPriority().setValue(0);
                    logger.warn("PMM - Excel Import - readTaskRow(int row = " + row + ") Failed parsing field: columnName = " + columnName + " for Task: " + task.getName().getDisplayStringRepresentation(), null);
                    continue;
                }
                if (MSExcelConstants.TASK_COLUMN_CRITICAL.equals(columnName)) {
                    String obj;
                    variant = currentCell.get_Value();
                    String string = obj = variant != null && variant.getType() == 8 ? variant.getString() : null;
                    if (!(obj instanceof String)) continue;
                    String value = obj;
                    if (Messages.getString("MSExcelImportManager.yes_1").equalsIgnoreCase(value)) {
                        task.isCritical().setValue(true);
                        continue;
                    }
                    task.isCritical().setValue(false);
                    continue;
                }
                MSExcelConstants.TASK_COLUMN_WORK_ITEMS.equals(columnName);
            }
            task.setUid(uuidGenerator.getUUID());
            task.setProjectUID(projectUID);
            importHelper.addTask(task);
            importHelper.addParentChildRelationShip(-1, task.getID().getValue());
            return true;
        }
        catch (RuntimeException e) {
            MessageDialog mDialog = new MessageDialog(shell, Messages.getString("MSExcelImportManager.Import_47"), null, String.valueOf(Messages.getString("MSExcelImportManager.0")) + task.getID().getDisplayStringRepresentation() + task.getName().getDisplayStringRepresentation(), 2, new String[]{IDialogConstants.OK_LABEL}, 0);
            mDialog.open();
            return false;
        }
    }

    private long computeDate(Float date) {
        GregorianCalendar calendar = new GregorianCalendar(TimeZone.getDefault());
        calendar.set(1899, 11, 31);
        int days = date.intValue() - 1;
        ((Calendar)calendar).add(5, days);
        return calendar.getTimeInMillis();
    }
}

