/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.projectplanningmodule2.msexceladapter.exporter;

import au.com.swz.swttocom.swt.ResourceManager;
import au.com.swz.swttocom.swt.types.AutomationObjectImpl;
import com.arcway.cockpit.client.base.interfaces.frame.datamanagement.stakeholders.IStakeholder;
import com.arcway.cockpit.modulelib2.client.messages.IModuleData;
import com.arcway.cockpit.projectplanningmodule2.client.adapterlib.SelectionWrapper;
import com.arcway.cockpit.projectplanningmodule2.client.adapterlib.gui.IProgressListener;
import com.arcway.cockpit.projectplanningmodule2.client.core.project.ModelController;
import com.arcway.cockpit.projectplanningmodule2.client.messages.Task;
import com.arcway.cockpit.projectplanningmodule2.client.messages.WorkItem;
import com.arcway.cockpit.projectplanningmodule2.client.messages.WorkItemCategory;
import com.arcway.cockpit.projectplanningmodule2.msexceladapter.MSExcelConstants;
import com.arcway.cockpit.projectplanningmodule2.msexceladapter.PPM2MicrosoftExcelAdapterPlugin;
import com.arcway.cockpit.projectplanningmodule2.msexceladapter.exporter.Messages;
import com.arcway.lib.eclipse.ole.excel.Application;
import com.arcway.lib.eclipse.ole.excel.Range;
import com.arcway.lib.eclipse.ole.excel.Sheets;
import com.arcway.lib.eclipse.ole.excel.Workbook;
import com.arcway.lib.eclipse.ole.excel.Workbooks;
import com.arcway.lib.eclipse.ole.excel.Worksheet;
import com.arcway.lib.eclipse.ole.excel._Application;
import com.arcway.lib.eclipse.ole.excel.impl.RangeImpl;
import com.arcway.lib.eclipse.ole.excel.util.TypeLibPatches;
import com.arcway.lib.io.FileHelper;
import com.arcway.lib.resource.JvmExternalResourceInteractionException;
import de.plans.lib.util.LocalisationUtils;
import de.plans.lib.util.valueranges.ValueRangeHelperDuration;
import de.plans.psc.client.dialogs.swt.ExceptionDialog;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.ole.win32.Variant;
import org.eclipse.swt.widgets.Shell;

public class MSExcelExportManager {
    private _Application app;
    Workbooks workBooks;
    private IProgressListener progressListener = null;
    private final Map<String, String> taskColumnMap = new HashMap<String, String>();
    private final Map<String, String> workItemColumnMap = new HashMap<String, String>();

    public void export(Shell shell, SelectionWrapper exportWrapper, IProgressListener progressListener, ModelController modelController) {
        assert (shell != null) : "shell is null";
        assert (exportWrapper != null) : "exportWrapper list is null";
        assert (progressListener != null) : "progress listner is null";
        assert (modelController != null) : "modelController is null";
        this.progressListener = progressListener;
        int parts = 2;
        progressListener.setProgressParts(parts);
        ResourceManager resourceManager = new ResourceManager();
        try {
            try {
                progressListener.setCurrentPartProgress(10);
                boolean appCreated = false;
                try {
                    this.app = Application.create((int)6, (ResourceManager)resourceManager, (boolean)true);
                    progressListener.setCurrentPartProgress(100);
                    appCreated = true;
                }
                catch (Exception e) {
                    progressListener.errorOccurred();
                    MessageDialog mDialog = new MessageDialog(shell, Messages.getString("MSExcelExportManager.Export_failed_!_4"), null, Messages.getString("MSExcelExportManager.MS_Excel_is_not_installed_on_this_computer._5"), 2, new String[]{IDialogConstants.OK_LABEL}, 0);
                    mDialog.open();
                }
                if (appCreated) {
                    this.workBooks = this.app.get_Workbooks();
                    this.exportTasksToMSExcelFile(shell, exportWrapper, modelController);
                }
            }
            catch (Exception e) {
                progressListener.errorOccurred();
                ExceptionDialog dialog = new ExceptionDialog(shell, (Throwable)e);
                dialog.create();
                dialog.setTitle(Messages.getString("MSExcelExportManager.Export_failed_!_6"));
                dialog.setMessage(Messages.getString("MSExcelExportManager.Sorry,_an_unexpected_exception_occured._7"));
                dialog.open();
                if (this.workBooks != null) {
                    this.workBooks.Close();
                }
                if (this.app != null) {
                    this.app.Quit();
                    if (!progressListener.hasErrorOccured()) {
                        progressListener.setCurrentPartProgress(50);
                    }
                    this.app = null;
                }
                resourceManager.shutdown();
                if (!progressListener.hasErrorOccured()) {
                    progressListener.setCurrentPartProgress(100);
                }
            }
        }
        finally {
            if (this.workBooks != null) {
                this.workBooks.Close();
            }
            if (this.app != null) {
                this.app.Quit();
                if (!progressListener.hasErrorOccured()) {
                    progressListener.setCurrentPartProgress(50);
                }
                this.app = null;
            }
            resourceManager.shutdown();
            if (!progressListener.hasErrorOccured()) {
                progressListener.setCurrentPartProgress(100);
            }
        }
    }

    private boolean exportTasksToMSExcelFile(Shell shell, SelectionWrapper wrapper, ModelController modelController) {
        Worksheet workItemSheet;
        Worksheet taskSheet;
        Workbook workBook;
        File file;
        block24: {
            String fileName;
            block23: {
                String question;
                assert (shell != null) : "shell is null";
                assert (wrapper != null) : "export wrapper object is null";
                assert (modelController != null) : "modelController object is null";
                fileName = wrapper.getFileName();
                file = new File(fileName);
                if (!file.exists()) break block23;
                String title = Messages.getString("MSExcelExportManager.0");
                if (MessageDialog.openQuestion((Shell)shell, (String)title, (String)(question = String.valueOf(Messages.getString("MSExcelExportManager.1")) + wrapper.getFileName() + Messages.getString("MSExcelExportManager.2") + Messages.getString("MSExcelExportManager.3")))) {
                    try {
                        FileHelper.deleteExistingFileOrDirectory((File)file);
                        break block23;
                    }
                    catch (JvmExternalResourceInteractionException e) {
                        MessageDialog.openError((Shell)shell, (String)Messages.getString("MSExcelExportManager.UnableToDeleteTargetTitle"), (String)NLS.bind((String)Messages.getString("MSExcelExportManager.UnableToDeleteTargetMessage"), (Object)file.getPath()));
                        return false;
                    }
                }
                return false;
            }
            file = PPM2MicrosoftExcelAdapterPlugin.getExcelTemplate();
            workBook = this.workBooks.Open(file.getAbsolutePath());
            TypeLibPatches.Workbook_SaveAs((Workbook)workBook, (String)fileName);
            file = new File(fileName);
            Sheets workSheets = workBook.get_Sheets();
            taskSheet = null;
            workItemSheet = null;
            int numSheets = workSheets.get_Count();
            int i = 1;
            while (i <= numSheets) {
                String columnName;
                Variant columnNameVariant;
                String columnChar;
                String address;
                RangeImpl headerCell;
                int j;
                Range headerRange;
                Worksheet sheet = new Worksheet(((AutomationObjectImpl)workSheets.get_Item((Object)i)).getOleAutomation(), workSheets.getResourceManager());
                String sheetName = sheet.get_Name();
                if (MSExcelConstants.SHEET_TASKS.equals(sheetName)) {
                    taskSheet = sheet;
                    headerRange = sheet.get_Range((Object)"A1:T1");
                    j = 1;
                    while (j <= 20) {
                        headerCell = new RangeImpl(headerRange.get_Item((Object)j), headerRange.getResourceManager());
                        address = TypeLibPatches.Range_GetAddress((Range)headerCell);
                        columnChar = address.substring(1, 2);
                        columnNameVariant = headerCell.get_Value();
                        columnName = columnNameVariant != null ? columnNameVariant.getString() : null;
                        this.taskColumnMap.put(columnName, columnChar);
                        ++j;
                    }
                } else if (MSExcelConstants.SHEET_WORK_ITEMS.equals(sheetName)) {
                    workItemSheet = sheet;
                    headerRange = sheet.get_Range((Object)"A1:T1");
                    j = 1;
                    while (j <= 20) {
                        headerCell = new RangeImpl(headerRange.get_Item((Object)j), headerRange.getResourceManager());
                        address = TypeLibPatches.Range_GetAddress((Range)headerCell);
                        columnChar = address.substring(1, 2);
                        columnNameVariant = headerCell.get_Value();
                        columnName = columnNameVariant != null ? columnNameVariant.getString() : null;
                        this.workItemColumnMap.put(columnName, columnChar);
                        ++j;
                    }
                    int rowCount = workItemSheet.get_Rows().get_Count();
                    if (rowCount > 0) {
                        Range clearRange = workItemSheet.get_Range((Object)("A2:T" + rowCount));
                        clearRange.set_Value((Object)"");
                    }
                }
                ++i;
            }
            if (taskSheet != null && workItemSheet != null) break block24;
            MessageDialog mDialog = new MessageDialog(shell, Messages.getString("MSExcelExportManager.Export_failed_!_12"), null, String.valueOf(Messages.getString("MSExcelExportManager.The_export_to_file___13")) + wrapper.getFileName() + Messages.getString("MSExcelExportManager._failed._14") + Messages.getString("MSExcelExportManager.Invalid_template_file._15"), 2, new String[]{IDialogConstants.OK_LABEL}, 0);
            mDialog.open();
            return false;
        }
        try {
            int currentWorkItemRow = 3;
            String pmProjectUID = wrapper.getProjectPlan().getUID();
            assert (pmProjectUID != null);
            ArrayList tasks = new ArrayList(wrapper.getTasksToExport());
            Collections.sort(tasks, new Comparator<Task>(){

                @Override
                public int compare(Task o1, Task o2) {
                    int task1 = o1.getID().getValue();
                    int task2 = o2.getID().getValue();
                    return task1 - task2;
                }
            });
            int i = 0;
            while (i < tasks.size()) {
                Task task = (Task)tasks.get(i);
                ArrayList workItems = new ArrayList(modelController.getWorkItemChildren(task));
                this.writeTask(shell, file, taskSheet, task, i + 2, workItems.size(), currentWorkItemRow, modelController);
                int k = 0;
                while (k < workItems.size()) {
                    WorkItem workItem = (WorkItem)workItems.get(k);
                    this.writeWorkItem(shell, file, workItemSheet, workItem, task, i + 2, currentWorkItemRow, modelController);
                    ++currentWorkItemRow;
                    if (k == workItems.size() - 1) {
                        ++currentWorkItemRow;
                    }
                    ++k;
                }
                ++i;
            }
            ArrayList workItems = new ArrayList(modelController.getUnassignedWorkItems());
            int k = 0;
            while (k < workItems.size()) {
                WorkItem workItem = (WorkItem)workItems.get(k);
                this.writeWorkItem(shell, file, workItemSheet, workItem, null, 0, currentWorkItemRow, modelController);
                ++currentWorkItemRow;
                ++k;
            }
            this.progressListener.setCurrentPartProgress(20);
            workBook.Save();
            workBook.Close();
            this.progressListener.setCurrentPartProgress(100);
            return true;
        }
        catch (Exception e) {
            MessageDialog mDialog = new MessageDialog(shell, Messages.getString("MSExcelExportManager.Export_failed_!_16"), null, String.valueOf(Messages.getString("MSExcelExportManager.The_export_to_file___17")) + wrapper.getFileName() + Messages.getString("MSExcelExportManager._failed.__n(__18") + e.getMessage() + Messages.getString("MSExcelExportManager._)_19"), 2, new String[]{IDialogConstants.OK_LABEL}, 0);
            mDialog.open();
            if (!this.progressListener.isCurrentPartComplete()) {
                this.progressListener.setCurrentPartProgress(100);
            }
            return false;
        }
    }

    private void writeWorkItem(Shell shell, File file, Worksheet sheet, WorkItem workItem, Task task, int taskRow, int rowNumber, ModelController modelController) {
        assert (shell != null);
        assert (file != null);
        assert (sheet != null);
        assert (workItem != null);
        assert (rowNumber > 0);
        try {
            for (Map.Entry<String, String> entry : this.workItemColumnMap.entrySet()) {
                String value;
                ValueRangeHelperDuration vrh;
                String value2;
                String columnName = entry.getKey();
                String columnChar = entry.getValue();
                Range currentCell = sheet.get_Range((Object)(columnChar + rowNumber));
                if (MSExcelConstants.WORK_ITEM_COLUMN_TASK.equals(columnName)) {
                    if (task != null) {
                        currentCell.set_Value((Object)task.getName().getDisplayStringRepresentation());
                        String taskColumn = this.taskColumnMap.get(MSExcelConstants.TASK_COLUMN_NAME);
                        String formula = "=HYPERLINK(\"[" + file.getName() + "]" + MSExcelConstants.SHEET_TASKS + "!" + taskColumn + taskRow + "\";\"" + task.getName().getDisplayStringRepresentation() + "\")";
                        currentCell.set_Formula((Object)formula);
                        continue;
                    }
                    currentCell.set_Value((Object)"");
                    continue;
                }
                if (MSExcelConstants.WORK_ITEM_COLUMN_NAME.equals(columnName)) {
                    value2 = workItem.getName().getDisplayStringRepresentation();
                    currentCell.set_Value((Object)value2);
                    continue;
                }
                if (MSExcelConstants.WORK_ITEM_COLUMN_PERCENT_WORK_COMPLETE.equals(columnName)) {
                    value2 = workItem.calculatePercentWorkComplete().getDisplayStringRepresentation();
                    currentCell.set_Formula((Object)("=" + value2));
                    continue;
                }
                if (MSExcelConstants.WORK_ITEM_COLUMN_WORK_DONE.equals(columnName)) {
                    vrh = (ValueRangeHelperDuration)workItem.getWorkDone().getValueRangeHelper();
                    value = String.valueOf(vrh.getDurationInSpecificUnit(1));
                    currentCell.set_Formula((Object)("=" + value));
                    continue;
                }
                if (MSExcelConstants.WORK_ITEM_COLUMN_WORK_REMAINING.equals(columnName)) {
                    vrh = (ValueRangeHelperDuration)workItem.getWorkRemaining().getValueRangeHelper();
                    value = String.valueOf(vrh.getDurationInSpecificUnit(1));
                    currentCell.set_Formula((Object)("=" + value));
                    continue;
                }
                if (MSExcelConstants.WORK_ITEM_COLUMN_WORK.equals(columnName)) {
                    vrh = (ValueRangeHelperDuration)workItem.calculateForecast().getValueRangeHelper();
                    value = String.valueOf(vrh.getDurationInSpecificUnit(1));
                    currentCell.set_Formula((Object)("=" + value));
                    continue;
                }
                if (MSExcelConstants.WORK_ITEM_COLUMN_WORK_ESTIMATED.equals(columnName)) {
                    vrh = (ValueRangeHelperDuration)workItem.getWorkEstimated().getValueRangeHelper();
                    value = String.valueOf(vrh.getDurationInSpecificUnit(1));
                    currentCell.set_Formula((Object)("=" + value));
                    continue;
                }
                if (MSExcelConstants.WORK_ITEM_COLUMN_RESOURCE_NAMES.equals(columnName)) {
                    String stakeholderName = null;
                    IStakeholder stakeholder = modelController.getStakeholderForWorkItem(workItem);
                    if (stakeholder != null) {
                        stakeholderName = stakeholder.getStakeholderName();
                    }
                    String resources = workItem.getResources().getValue();
                    String result = stakeholderName != null && stakeholderName.length() > 0 && resources != null && resources.length() > 0 ? String.valueOf(stakeholderName) + ", " + resources : (stakeholderName != null && stakeholderName.length() > 0 ? stakeholderName : (resources != null && resources.length() > 0 ? resources : ""));
                    currentCell.set_Value((Object)result);
                    continue;
                }
                if (!MSExcelConstants.WORK_ITEM_COLUMN_CATEGORY.equals(columnName)) continue;
                WorkItemCategory category = modelController.getCategory(workItem);
                if (category == null) {
                    category = new WorkItemCategory();
                }
                currentCell.set_Value((Object)category.getDisplayRepresentation());
            }
        }
        catch (RuntimeException e) {
            MessageDialog mDialog = new MessageDialog(shell, Messages.getString("MSExcelExportManager.Export_34"), null, String.valueOf(Messages.getString("MSExcelExportManager.Failed_to_export_Work_Item___35")) + workItem.getName(), 2, new String[]{IDialogConstants.OK_LABEL}, 0);
            mDialog.open();
            e.printStackTrace();
        }
    }

    private void writeTask(Shell shell, File file, Worksheet sheet, Task task, int rowNumber, int workItems, int workItemRow, ModelController modelController) {
        assert (shell != null);
        assert (file != null);
        assert (sheet != null);
        assert (task != null);
        assert (rowNumber > 0);
        try {
            for (Map.Entry<String, String> entry : this.taskColumnMap.entrySet()) {
                String value;
                ValueRangeHelperDuration vrh;
                String columnName = entry.getKey();
                String columnChar = entry.getValue();
                Range currentCell = sheet.get_Range((Object)(columnChar + rowNumber));
                if (MSExcelConstants.TASK_COLUMN_ID.equals(columnName)) {
                    currentCell.set_Value((Object)task.getID().getDisplayStringRepresentation());
                    continue;
                }
                if (MSExcelConstants.TASK_COLUMN_NAME.equals(columnName)) {
                    StringBuffer valueBuffer = new StringBuffer();
                    Object parent = null;
                    IModuleData o = modelController.getParent((IModuleData)task);
                    if (o instanceof Task) {
                        parent = (Task)o;
                    }
                    while (parent != null) {
                        valueBuffer.append("     ");
                        o = modelController.getParent((IModuleData)parent);
                        parent = o instanceof Task ? (Task)o : null;
                    }
                    valueBuffer.append(task.getName().getDisplayStringRepresentation());
                    currentCell.set_Value((Object)valueBuffer.toString());
                    continue;
                }
                if (MSExcelConstants.TASK_COLUMN_PERCENT_WORK_COMPLETE.equals(columnName)) {
                    if (task.isMilestone().getValue() || task.calculateWorkForecast().getValue() <= 0L) continue;
                    String columnWork = this.taskColumnMap.get(MSExcelConstants.TASK_COLUMN_WORK);
                    String columnWorkDone = this.taskColumnMap.get(MSExcelConstants.TASK_COLUMN_WORK_DONE);
                    if (columnWork != null && columnWorkDone != null) {
                        String formula = "=100*" + columnWorkDone + rowNumber + "/" + columnWork + rowNumber;
                        currentCell.set_Formula((Object)formula);
                        continue;
                    }
                    String value2 = String.valueOf(task.calculatePercentWorkComplete());
                    currentCell.set_Value((Object)value2);
                    continue;
                }
                if (MSExcelConstants.TASK_COLUMN_WORK.equals(columnName)) {
                    if (task.isMilestone().getValue()) continue;
                    vrh = (ValueRangeHelperDuration)task.calculateWorkForecast().getValueRangeHelper();
                    currentCell.set_Value((Object)new Float(vrh.getDurationInSpecificUnit(1)));
                    continue;
                }
                if (MSExcelConstants.TASK_COLUMN_WORK_DONE.equals(columnName)) {
                    if (task.isMilestone().getValue()) continue;
                    vrh = (ValueRangeHelperDuration)task.getWorkDone().getValueRangeHelper();
                    currentCell.set_Value((Object)new Float(vrh.getDurationInSpecificUnit(1)));
                    continue;
                }
                if (MSExcelConstants.TASK_COLUMN_RESOURCE_NAMES.equals(columnName)) {
                    if (task.isMilestone().getValue()) continue;
                    String resourceNames = task.getResourceNameDisplayRepresentation();
                    if (resourceNames == null || resourceNames.length() == 0) {
                        resourceNames = modelController.getStakeholdersAndResourcesAsString(task);
                    }
                    currentCell.set_Value((Object)resourceNames);
                    continue;
                }
                if (MSExcelConstants.TASK_COLUMN_START.equals(columnName)) {
                    if (task.isMilestone().getValue() || task.getStart() == null) continue;
                    value = task.getStart().getDisplayStringRepresentation();
                    currentCell.set_Value((Object)value);
                    continue;
                }
                if (MSExcelConstants.TASK_COLUMN_FINISH.equals(columnName)) {
                    if (task.getFinish() == null) continue;
                    value = task.getFinish().getDisplayStringRepresentation();
                    currentCell.set_Value((Object)value);
                    continue;
                }
                if (MSExcelConstants.TASK_COLUMN_DURATION.equals(columnName)) {
                    if (task.isMilestone().getValue()) continue;
                    vrh = (ValueRangeHelperDuration)task.calculateDuration().getValueRangeHelper();
                    String value3 = LocalisationUtils.roundLocalizedWithoutGrouping((double)vrh.getDurationInSpecificUnit(1), (int)2, (boolean)true);
                    currentCell.set_Value((Object)value3);
                    continue;
                }
                if (MSExcelConstants.TASK_COLUMN_CRITICAL.equals(columnName)) {
                    value = task.isCritical().getValue() ? Messages.getString("MSExcelExportManager.4") : Messages.getString("MSExcelExportManager.5");
                    currentCell.set_Value((Object)value);
                    continue;
                }
                if (MSExcelConstants.TASK_COLUMN_PRIORITY.equals(columnName)) {
                    value = Integer.toString(task.getPriority().getValue());
                    currentCell.set_Value((Object)value);
                    continue;
                }
                if (!MSExcelConstants.TASK_COLUMN_WORK_ITEMS.equals(columnName) || task.isMilestone().getValue()) continue;
                currentCell.set_Value((Object)(String.valueOf(Messages.getString("MSExcelExportManager.6")) + workItems + ")"));
                if (workItems <= 0) continue;
                String wiColumn = this.workItemColumnMap.get(MSExcelConstants.WORK_ITEM_COLUMN_TASK);
                String formula = "=HYPERLINK(\"[" + file.getName() + "]" + MSExcelConstants.SHEET_WORK_ITEMS + "!" + wiColumn + workItemRow + "\";\"" + Messages.getString("MSExcelExportManager.9") + workItems + ")\")";
                currentCell.set_Formula((Object)formula);
            }
        }
        catch (RuntimeException e) {
            MessageDialog mDialog = new MessageDialog(shell, Messages.getString("MSExcelExportManager.Export_48"), null, String.valueOf(Messages.getString("MSExcelExportManager.Failed_to_export_Task___49")) + task.getID().getDisplayStringRepresentation() + task.getName().getDisplayStringRepresentation(), 2, new String[]{IDialogConstants.OK_LABEL}, 0);
            mDialog.open();
        }
    }
}

