/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.projectplanningmodule2.docgen.provider;

import com.arcway.cockpit.docgen.graphicsandfiles.IGraphicsAndFilesHelper;
import com.arcway.cockpit.docgen.provider.HistoryEntry;
import com.arcway.cockpit.docgen.provider.UniqueElementDocGenProxy;
import com.arcway.cockpit.docgen.provider.interfaces.IModelElement;
import com.arcway.cockpit.docgen.provider.interfaces.IRecord;
import com.arcway.cockpit.docgen.provider.utils.MultilineTextOutputHelper;
import com.arcway.cockpit.frame.client.project.IFrameProjectAgent;
import com.arcway.cockpit.frame.client.project.core.uniqueelements.IUniqueElement;
import com.arcway.cockpit.frame.client.project.docgenerator.DocGeneratorProjectAgent;
import com.arcway.cockpit.frame.client.project.docgenerator.IDocGeneratorProjectAgent;
import com.arcway.cockpit.modulelib2.client.dataexchange.AbstractImExModuleData;
import com.arcway.cockpit.modulelib2.client.docgen.interfaces.IModuleDataDocGenProxy;
import com.arcway.cockpit.modulelib2.client.docgen.provider.AbstractModuleDataDocGenProxy;
import com.arcway.cockpit.projectplanningmodule2.client.core.imexportdata.ImExWorkItem;
import com.arcway.cockpit.projectplanningmodule2.client.core.project.ModuleDataFacade;
import com.arcway.cockpit.projectplanningmodule2.client.messages.Task;
import com.arcway.cockpit.projectplanningmodule2.client.messages.description.WorkItemDescription;
import com.arcway.cockpit.projectplanningmodule2.docgen.provider.interfaces.IWorkItem;
import com.arcway.lib.stringtools.StringUtil;
import de.plans.lib.util.HTMLEncoder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import org.eclipse.ui.IWorkbenchPage;

public class WorkItemDocGenProxy
extends AbstractModuleDataDocGenProxy
implements IModuleDataDocGenProxy,
IWorkItem {
    private ImExWorkItem workItem = null;
    private ModuleDataFacade dataFacade = null;
    private final Locale locale;
    private final IWorkbenchPage currentPage;

    public WorkItemDocGenProxy(ImExWorkItem workItem, IGraphicsAndFilesHelper graphicsProvider, ModuleDataFacade dataFacade, Collection filters, Locale locale, IWorkbenchPage currentPage) {
        super((AbstractImExModuleData)workItem, graphicsProvider, locale);
        this.workItem = workItem;
        this.dataFacade = dataFacade;
        this.locale = locale;
        this.currentPage = currentPage;
    }

    @Override
    public String getUniqueIdentifier() {
        return this.workItem.getUID();
    }

    public String getDisplayName() {
        return HTMLEncoder.encode((String)this.workItem.getName());
    }

    public String getTypeID() {
        return "ppm.workItem";
    }

    public String getTypeName() {
        return new WorkItemDescription().getTypeName(this.locale);
    }

    public String getRessources() {
        return this.getResources();
    }

    @Override
    public String getResources() {
        String stakeholderName = this.workItem.getStakeholderName();
        String resources = this.workItem.getResources();
        String result = stakeholderName != null && stakeholderName.length() > 0 && resources != null && resources.length() > 0 ? String.valueOf(stakeholderName) + ", " + resources : String.valueOf(stakeholderName) + resources;
        return HTMLEncoder.encode((String)result);
    }

    @Override
    public String getCategory() {
        return HTMLEncoder.encode((String)this.workItem.getCategory());
    }

    @Override
    public String getName() {
        return HTMLEncoder.encode((String)this.workItem.getName());
    }

    @Override
    public List<String> getDescription() {
        List descriptionList = StringUtil.splitTextLines((String)this.workItem.getDescription());
        List resultAsList = MultilineTextOutputHelper.getHTMLEncodedNormalisedMultilineTextOutput((List)descriptionList);
        return resultAsList;
    }

    @Override
    public String getPersonInCharge() {
        return HTMLEncoder.encode((String)this.workItem.getStakeholderName());
    }

    @Override
    public String getWorkEstimated() {
        return this.workItem.getWorkEstimated();
    }

    @Override
    public String getWorkDone() {
        return this.workItem.getWorkDone();
    }

    @Override
    public String getWorkForecast() {
        return this.workItem.getForecast();
    }

    @Override
    public String getWorkRemaining() {
        return this.workItem.getWorkRemaining();
    }

    @Override
    public String getPercentWorkComplete() {
        return this.workItem.getPercentWorkComplete();
    }

    protected static List<? extends IWorkItem> transformWorkItemList(List workItems, IGraphicsAndFilesHelper fileAttributeAndGraphicsProvider, ModuleDataFacade dataFacade, Collection filters, Locale locale, IWorkbenchPage currentPage) {
        ArrayList<WorkItemDocGenProxy> result = new ArrayList<WorkItemDocGenProxy>(workItems.size());
        for (ImExWorkItem workItem : workItems) {
            WorkItemDocGenProxy workItemDesc = new WorkItemDocGenProxy(workItem, fileAttributeAndGraphicsProvider, dataFacade, filters, locale, currentPage);
            result.add(workItemDesc);
        }
        return result;
    }

    @Override
    public boolean isComplete() {
        return this.workItem.isComplete();
    }

    @Override
    public boolean isInProgress() {
        return this.workItem.isInProgress();
    }

    @Override
    public boolean isNotStarted() {
        return this.workItem.isNotStarted();
    }

    @Override
    public String getDueDate() {
        Task task = this.dataFacade.getTaskForWorkItem(this.workItem);
        if (task != null) {
            return task.getFinish().getDisplayStringRepresentation();
        }
        return "";
    }

    @Override
    public boolean isLinkedWithUniqueElement() {
        return this.dataFacade.isLinkedWithUniqueElement(this.workItem);
    }

    @Override
    public IModelElement getLinkedUniqueElement() {
        IUniqueElement ue = this.dataFacade.getLinkedUniqueElement(this.workItem);
        UniqueElementDocGenProxy ueProxy = new UniqueElementDocGenProxy(ue, (IDocGeneratorProjectAgent)new DocGeneratorProjectAgent((IFrameProjectAgent)this.dataFacade.getModelController().getProjectAgent()), Collections.emptyList(), this.getGraphicsAndFilesHelper(), this.locale, this.currentPage);
        return ueProxy;
    }

    public AbstractImExModuleData getWrappedExportableItem() {
        return this.workItem;
    }

    public String getCommitVersion() {
        int commitCount = this.workItem.getCommitCount();
        return HistoryEntry.getVersionForCommitCount((int)commitCount);
    }

    public IRecord toRecord(Set<String> keyWhiteList) {
        IRecord record = super.toRecord(keyWhiteList);
        if (keyWhiteList == null || keyWhiteList.contains("name")) {
            record.set("name", (Object)this.getName());
        }
        if (keyWhiteList == null || keyWhiteList.contains("description")) {
            record.set("description", this.getDescription());
        }
        return record;
    }
}

