/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.projectplanningmodule2.docgen.provider;

import com.arcway.cockpit.docgen.graphicsandfiles.IGraphicsAndFilesHelper;
import com.arcway.cockpit.docgen.provider.AbstractAttributeOwnerDocGenProxy;
import com.arcway.cockpit.docgen.provider.HistoryEntry;
import com.arcway.cockpit.docgen.provider.interfaces.IRecord;
import com.arcway.cockpit.modulelib2.client.dataexchange.AbstractImExModuleData;
import com.arcway.cockpit.modulelib2.client.docgen.interfaces.IModuleDataDocGenProxy;
import com.arcway.cockpit.modulelib2.client.docgen.provider.AbstractModuleDataDocGenProxy;
import com.arcway.cockpit.projectplanningmodule2.client.core.imexportdata.ImExTask;
import com.arcway.cockpit.projectplanningmodule2.client.core.project.ModuleDataFacade;
import com.arcway.cockpit.projectplanningmodule2.client.messages.description.TaskDescription;
import com.arcway.cockpit.projectplanningmodule2.docgen.provider.TaskComparator;
import com.arcway.cockpit.projectplanningmodule2.docgen.provider.WorkItemComparator;
import com.arcway.cockpit.projectplanningmodule2.docgen.provider.WorkItemDocGenProxy;
import com.arcway.cockpit.projectplanningmodule2.docgen.provider.interfaces.ITask;
import com.arcway.cockpit.projectplanningmodule2.docgen.provider.interfaces.IWorkItem;
import de.plans.lib.util.HTMLEncoder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import org.eclipse.ui.IWorkbenchPage;

public class TaskDocGenProxy
extends AbstractModuleDataDocGenProxy
implements IModuleDataDocGenProxy,
ITask {
    private ModuleDataFacade dataFacade = null;
    private ImExTask task = null;
    private Collection filters = null;
    private final Locale locale;
    private final IWorkbenchPage currentPage;

    public TaskDocGenProxy(ImExTask task, IGraphicsAndFilesHelper graphicsProvider, ModuleDataFacade dataFacade, Collection filters, Locale locale, IWorkbenchPage currentPage) {
        super((AbstractImExModuleData)task, graphicsProvider, locale);
        this.task = task;
        this.dataFacade = dataFacade;
        this.filters = filters;
        this.locale = locale;
        this.currentPage = currentPage;
    }

    @Override
    public String getUniqueIdentifier() {
        return this.task.getUID();
    }

    public String getDisplayName() {
        return HTMLEncoder.encode((String)this.task.getName());
    }

    public String getTypeID() {
        return "ppm.task";
    }

    public String getTypeName() {
        return new TaskDescription().getTypeName(this.locale);
    }

    @Override
    public String getName() {
        return HTMLEncoder.encode((String)this.task.getName());
    }

    @Override
    public boolean containsWorkItems() {
        return !this.task.getFilteredWorkItems().isEmpty();
    }

    @Override
    public List<? extends IWorkItem> getWorkItems() {
        List workItems = this.getWorkItems_Internal();
        return WorkItemDocGenProxy.transformWorkItemList(workItems, this.getGraphicsAndFilesHelper(), this.dataFacade, this.filters, this.locale, this.currentPage);
    }

    @Override
    public List<? extends IWorkItem> getWorkItems(int sortingCriterion) {
        List workItems = this.getWorkItems_Internal();
        Collections.sort(workItems, new WorkItemComparator(sortingCriterion));
        return WorkItemDocGenProxy.transformWorkItemList(workItems, this.getGraphicsAndFilesHelper(), this.dataFacade, this.filters, this.locale, this.currentPage);
    }

    @Override
    public List<? extends IWorkItem> getWorkItems(String sortingProperty) {
        List workItems = this.getWorkItems_Internal();
        List<? extends IWorkItem> transformedWorkItems = WorkItemDocGenProxy.transformWorkItemList(workItems, this.getGraphicsAndFilesHelper(), this.dataFacade, this.filters, this.locale, this.currentPage);
        AbstractAttributeOwnerDocGenProxy.sortList(transformedWorkItems, (String)sortingProperty);
        return transformedWorkItems;
    }

    private List getWorkItems_Internal() {
        return new ArrayList(this.task.getFilteredWorkItems());
    }

    @Override
    public boolean hasSubTasks() {
        return !this.task.getFilteredChildTasks().isEmpty();
    }

    @Override
    public List<? extends ITask> getSubTasks() {
        return this.getSubTasks(1);
    }

    @Override
    public List<? extends ITask> getSubTasks(int sortingCriterion) {
        List tasks = this.getSubTasks_Internal();
        Collections.sort(tasks, new TaskComparator(sortingCriterion));
        return TaskDocGenProxy.transformTaskList(tasks, this.getGraphicsAndFilesHelper(), this.dataFacade, this.filters, this.locale, this.currentPage);
    }

    @Override
    public List<? extends ITask> getSubTasks(String sortingProperty) {
        List tasks = this.getSubTasks_Internal();
        List<? extends ITask> transformedTasks = TaskDocGenProxy.transformTaskList(tasks, this.getGraphicsAndFilesHelper(), this.dataFacade, this.filters, this.locale, this.currentPage);
        AbstractAttributeOwnerDocGenProxy.sortList(transformedTasks, (String)sortingProperty);
        return transformedTasks;
    }

    private List getSubTasks_Internal() {
        return new ArrayList(this.task.getFilteredChildTasks());
    }

    @Override
    public boolean hasParent() {
        return this.task.getParentTask() != null;
    }

    @Override
    public ITask getParentTask() {
        TaskDocGenProxy parent = new TaskDocGenProxy(this.task.getParentTask(), this.getGraphicsAndFilesHelper(), this.dataFacade, this.filters, this.locale, this.currentPage);
        return parent;
    }

    @Override
    public String getWorkDone() {
        return HTMLEncoder.encode((String)this.task.getWorkDone());
    }

    @Override
    public String getWorkEstimated() {
        return HTMLEncoder.encode((String)this.task.getWorkEstimated());
    }

    @Override
    public String getWorkRemaining() {
        return HTMLEncoder.encode((String)this.task.getWorkRemaining());
    }

    @Override
    public String getWorkForecast() {
        return HTMLEncoder.encode((String)this.task.getWorkForecast());
    }

    @Override
    public String getPercentWorkComplete() {
        return String.valueOf(this.task.getPercentWorkComplete());
    }

    @Override
    public String getStart() {
        return HTMLEncoder.encode((String)this.task.getStart());
    }

    @Override
    public String getFinish() {
        return HTMLEncoder.encode((String)this.task.getFinish());
    }

    @Override
    public String getDuration() {
        return HTMLEncoder.encode((String)this.task.getDuration());
    }

    @Override
    public String getState() {
        return HTMLEncoder.encode((String)this.task.getState());
    }

    protected static List<? extends ITask> transformTaskList(List tasks, IGraphicsAndFilesHelper fileAttributeAndGraphicsProvider, ModuleDataFacade dataFacade, Collection filters, Locale locale, IWorkbenchPage currentPage) {
        ArrayList<TaskDocGenProxy> result = new ArrayList<TaskDocGenProxy>(tasks.size());
        for (ImExTask taskData : tasks) {
            TaskDocGenProxy taskDescription = new TaskDocGenProxy(taskData, fileAttributeAndGraphicsProvider, dataFacade, filters, locale, currentPage);
            result.add(taskDescription);
        }
        return result;
    }

    public AbstractImExModuleData getWrappedExportableItem() {
        return this.task;
    }

    public String getCommitVersion() {
        int commitCount = this.task.getCommitCount();
        return HistoryEntry.getVersionForCommitCount((int)commitCount);
    }

    public IRecord toRecord(Set<String> keyWhiteList) {
        IRecord record = super.toRecord(keyWhiteList);
        if (keyWhiteList == null || keyWhiteList.contains("name")) {
            record.set("name", (Object)this.getName());
        }
        return record;
    }
}

