/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.projectplanningmodule2.docgen.provider;

import com.arcway.cockpit.docgen.graphicsandfiles.GraphicsAndFilesHelper;
import com.arcway.cockpit.docgen.graphicsandfiles.IGraphicsAndFilesHelper;
import com.arcway.cockpit.docgen.provider.AbstractAttributeOwnerDocGenProxy;
import com.arcway.cockpit.docgen.provider.IProjectRelatedReportContext;
import com.arcway.cockpit.docgen.provider.IProjectRelatedReportProvider;
import com.arcway.cockpit.docgen.provider.interfaces.IHistoryEntry;
import com.arcway.cockpit.frame.client.project.docgenerator.IDocGeneratorProjectAgent;
import com.arcway.cockpit.frame.client.project.modules.IFMCAModule;
import com.arcway.cockpit.modulelib2.client.dataexchange.AbstractImExModuleData;
import com.arcway.cockpit.modulelib2.client.docgen.interfaces.IModuleDataDocGenProxy;
import com.arcway.cockpit.modulelib2.client.docgen.interfaces.IModuleReportDataProvider;
import com.arcway.cockpit.projectplanningmodule2.client.ModuleIdentification;
import com.arcway.cockpit.projectplanningmodule2.client.core.imexportdata.ImExProjectPlan;
import com.arcway.cockpit.projectplanningmodule2.client.core.imexportdata.ImExTask;
import com.arcway.cockpit.projectplanningmodule2.client.core.imexportdata.ImExWorkItem;
import com.arcway.cockpit.projectplanningmodule2.client.core.project.ModuleDataFacade;
import com.arcway.cockpit.projectplanningmodule2.docgen.provider.ProjectPlanDocGenProxy;
import com.arcway.cockpit.projectplanningmodule2.docgen.provider.TaskDocGenProxy;
import com.arcway.cockpit.projectplanningmodule2.docgen.provider.WorkItemComparator;
import com.arcway.cockpit.projectplanningmodule2.docgen.provider.WorkItemDocGenProxy;
import com.arcway.cockpit.projectplanningmodule2.docgen.provider.interfaces.IProjectPlan;
import com.arcway.cockpit.projectplanningmodule2.docgen.provider.interfaces.IProjectPlanningDataProvider;
import com.arcway.cockpit.projectplanningmodule2.docgen.provider.interfaces.ITask;
import com.arcway.cockpit.projectplanningmodule2.docgen.provider.interfaces.IWorkItem;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import org.eclipse.ui.IWorkbenchPage;

public class ReportDataProvider
implements IModuleReportDataProvider,
IProjectRelatedReportProvider,
IProjectPlanningDataProvider {
    public static final int SORT_PROJECTPLAN_BY_NAME = 0;
    public static final int SORT_TASK_BY_STARTDATE = 1;
    public static final int SORT_TASK_BY_ENDDATE = 2;
    public static final int SORT_TASK_BY_DURATION = 3;
    public static final int SORT_TASK_BY_STATE = 4;
    public static final int SORT_TASK_BY_PERCENTWORKCOMPLETE = 5;
    public static final int SORT_TASK_BY_TOTALWORK = 6;
    public static final int SORT_TASK_BY_NAME = 7;
    public static final int SORT_WORKITEM_BY_NAME = 8;
    public static final int SORT_WORKITEM_BY_TOTALWORK = 9;
    public static final int SORT_WORKITEM_BY_PERCENTWORKCOMPLETE = 10;
    private ModuleDataFacade dataFacade = null;
    private GraphicsAndFilesHelper fileAttributeAndGraphicsProvider = null;
    private Collection filters = null;
    private Locale locale;
    private IWorkbenchPage currentPage;

    public void setup(IProjectRelatedReportContext reportContext) {
        IDocGeneratorProjectAgent projectAgent = reportContext.getProjectAgent();
        IFMCAModule module = projectAgent.getModule(ModuleIdentification.getModuleID());
        this.locale = new Locale(projectAgent.getLanguageID());
        this.dataFacade = (ModuleDataFacade)module.getModuleDataFacade();
        this.fileAttributeAndGraphicsProvider = reportContext.getGraphicsProvider();
        this.filters = reportContext.getFilterCollection();
        this.currentPage = reportContext.getCurrentPage();
    }

    public List<IProjectPlan> getAllProjectPlans() {
        return this.getProjectPlans();
    }

    @Override
    public List<IProjectPlan> getProjectPlans() {
        List projectPlans = this.getProjectPlans_Internal();
        return ProjectPlanDocGenProxy.transformProjectPlanList(projectPlans, (IGraphicsAndFilesHelper)this.fileAttributeAndGraphicsProvider, this.dataFacade, this.filters, this.locale, this.currentPage);
    }

    @Override
    public List<IProjectPlan> getProjectPlans(String sortingProperty) {
        List projectPlans = this.getProjectPlans_Internal();
        List<IProjectPlan> transformedProjectPlans = ProjectPlanDocGenProxy.transformProjectPlanList(projectPlans, (IGraphicsAndFilesHelper)this.fileAttributeAndGraphicsProvider, this.dataFacade, this.filters, this.locale, this.currentPage);
        AbstractAttributeOwnerDocGenProxy.sortList(transformedProjectPlans, (String)sortingProperty);
        return transformedProjectPlans;
    }

    private List getProjectPlans_Internal() {
        return new ArrayList(this.dataFacade.getProjectPlans(this.filters, this.locale));
    }

    @Override
    public List<? extends IWorkItem> getUnassignedWorkItems() {
        List workItems = this.getUnassignedWorkItems_Internal();
        return WorkItemDocGenProxy.transformWorkItemList(workItems, (IGraphicsAndFilesHelper)this.fileAttributeAndGraphicsProvider, this.dataFacade, this.filters, this.locale, this.currentPage);
    }

    @Override
    public List<? extends IWorkItem> getUnassignedWorkItems(int sortingCriterion) {
        List workItems = this.getUnassignedWorkItems_Internal();
        Collections.sort(workItems, new WorkItemComparator(sortingCriterion));
        return WorkItemDocGenProxy.transformWorkItemList(workItems, (IGraphicsAndFilesHelper)this.fileAttributeAndGraphicsProvider, this.dataFacade, this.filters, this.locale, this.currentPage);
    }

    @Override
    public List<? extends IWorkItem> getUnassignedWorkItems(String sortingProperty) {
        List workItems = this.getUnassignedWorkItems_Internal();
        List<? extends IWorkItem> transformedWorkItems = WorkItemDocGenProxy.transformWorkItemList(workItems, (IGraphicsAndFilesHelper)this.fileAttributeAndGraphicsProvider, this.dataFacade, this.filters, this.locale, this.currentPage);
        AbstractAttributeOwnerDocGenProxy.sortList(transformedWorkItems, (String)sortingProperty);
        return transformedWorkItems;
    }

    private List getUnassignedWorkItems_Internal() {
        return new ArrayList(this.dataFacade.getUnassignedWorkItems1(this.filters, this.locale));
    }

    public List<? extends IWorkItem> getUnlinkedWorkItems() {
        return this.getUnassignedWorkItems();
    }

    @Override
    public boolean hasWorkItemsForUniqueElement(String uniqueElementUID) {
        return !this.getWorkItemsForUniqueElement_Internal(uniqueElementUID).isEmpty();
    }

    @Override
    public List<? extends IWorkItem> getWorkItemsForUniqueElement(String uniqueElementUID) {
        return this.getWorkItemsForUniqueElement(uniqueElementUID, 8);
    }

    @Override
    public List<? extends IWorkItem> getWorkItemsForUniqueElement(String uniqueElementUID, int sortingCriterion) {
        List workItems = this.getWorkItemsForUniqueElement_Internal(uniqueElementUID);
        Collections.sort(workItems, new WorkItemComparator(sortingCriterion));
        return WorkItemDocGenProxy.transformWorkItemList(workItems, (IGraphicsAndFilesHelper)this.fileAttributeAndGraphicsProvider, this.dataFacade, this.filters, this.locale, this.currentPage);
    }

    @Override
    public List<? extends IWorkItem> getWorkItemsForUniqueElement(String uniqueElementUID, String sortingProperty) {
        List workItems = this.getWorkItemsForUniqueElement_Internal(uniqueElementUID);
        List<? extends IWorkItem> transformedWorkItems = WorkItemDocGenProxy.transformWorkItemList(workItems, (IGraphicsAndFilesHelper)this.fileAttributeAndGraphicsProvider, this.dataFacade, this.filters, this.locale, this.currentPage);
        AbstractAttributeOwnerDocGenProxy.sortList(transformedWorkItems, (String)sortingProperty);
        return transformedWorkItems;
    }

    private List getWorkItemsForUniqueElement_Internal(String uniqueElementUID) {
        return new ArrayList(this.dataFacade.getWorkItemsForUE1(uniqueElementUID, this.filters, this.locale));
    }

    @Override
    public List<? extends IWorkItem> getWorkItemsForStakeholder(String stakeholderName) {
        return this.getWorkItemsForStakeholder(stakeholderName, 8);
    }

    @Override
    public List<? extends IWorkItem> getWorkItemsForStakeholder(String stakeholderName, int sortingCriterion) {
        List workItems = this.getWorkItemsForStakeholder_Internal(stakeholderName);
        Collections.sort(workItems, new WorkItemComparator(sortingCriterion));
        return WorkItemDocGenProxy.transformWorkItemList(workItems, (IGraphicsAndFilesHelper)this.fileAttributeAndGraphicsProvider, this.dataFacade, this.filters, this.locale, this.currentPage);
    }

    @Override
    public List<? extends IWorkItem> getWorkItemsForStakeholder(String stakeholderName, String sortingProperty) {
        List workItems = this.getWorkItemsForStakeholder_Internal(stakeholderName);
        List<? extends IWorkItem> transformedWorkItems = WorkItemDocGenProxy.transformWorkItemList(workItems, (IGraphicsAndFilesHelper)this.fileAttributeAndGraphicsProvider, this.dataFacade, this.filters, this.locale, this.currentPage);
        AbstractAttributeOwnerDocGenProxy.sortList(transformedWorkItems, (String)sortingProperty);
        return transformedWorkItems;
    }

    private List getWorkItemsForStakeholder_Internal(String stakeholderName) {
        return new ArrayList(this.dataFacade.getWorkItemsForStakeholder(stakeholderName, this.filters, this.locale));
    }

    @Override
    public int getSORT_TASK_BY_STARTDATE() {
        return 1;
    }

    @Override
    public int getSORT_TASK_BY_ENDDATE() {
        return 2;
    }

    @Override
    public int getSORT_TASK_BY_DURATION() {
        return 3;
    }

    @Override
    public int getSORT_TASK_BY_STATE() {
        return 4;
    }

    @Override
    public int getSORT_TASK_BY_PERCENTWORKCOMPLETE() {
        return 5;
    }

    @Override
    public int getSORT_TASK_BY_TOTALWORK() {
        return 6;
    }

    @Override
    public int getSORT_TASK_BY_NAME() {
        return 7;
    }

    @Override
    public int getSORT_WORKITEM_BY_NAME() {
        return 8;
    }

    @Override
    public int getSORT_WORKITEM_BY_TOTALWORK() {
        return 9;
    }

    @Override
    public int getSORT_WORKITEM_BY_PERCENTWORKCOMPLETE() {
        return 5;
    }

    public boolean isResponsibleFor(AbstractImExModuleData exportableItem) {
        return exportableItem instanceof ImExProjectPlan || exportableItem instanceof ImExTask || exportableItem instanceof ImExWorkItem;
    }

    public IModuleDataDocGenProxy getDocGenProxy(AbstractImExModuleData exportableItem) {
        if (exportableItem instanceof ImExProjectPlan) {
            return new ProjectPlanDocGenProxy((ImExProjectPlan)exportableItem, (IGraphicsAndFilesHelper)this.fileAttributeAndGraphicsProvider, this.dataFacade, this.filters, this.locale, this.currentPage);
        }
        if (exportableItem instanceof ImExTask) {
            return new TaskDocGenProxy((ImExTask)exportableItem, (IGraphicsAndFilesHelper)this.fileAttributeAndGraphicsProvider, this.dataFacade, this.filters, this.locale, this.currentPage);
        }
        if (exportableItem instanceof ImExWorkItem) {
            return new WorkItemDocGenProxy((ImExWorkItem)exportableItem, (IGraphicsAndFilesHelper)this.fileAttributeAndGraphicsProvider, this.dataFacade, this.filters, this.locale, this.currentPage);
        }
        return null;
    }

    @Override
    public List<? extends IProjectPlan> getAllProjectPlansForHistoryItem(IHistoryEntry historyEntry) {
        ArrayList<IProjectPlan> projectPlansForHistoryItem = new ArrayList<IProjectPlan>();
        String commitVersion = historyEntry.getVersion();
        if (commitVersion != null) {
            List<IProjectPlan> projectPlans = this.getAllProjectPlans();
            for (IProjectPlan projectPlan : projectPlans) {
                if (!commitVersion.equals(projectPlan.getCommitVersion())) continue;
                projectPlansForHistoryItem.add(projectPlan);
            }
        }
        return projectPlansForHistoryItem;
    }

    @Override
    public List<? extends ITask> getAllTasksForHistoryItem(IHistoryEntry historyEntry) {
        ArrayList<ITask> tasksForHistoryItem = new ArrayList<ITask>();
        String commitVersion = historyEntry.getVersion();
        List<ITask> allTasks = this.getAllTasks();
        for (ITask task : allTasks) {
            if (!commitVersion.equals(task.getCommitVersion())) continue;
            tasksForHistoryItem.add(task);
        }
        return tasksForHistoryItem;
    }

    private List<ITask> getAllTasks() {
        ArrayList<ITask> allTasks = new ArrayList<ITask>();
        List<IProjectPlan> projectPlans = this.getAllProjectPlans();
        for (IProjectPlan projectPlan : projectPlans) {
            for (ITask iTask : projectPlan.getRootTasks()) {
                allTasks.add(iTask);
                allTasks.addAll(this.getAllSubTasks(iTask));
            }
        }
        return allTasks;
    }

    private List<ITask> getAllSubTasks(ITask task) {
        ArrayList<ITask> subtasks = new ArrayList<ITask>();
        List<? extends ITask> directSubtasks = task.getSubTasks();
        for (ITask iTask : directSubtasks) {
            subtasks.add(iTask);
            subtasks.addAll(this.getAllSubTasks(iTask));
        }
        return subtasks;
    }

    @Override
    public List<? extends IWorkItem> getAllWorkItemsForHistoryItem(IHistoryEntry historyEntry) {
        ArrayList<IWorkItem> workItemsForHistoryItem = new ArrayList<IWorkItem>();
        String commitVersion = historyEntry.getVersion();
        ArrayList<IWorkItem> allWorkItems = new ArrayList<IWorkItem>();
        for (IWorkItem iWorkItem : this.getUnassignedWorkItems()) {
            allWorkItems.add(iWorkItem);
        }
        for (ITask iTask : this.getAllTasks()) {
            for (IWorkItem iWorkItem : iTask.getWorkItems()) {
                allWorkItems.add(iWorkItem);
            }
        }
        for (IWorkItem iWorkItem : allWorkItems) {
            if (!commitVersion.equals(iWorkItem.getCommitVersion())) continue;
            workItemsForHistoryItem.add(iWorkItem);
        }
        return workItemsForHistoryItem;
    }
}

