/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.projectplanningmodule2.docgen.provider;

import com.arcway.cockpit.docgen.graphicsandfiles.IGraphicsAndFilesHelper;
import com.arcway.cockpit.docgen.provider.AbstractAttributeOwnerDocGenProxy;
import com.arcway.cockpit.docgen.provider.HistoryEntry;
import com.arcway.cockpit.docgen.provider.interfaces.IRecord;
import com.arcway.cockpit.docgen.provider.utils.MultilineTextOutputHelper;
import com.arcway.cockpit.modulelib2.client.dataexchange.AbstractImExModuleData;
import com.arcway.cockpit.modulelib2.client.docgen.interfaces.IModuleDataDocGenProxy;
import com.arcway.cockpit.modulelib2.client.docgen.provider.AbstractModuleDataDocGenProxy;
import com.arcway.cockpit.projectplanningmodule2.client.core.imexportdata.ImExProjectPlan;
import com.arcway.cockpit.projectplanningmodule2.client.core.project.ModuleDataFacade;
import com.arcway.cockpit.projectplanningmodule2.client.messages.description.ProjectPlanDescription;
import com.arcway.cockpit.projectplanningmodule2.docgen.provider.CumulatedResourceWorkDescription;
import com.arcway.cockpit.projectplanningmodule2.docgen.provider.TaskComparator;
import com.arcway.cockpit.projectplanningmodule2.docgen.provider.TaskDocGenProxy;
import com.arcway.cockpit.projectplanningmodule2.docgen.provider.interfaces.IProjectPlan;
import com.arcway.cockpit.projectplanningmodule2.docgen.provider.interfaces.ITask;
import com.arcway.lib.stringtools.StringUtil;
import de.plans.lib.util.HTMLEncoder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import org.eclipse.ui.IWorkbenchPage;

public class ProjectPlanDocGenProxy
extends AbstractModuleDataDocGenProxy
implements IModuleDataDocGenProxy,
IProjectPlan {
    private ModuleDataFacade dataFacade = null;
    private ImExProjectPlan projectPlanData = null;
    private Collection filters = null;
    private final Locale locale;
    private final IWorkbenchPage currentPage;
    private CumulatedResourceWorkDescription workCumulator = null;

    public ProjectPlanDocGenProxy(ImExProjectPlan projectPlanData, IGraphicsAndFilesHelper graphicsProvider, ModuleDataFacade dataFacade, Collection filters, Locale locale, IWorkbenchPage currentPage) {
        super((AbstractImExModuleData)projectPlanData, graphicsProvider, locale);
        this.projectPlanData = projectPlanData;
        this.dataFacade = dataFacade;
        this.filters = filters;
        this.locale = locale;
        this.currentPage = currentPage;
    }

    private CumulatedResourceWorkDescription getWorkCumulator() {
        if (this.workCumulator == null) {
            this.workCumulator = new CumulatedResourceWorkDescription(this.projectPlanData.getRessourceWorkCumluator(), this.dataFacade);
        }
        return this.workCumulator;
    }

    @Override
    public String getUniqueIdentifier() {
        return this.projectPlanData.getUID();
    }

    public String getDisplayName() {
        return HTMLEncoder.encode((String)this.projectPlanData.getName());
    }

    public String getTypeID() {
        return "ppm.projectPlan";
    }

    public String getTypeName() {
        return new ProjectPlanDescription().getTypeName(this.locale);
    }

    @Override
    public List<String> getDescription() {
        List descriptionList = StringUtil.splitTextLines((String)this.projectPlanData.getDescription());
        List resultAsList = MultilineTextOutputHelper.getHTMLEncodedNormalisedMultilineTextOutput((List)descriptionList);
        return resultAsList;
    }

    @Override
    public String getName() {
        return HTMLEncoder.encode((String)this.projectPlanData.getName());
    }

    @Override
    public String getWorkEstimated() {
        return HTMLEncoder.encode((String)this.projectPlanData.getWorkEstimated());
    }

    @Override
    public boolean containsTasks() {
        boolean result = false;
        List requirements = this.projectPlanData.getFilteredRootTasks();
        result = requirements.size() > 0;
        return result;
    }

    @Override
    public List<? extends ITask> getRootTasks() {
        List tasks = this.getRootTasks_Internal();
        return TaskDocGenProxy.transformTaskList(tasks, this.getGraphicsAndFilesHelper(), this.dataFacade, this.filters, this.locale, this.currentPage);
    }

    @Override
    public List<? extends ITask> getRootTasks(int sortingCriterion) {
        List tasks = this.getRootTasks_Internal();
        Collections.sort(tasks, new TaskComparator(sortingCriterion));
        return TaskDocGenProxy.transformTaskList(tasks, this.getGraphicsAndFilesHelper(), this.dataFacade, this.filters, this.locale, this.currentPage);
    }

    @Override
    public List<? extends ITask> getRootTasks(String sortingProperty) {
        List tasks = this.getRootTasks_Internal();
        List<? extends ITask> transformedTasks = TaskDocGenProxy.transformTaskList(tasks, this.getGraphicsAndFilesHelper(), this.dataFacade, this.filters, this.locale, this.currentPage);
        AbstractAttributeOwnerDocGenProxy.sortList(transformedTasks, (String)sortingProperty);
        return transformedTasks;
    }

    private List getRootTasks_Internal() {
        return new ArrayList(this.projectPlanData.getFilteredRootTasks());
    }

    @Override
    public List getResourceNames() {
        List resourceNames = this.getWorkCumulator().getResourceNames();
        Collections.sort(resourceNames);
        return resourceNames;
    }

    @Override
    public String getWorkOfResource(String resourceName) {
        return this.getWorkCumulator().getWorkForecast(resourceName);
    }

    @Override
    public String getWorkDoneOfResource(String resourceName) {
        return this.getWorkCumulator().getWorkDone(resourceName);
    }

    protected static List<IProjectPlan> transformProjectPlanList(List projectPlans, IGraphicsAndFilesHelper fileAttributeAndGraphicsProvider, ModuleDataFacade dataFacade, Collection filters, Locale locale, IWorkbenchPage currentPage) {
        ArrayList<IProjectPlan> result = new ArrayList<IProjectPlan>(projectPlans.size());
        for (ImExProjectPlan projectPlanData : projectPlans) {
            ProjectPlanDocGenProxy projectPlan = new ProjectPlanDocGenProxy(projectPlanData, fileAttributeAndGraphicsProvider, dataFacade, filters, locale, currentPage);
            result.add(projectPlan);
        }
        return result;
    }

    public AbstractImExModuleData getWrappedExportableItem() {
        return this.projectPlanData;
    }

    public String getCommitVersion() {
        int commitCount = this.projectPlanData.getCommitCount();
        return HistoryEntry.getVersionForCommitCount((int)commitCount);
    }

    public IRecord toRecord(Set<String> keyWhiteList) {
        IRecord record = super.toRecord(keyWhiteList);
        if (keyWhiteList == null || keyWhiteList.contains("name")) {
            record.set("name", (Object)this.getName());
        }
        if (keyWhiteList == null || keyWhiteList.contains("description")) {
            record.set("description", this.getDescription());
        }
        return record;
    }
}

