/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.projectplanningmodule2.docgen.provider;

import com.arcway.cockpit.modulelib2.client.messages.attributes.ModuleDataAttributeDuration;
import com.arcway.cockpit.projectplanningmodule2.client.core.project.ModuleDataFacade;
import com.arcway.cockpit.projectplanningmodule2.client.core.project.RessourceWorkCumulator;
import de.plans.lib.util.HTMLEncoder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class CumulatedResourceWorkDescription {
    private ModuleDataFacade dataFacade = null;
    private RessourceWorkCumulator workCumulator = null;
    private Collection filters = null;
    private Map ressourceNameMap = null;

    public CumulatedResourceWorkDescription(RessourceWorkCumulator workCumulator, ModuleDataFacade dataFacade) {
        this.workCumulator = workCumulator;
        this.dataFacade = dataFacade;
    }

    public void setFilters(Collection filterCollection) {
        this.filters = filterCollection;
    }

    public List getResourceNames() {
        ArrayList resourceNames = new ArrayList();
        resourceNames.addAll(this.getResourceNameMap().keySet());
        return resourceNames;
    }

    private Map getResourceNameMap() {
        if (this.ressourceNameMap == null) {
            this.ressourceNameMap = new HashMap();
            for (String resourceName : this.workCumulator.getResourceNames()) {
                String encodedResourceName = HTMLEncoder.encode((String)resourceName);
                this.ressourceNameMap.put(encodedResourceName, resourceName);
            }
        }
        return this.ressourceNameMap;
    }

    public boolean containsRessource(String resourceName) {
        return this.getResourceNameMap().containsKey(resourceName);
    }

    public String getWorkForecast(String resourceName) {
        String uncodedResourceName = (String)this.getResourceNameMap().get(resourceName);
        ModuleDataAttributeDuration attribute = uncodedResourceName != null ? this.workCumulator.getWorkForecast(uncodedResourceName) : new ModuleDataAttributeDuration(0L);
        return HTMLEncoder.encode((String)attribute.getDisplayRepresentationWithUnit());
    }

    public String getWorkDone(String resourceName) {
        String uncodedResourceName = (String)this.getResourceNameMap().get(resourceName);
        ModuleDataAttributeDuration attribute = uncodedResourceName != null ? this.workCumulator.getWorkDone(uncodedResourceName) : new ModuleDataAttributeDuration(0L);
        return HTMLEncoder.encode((String)attribute.getDisplayRepresentationWithUnit());
    }
}

