/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.projectplanningmodule2.docgen.gui;

import com.arcway.cockpit.cockpitlib.client.filter.AbstractFilter;
import com.arcway.cockpit.cockpitlib.client.filter.gui.IFilterItem;
import com.arcway.cockpit.frame.client.global.gui.views.lib.dataview.filters.CustomPropertiesFilter;
import com.arcway.cockpit.frame.client.project.IFrameProjectAgent;
import com.arcway.cockpit.frame.client.project.docgenerator.configuration.DocGenConfigurationPerReport;
import com.arcway.cockpit.frame.client.project.docgenerator.gui.AbstractFilterItemProvider;
import com.arcway.cockpit.frame.client.project.modules.IModuleDataFacade;
import com.arcway.cockpit.modulelib2.client.core.project.IModelController;
import com.arcway.cockpit.modulelib2.client.gui.filters.FilterHelper;
import com.arcway.cockpit.modulelib2.client.messages.IDataTypesHelper;
import com.arcway.cockpit.projectplanningmodule2.client.ModuleIdentification;
import com.arcway.cockpit.projectplanningmodule2.client.core.project.ModuleDataFacade;
import com.arcway.cockpit.projectplanningmodule2.client.gui.ProjectPlanningFilters;
import com.arcway.cockpit.projectplanningmodule2.client.messages.PPMDataTypesHelper;
import com.arcway.cockpit.projectplanningmodule2.docgen.ModuleConfiguration;
import com.arcway.cockpit.projectplanningmodule2.docgen.gui.Messages;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;

public class TaskWorkitemsFilterItemProvider
extends AbstractFilterItemProvider {
    private AbstractFilter projectPlanFilter;
    private AbstractFilter taskIsCriticalFilter;
    private AbstractFilter taskStartDateFilter;
    private AbstractFilter taskFinishDateFilter;
    private AbstractFilter taskStatusFilter;
    private AbstractFilter ressourceFilter;
    private AbstractFilter workItemIsUnderestimatedFilter;
    private AbstractFilter workItemIsCompleteFilter;
    private AbstractFilter workItemModificationDateFilter;
    private AbstractFilter workItemCreationDateFilter;
    private AbstractFilter workItemCategoryFilter;
    private IFilterItem projectPlanFilterItem;
    private IFilterItem taskIsCriticalFilterItem;
    private IFilterItem taskStartDateFilterItem;
    private IFilterItem taskFinishDateFilterItem;
    private IFilterItem taskStatusFilterItem;
    private IFilterItem ressourceFilterItem;
    private IFilterItem workItemIsUndersetimatedFilterItem;
    private IFilterItem workItemIsCompleteFilterItem;
    private IFilterItem workItemModDateFilterItem;
    private IFilterItem workItemCreationDateFilterItem;
    private IFilterItem workItemCategoryFilterItem;
    private final List customPropertiesFilterItems = new ArrayList();

    public TaskWorkitemsFilterItemProvider() {
        super(ModuleIdentification.getModuleID(), Messages.getString("TaskWorkitemsFilterItemProvider.0"));
    }

    public void initialize(IModuleDataFacade moduleDataFacade, IFrameProjectAgent projectAgent) {
        if (moduleDataFacade instanceof ModuleDataFacade) {
            ModuleDataFacade dataFacade = (ModuleDataFacade)moduleDataFacade;
            ProjectPlanningFilters filterFactory = dataFacade.getFilterFactory();
            this.projectPlanFilterItem = filterFactory.createProjectPlanFilterItem();
            this.projectPlanFilter = this.projectPlanFilterItem.getFilter();
            this.taskIsCriticalFilterItem = filterFactory.createTaskIsCriticalFilterItem();
            this.taskIsCriticalFilter = this.taskIsCriticalFilterItem.getFilter();
            this.taskStartDateFilterItem = filterFactory.createTaskStartDateFilterItem();
            this.taskStartDateFilter = this.taskStartDateFilterItem.getFilter();
            this.taskFinishDateFilterItem = filterFactory.createTaskEndDateFilterItem();
            this.taskFinishDateFilter = this.taskFinishDateFilterItem.getFilter();
            this.taskStatusFilterItem = filterFactory.createTaskStatusFilterItem();
            this.taskStatusFilter = this.taskStatusFilterItem.getFilter();
            this.ressourceFilterItem = filterFactory.createResourceFilterItem();
            this.ressourceFilter = this.ressourceFilterItem.getFilter();
            this.workItemIsUndersetimatedFilterItem = filterFactory.createWorkItemEffortUnderEstimatedFilterItem();
            this.workItemIsUnderestimatedFilter = this.workItemIsUndersetimatedFilterItem.getFilter();
            this.workItemIsCompleteFilterItem = filterFactory.createWorkItemDoneFilterItem();
            this.workItemIsCompleteFilter = this.workItemIsCompleteFilterItem.getFilter();
            this.workItemCreationDateFilterItem = filterFactory.createWorkItemCreationDateFilterItem();
            this.workItemCreationDateFilter = this.workItemCreationDateFilterItem.getFilter();
            this.workItemModDateFilterItem = filterFactory.createWorkItemLastChangeFilterItem();
            this.workItemModificationDateFilter = this.workItemModDateFilterItem.getFilter();
            this.workItemCategoryFilterItem = filterFactory.createWorkItemCategoryFilterItem();
            this.workItemCategoryFilter = this.workItemCategoryFilterItem.getFilter();
            this.customPropertiesFilterItems.clear();
            IDataTypesHelper dataTypesHelper = PPMDataTypesHelper.getDefault();
            for (String typeID : dataTypesHelper.getDocumentationCustomPropertyDataTypes()) {
                FilterHelper.getCustomPropertyFilters((String)typeID, (Collection)this.customPropertiesFilterItems, (IModelController)dataFacade.getModelController());
            }
        }
    }

    public boolean isOptionalProvider() {
        return true;
    }

    public List getItems() {
        ArrayList<IFilterItem> items = new ArrayList<IFilterItem>();
        items.add(this.projectPlanFilterItem);
        items.add(this.taskIsCriticalFilterItem);
        items.add(this.taskStartDateFilterItem);
        items.add(this.taskFinishDateFilterItem);
        items.add(this.taskStatusFilterItem);
        items.add(this.ressourceFilterItem);
        items.add(this.workItemIsUndersetimatedFilterItem);
        items.add(this.workItemIsCompleteFilterItem);
        items.add(this.workItemCategoryFilterItem);
        items.add(this.workItemModDateFilterItem);
        items.add(this.workItemCreationDateFilterItem);
        items.addAll(this.customPropertiesFilterItems);
        return items;
    }

    public List getFilters() {
        ArrayList<AbstractFilter> filters = new ArrayList<AbstractFilter>();
        filters.add(this.projectPlanFilter);
        filters.add(this.taskIsCriticalFilter);
        filters.add(this.taskStartDateFilter);
        filters.add(this.taskFinishDateFilter);
        filters.add(this.taskStatusFilter);
        filters.add(this.ressourceFilter);
        filters.add(this.workItemIsUnderestimatedFilter);
        filters.add(this.workItemIsCompleteFilter);
        filters.add(this.workItemCategoryFilter);
        filters.add(this.workItemModificationDateFilter);
        filters.add(this.workItemCreationDateFilter);
        for (IFilterItem filterItem : this.customPropertiesFilterItems) {
            filters.add(filterItem.getFilter());
        }
        return filters;
    }

    public boolean hasActiveFilters() {
        boolean hasActiveFilter = false;
        Iterator i = this.getFilters().iterator();
        while (i.hasNext()) {
            if (!((AbstractFilter)i.next()).isActive()) continue;
            hasActiveFilter = true;
            break;
        }
        return hasActiveFilter;
    }

    public void update(DocGenConfigurationPerReport configuration) {
        ModuleConfiguration moduleConfiguration = new ModuleConfiguration(configuration);
        this.projectPlanFilter.setActive(moduleConfiguration.isFilterActive("ppmDocGen._FILTER_TASK_PM_PROJECT"));
        this.projectPlanFilter.setFilterValue(moduleConfiguration.getFilterSettings("ppmDocGen._FILTER_TASK_PM_PROJECT"));
        this.projectPlanFilterItem.filterChanged();
        this.taskIsCriticalFilter.setActive(moduleConfiguration.isFilterActive("ppmDocGen._FILTER_TASK_IS_CRITICAL"));
        this.taskIsCriticalFilter.setFilterValue(moduleConfiguration.getFilterSettings("ppmDocGen._FILTER_TASK_IS_CRITICAL"));
        this.taskIsCriticalFilterItem.filterChanged();
        this.taskStartDateFilter.setActive(moduleConfiguration.isFilterActive("ppmDocGen._FILTER_TASK_DATE_START"));
        this.taskStartDateFilter.setFilterValue(moduleConfiguration.getFilterSettings("ppmDocGen._FILTER_TASK_DATE_START"));
        this.taskStartDateFilterItem.filterChanged();
        this.taskFinishDateFilter.setActive(moduleConfiguration.isFilterActive("ppmDocGen._FILTER_TASK_DATE_FINISH"));
        this.taskFinishDateFilter.setFilterValue(moduleConfiguration.getFilterSettings("ppmDocGen._FILTER_TASK_DATE_FINISH"));
        this.taskFinishDateFilterItem.filterChanged();
        this.taskStatusFilter.setActive(moduleConfiguration.isFilterActive("ppmDocGen._FILTER_TASK_STATUS"));
        this.taskStatusFilter.setFilterValue(moduleConfiguration.getFilterSettings("ppmDocGen._FILTER_TASK_STATUS"));
        this.taskStatusFilterItem.filterChanged();
        this.workItemIsUnderestimatedFilter.setActive(moduleConfiguration.isFilterActive("ppmDocGen._FILTER_WORKITEM_IS_UNDERESTIMATED"));
        this.workItemIsUnderestimatedFilter.setFilterValue(moduleConfiguration.getFilterSettings("ppmDocGen._FILTER_WORKITEM_IS_UNDERESTIMATED"));
        this.workItemIsUndersetimatedFilterItem.filterChanged();
        this.workItemIsCompleteFilter.setActive(moduleConfiguration.isFilterActive("ppmDocGen._FILTER_WORKITEM_IS_COMPLETE"));
        this.workItemIsCompleteFilter.setFilterValue(moduleConfiguration.getFilterSettings("ppmDocGen._FILTER_WORKITEM_IS_COMPLETE"));
        this.workItemIsCompleteFilterItem.filterChanged();
        this.workItemModificationDateFilter.setActive(moduleConfiguration.isFilterActive("ppmDocGen._FILTER_WORKITEM_MOD_DATE_START"));
        this.workItemModificationDateFilter.setFilterValue(moduleConfiguration.getFilterSettings("ppmDocGen._FILTER_WORKITEM_MOD_DATE_START"));
        this.workItemModDateFilterItem.filterChanged();
        this.workItemCreationDateFilter.setActive(moduleConfiguration.isFilterActive("ppmDocGen._FILTER_WORKITEM_CREATION_DATE_START"));
        this.workItemCreationDateFilter.setFilterValue(moduleConfiguration.getFilterSettings("ppmDocGen._FILTER_WORKITEM_CREATION_DATE_START"));
        this.workItemCreationDateFilterItem.filterChanged();
        this.workItemCategoryFilter.setActive(moduleConfiguration.isFilterActive("ppmDocGen._FILTER_WORKITEM_CATEGORY"));
        this.workItemCategoryFilter.setFilterValue(moduleConfiguration.getFilterSettings("ppmDocGen._FILTER_WORKITEM_CATEGORY"));
        this.workItemCategoryFilterItem.filterChanged();
        this.ressourceFilter.setActive(moduleConfiguration.isFilterActive("ppmDocGen._FILTER_RESSOURCE"));
        this.ressourceFilter.setFilterValue(moduleConfiguration.getFilterSettings("ppmDocGen._FILTER_RESSOURCE"));
        this.ressourceFilterItem.filterChanged();
        for (IFilterItem filterItem : this.customPropertiesFilterItems) {
            CustomPropertiesFilter filter = (CustomPropertiesFilter)filterItem.getFilter();
            filter.setActive(moduleConfiguration.isFilterActive(filter.getFilterID()));
            String value = moduleConfiguration.getFilterSettings(filter.getFilterID());
            if (value != null) {
                filter.setFilterValue(value);
            }
            filterItem.filterChanged();
        }
    }

    public void writeToConfiguration(DocGenConfigurationPerReport configuration) {
        ModuleConfiguration moduleConfig = new ModuleConfiguration(configuration);
        moduleConfig.addFilterSettings("ppmDocGen._FILTER_TASK_PM_PROJECT", this.projectPlanFilter.isActive(), this.projectPlanFilter.getFilterValue());
        moduleConfig.addFilterSettings("ppmDocGen._FILTER_TASK_IS_CRITICAL", this.taskIsCriticalFilter.isActive(), this.taskIsCriticalFilter.getFilterValue());
        moduleConfig.addFilterSettings("ppmDocGen._FILTER_TASK_DATE_START", this.taskStartDateFilter.isActive(), this.taskStartDateFilter.getFilterValue());
        moduleConfig.addFilterSettings("ppmDocGen._FILTER_TASK_DATE_FINISH", this.taskFinishDateFilter.isActive(), this.taskFinishDateFilter.getFilterValue());
        moduleConfig.addFilterSettings("ppmDocGen._FILTER_TASK_STATUS", this.taskStatusFilter.isActive(), this.taskStatusFilter.getFilterValue());
        moduleConfig.addFilterSettings("ppmDocGen._FILTER_RESSOURCE", this.ressourceFilter.isActive(), this.ressourceFilter.getFilterValue());
        moduleConfig.addFilterSettings("ppmDocGen._FILTER_WORKITEM_IS_UNDERESTIMATED", this.workItemIsUnderestimatedFilter.isActive(), this.workItemIsUnderestimatedFilter.getFilterValue());
        moduleConfig.addFilterSettings("ppmDocGen._FILTER_WORKITEM_IS_COMPLETE", this.workItemIsCompleteFilter.isActive(), this.workItemIsCompleteFilter.getFilterValue());
        moduleConfig.addFilterSettings("ppmDocGen._FILTER_WORKITEM_MOD_DATE_START", this.workItemModificationDateFilter.isActive(), this.workItemModificationDateFilter.getFilterValue());
        moduleConfig.addFilterSettings("ppmDocGen._FILTER_WORKITEM_CREATION_DATE_START", this.workItemCreationDateFilter.isActive(), this.workItemCreationDateFilter.getFilterValue());
        moduleConfig.addFilterSettings("ppmDocGen._FILTER_WORKITEM_CATEGORY", this.workItemCategoryFilter.isActive(), this.workItemCategoryFilter.getFilterValue());
        for (IFilterItem filterItem : this.customPropertiesFilterItems) {
            CustomPropertiesFilter filter = (CustomPropertiesFilter)filterItem.getFilter();
            moduleConfig.addFilterSettings(filter.getFilterID(), filter.isActive(), filter.getFilterValue());
        }
    }
}

