/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.projectplanningmodule2.docgen.filter;

import com.arcway.cockpit.cockpitlib.client.filter.AbstractBooleanValueFilter;
import com.arcway.cockpit.cockpitlib.client.filter.AbstractDateValuesFilter;
import com.arcway.cockpit.cockpitlib.client.filter.AbstractDiscreteValueFilter;
import com.arcway.cockpit.cockpitlib.client.filter.AbstractTextValuesFilter;
import com.arcway.cockpit.cockpitlib.client.filter.ExtendableViewerFilter;
import com.arcway.cockpit.frame.client.project.docgenerator.configuration.DocGenConfigurationPerReport;
import com.arcway.cockpit.projectplanningmodule2.client.core.project.ModuleDataFacade;
import com.arcway.cockpit.projectplanningmodule2.client.gui.ProjectPlanningFilters;
import com.arcway.cockpit.projectplanningmodule2.docgen.ModuleConfiguration;
import org.eclipse.jface.viewers.ViewerFilter;

public class TaskWorkitemFilter
extends ExtendableViewerFilter {
    private final AbstractTextValuesFilter projectPlanFilter;
    private final AbstractBooleanValueFilter taskIsCriticalFilter;
    private final AbstractDateValuesFilter taskStartDateFilter;
    private final AbstractDateValuesFilter taskFinishDateFilter;
    private final AbstractDiscreteValueFilter taskStatusFilter;
    private final AbstractTextValuesFilter ressourceFilter;
    private final AbstractBooleanValueFilter workItemIsUnderestimatedFilter;
    private final AbstractBooleanValueFilter workItemIsCompleteFilter;
    private final AbstractDateValuesFilter workItemModificationDateFilter;
    private final AbstractTextValuesFilter workItemCategoryFilter;

    public TaskWorkitemFilter(ModuleDataFacade moduleDataFacade) {
        ProjectPlanningFilters projectPlanningFilters = moduleDataFacade.getFilterFactory();
        this.projectPlanFilter = projectPlanningFilters.createProjectPlanFilter();
        this.taskIsCriticalFilter = projectPlanningFilters.createTaskIsCriticalFilter();
        this.taskStartDateFilter = projectPlanningFilters.createTaskStartDateFilter();
        this.taskFinishDateFilter = projectPlanningFilters.createTaskEndDateFilter();
        this.taskStatusFilter = projectPlanningFilters.createTaskStatusFilter();
        this.ressourceFilter = projectPlanningFilters.createResourceFilter();
        this.workItemIsUnderestimatedFilter = projectPlanningFilters.createWorkItemEffortUnderestimatedFilter();
        this.workItemIsCompleteFilter = projectPlanningFilters.createWorkItemDoneFilter();
        this.workItemModificationDateFilter = projectPlanningFilters.createWorkItemLastChangeFilter();
        this.workItemCategoryFilter = projectPlanningFilters.createWorkItemCategoryFilter();
        this.addFilter((ViewerFilter)this.projectPlanFilter);
        this.addFilter((ViewerFilter)this.taskIsCriticalFilter);
        this.addFilter((ViewerFilter)this.taskStartDateFilter);
        this.addFilter((ViewerFilter)this.taskFinishDateFilter);
        this.addFilter((ViewerFilter)this.taskStatusFilter);
        this.addFilter((ViewerFilter)this.ressourceFilter);
        this.addFilter((ViewerFilter)this.workItemIsUnderestimatedFilter);
        this.addFilter((ViewerFilter)this.workItemIsCompleteFilter);
        this.addFilter((ViewerFilter)this.workItemModificationDateFilter);
        this.addFilter((ViewerFilter)this.workItemCategoryFilter);
    }

    public void configure(DocGenConfigurationPerReport configuration) {
        ModuleConfiguration moduleConfiguration = new ModuleConfiguration(configuration);
        this.projectPlanFilter.setActive(moduleConfiguration.isFilterActive("ppmDocGen._FILTER_TASK_PM_PROJECT"));
        this.projectPlanFilter.initWithSemicolonSeparatedString(moduleConfiguration.getFilterSettings("ppmDocGen._FILTER_TASK_PM_PROJECT"));
        this.taskIsCriticalFilter.setActive(moduleConfiguration.isFilterActive("ppmDocGen._FILTER_TASK_IS_CRITICAL"));
        this.taskIsCriticalFilter.setup(moduleConfiguration.getFilterSettings("ppmDocGen._FILTER_TASK_IS_CRITICAL"));
        this.taskStartDateFilter.setActive(moduleConfiguration.isFilterActive("ppmDocGen._FILTER_TASK_DATE_START"));
        this.taskStartDateFilter.init(moduleConfiguration.getFilterSettings("ppmDocGen._FILTER_TASK_DATE_START"));
        this.taskFinishDateFilter.setActive(moduleConfiguration.isFilterActive("ppmDocGen._FILTER_TASK_DATE_FINISH"));
        this.taskFinishDateFilter.init(moduleConfiguration.getFilterSettings("ppmDocGen._FILTER_TASK_DATE_FINISH"));
        this.taskStatusFilter.setActive(moduleConfiguration.isFilterActive("ppmDocGen._FILTER_TASK_STATUS"));
        this.taskStatusFilter.initWithSemicolonSeparatedString(moduleConfiguration.getFilterSettings("ppmDocGen._FILTER_TASK_STATUS"));
        this.workItemIsUnderestimatedFilter.setActive(moduleConfiguration.isFilterActive("ppmDocGen._FILTER_WORKITEM_IS_UNDERESTIMATED"));
        this.workItemIsUnderestimatedFilter.setup(moduleConfiguration.getFilterSettings("ppmDocGen._FILTER_WORKITEM_IS_UNDERESTIMATED"));
        this.workItemIsCompleteFilter.setActive(moduleConfiguration.isFilterActive("ppmDocGen._FILTER_WORKITEM_IS_COMPLETE"));
        this.workItemIsCompleteFilter.setup(moduleConfiguration.getFilterSettings("ppmDocGen._FILTER_WORKITEM_IS_COMPLETE"));
        this.workItemModificationDateFilter.setActive(moduleConfiguration.isFilterActive("ppmDocGen._FILTER_WORKITEM_MOD_DATE_START"));
        this.workItemModificationDateFilter.init(moduleConfiguration.getFilterSettings("ppmDocGen._FILTER_WORKITEM_MOD_DATE_START"));
        this.workItemCategoryFilter.setActive(moduleConfiguration.isFilterActive("ppmDocGen._FILTER_WORKITEM_CATEGORY"));
        this.workItemCategoryFilter.initWithSemicolonSeparatedString(moduleConfiguration.getFilterSettings("ppmDocGen._FILTER_WORKITEM_CATEGORY"));
        this.ressourceFilter.setActive(moduleConfiguration.isFilterActive("ppmDocGen._FILTER_RESSOURCE"));
        this.ressourceFilter.initWithSemicolonSeparatedString(moduleConfiguration.getFilterSettings("ppmDocGen._FILTER_RESSOURCE"));
    }
}

