/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.projectplanningmodule2.msprojectadapter.synchronizer;

import com.arcway.cockpit.interFace.ICockpitProjectData;
import com.arcway.cockpit.modulelib2.client.core.project.AbstractLockManager;
import com.arcway.cockpit.modulelib2.client.core.project.LockAccess;
import com.arcway.cockpit.projectplanningmodule2.client.ProjectPlanningModule2Plugin;
import com.arcway.cockpit.projectplanningmodule2.client.adapterlib.SelectionWrapper;
import com.arcway.cockpit.projectplanningmodule2.client.adapterlib.gui.ExportWizard;
import com.arcway.cockpit.projectplanningmodule2.client.adapterlib.gui.SynchronizeSelectTasksPage;
import com.arcway.cockpit.projectplanningmodule2.client.core.project.ModelController;
import com.arcway.cockpit.projectplanningmodule2.msprojectadapter.synchronizer.MSProjectSynchronizeManager;
import com.arcway.cockpit.projectplanningmodule2.msprojectadapter.synchronizer.MSProjectSynchronizeSelectProjectPage;
import com.arcway.cockpit.projectplanningmodule2.msprojectadapter.synchronizer.Messages;
import java.util.Collection;
import java.util.List;
import org.eclipse.jface.wizard.IWizardPage;

public class MSProjectSynchronizeWizard
extends ExportWizard {
    public MSProjectSynchronizeWizard(String projectUID) {
        super(projectUID, (ModelController)ProjectPlanningModule2Plugin.getDefault().getProjectManager().getModelController(projectUID));
    }

    public void addPages() {
        String title = Messages.getString("MSProjectSynchronizeWizard.0");
        this.projectPage = new MSProjectSynchronizeSelectProjectPage(title, this, this.modelController);
        this.taskPage = new SynchronizeSelectTasksPage(title, this.modelController);
        this.addPage((IWizardPage)this.projectPage);
        this.addPage((IWizardPage)this.taskPage);
    }

    private void synchronize(SelectionWrapper wrapper) {
        MSProjectSynchronizeManager synchronizeManager = new MSProjectSynchronizeManager();
        boolean exportActualWork = ((SynchronizeSelectTasksPage)this.taskPage).getExportActualWork();
        boolean exportWork = ((SynchronizeSelectTasksPage)this.taskPage).getExportWork();
        synchronizeManager.synchronize(this.getShell(), wrapper, this.taskPage.getProgressListener(), exportActualWork, exportWork, this.modelController);
    }

    protected void selectionChanged() {
        if (this.projectPage != null && this.taskPage != null) {
            this.taskPage.setInput(this.projectPage.getSelectedProjectPlan());
        }
    }

    public boolean performFinish() {
        SelectionWrapper wrapper = this.projectPage.getWrapper();
        AbstractLockManager lockMgr = this.modelController.getLockMgr();
        LockAccess lock = lockMgr.acquireEditLock((ICockpitProjectData)wrapper.getProjectPlan(), true);
        if (!lock.hasLock()) {
            lock.releaseLocks();
            return false;
        }
        List selectedTasks = this.taskPage.getSelectedTasks();
        wrapper.setTasksToExport((Collection)selectedTasks);
        this.synchronize(wrapper);
        return true;
    }
}

