/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.projectplanningmodule2.msprojectadapter.synchronizer;

import com.arcway.cockpit.modulelib2.client.messages.IModuleData;
import com.arcway.cockpit.projectplanningmodule2.client.adapterlib.gui.AbstractSelectProjectPage;
import com.arcway.cockpit.projectplanningmodule2.client.adapterlib.gui.IProgressListener;
import com.arcway.cockpit.projectplanningmodule2.client.adapterlib.gui.ProgressListener;
import com.arcway.cockpit.projectplanningmodule2.client.core.project.ModelController;
import com.arcway.cockpit.projectplanningmodule2.client.core.project.PermissionMgr;
import com.arcway.cockpit.projectplanningmodule2.client.messages.ProjectPlan;
import com.arcway.cockpit.projectplanningmodule2.client.messages.SourceFile;
import com.arcway.cockpit.projectplanningmodule2.msprojectadapter.synchronizer.MSProjectSynchronizeWizard;
import com.arcway.cockpit.projectplanningmodule2.msprojectadapter.synchronizer.Messages;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.eclipse.swt.widgets.Composite;

public class MSProjectSynchronizeSelectProjectPage
extends AbstractSelectProjectPage {
    private final List synchronizedProjectPlans;
    private final List unSynchronizedProjectPlans;
    private static final List<String> PROJECT_FILE_EXTENSION = Arrays.asList("mpp");
    private final MSProjectSynchronizeWizard exportWizard;

    public MSProjectSynchronizeSelectProjectPage(String pageName, MSProjectSynchronizeWizard exportWizard, ModelController modelController) {
        super(pageName, 1, PROJECT_FILE_EXTENSION, modelController, false);
        this.setDescription(Messages.getString("MSProjectSynchronizeSelectProjectPage.1"));
        this.setPageComplete(false);
        this.exportWizard = exportWizard;
        this.synchronizedProjectPlans = this.getProjectPlansSynchronizedWithMSProject();
        this.unSynchronizedProjectPlans = this.getUnsynchronizedProjectPlans();
    }

    private List getProjectPlansSynchronizedWithMSProject() {
        Collection projects = this.modelController.getAllProjectPlans();
        ArrayList<ProjectPlan> synchronizedPPs = new ArrayList<ProjectPlan>();
        for (ProjectPlan projectPlan : projects) {
            if (this.getMSProjectSourceFile(projectPlan) == null) continue;
            synchronizedPPs.add(projectPlan);
        }
        return synchronizedPPs;
    }

    private List getUnsynchronizedProjectPlans() {
        Collection projects = this.modelController.getAllProjectPlans();
        ArrayList<ProjectPlan> unsynchronizedProjectPlans = new ArrayList<ProjectPlan>();
        for (ProjectPlan projectPlan : projects) {
            if (this.getSourceFile(projectPlan) != null) continue;
            unsynchronizedProjectPlans.add(projectPlan);
        }
        return unsynchronizedProjectPlans;
    }

    private SourceFile getMSProjectSourceFile(ProjectPlan projectPlan) {
        SourceFile sourceFile = this.getSourceFile(projectPlan);
        if (sourceFile != null && sourceFile.getPath().getValue().getFileExtension().equals("mpp")) {
            return sourceFile;
        }
        return null;
    }

    private SourceFile getSourceFile(ProjectPlan projectPlan) {
        Iterator i = this.modelController.getLinkableObjects((IModuleData)projectPlan, "ProjectSourceFile").iterator();
        if (i.hasNext()) {
            return (SourceFile)i.next();
        }
        return null;
    }

    protected void createProjectPlanEntries(Composite parent) {
        for (ProjectPlan pmProject : this.synchronizedProjectPlans) {
            this.addRow(pmProject);
        }
        for (ProjectPlan pmProject : this.unSynchronizedProjectPlans) {
            this.addRow(pmProject);
        }
    }

    public ProjectPlan getSelectedProjectPlan() {
        int index = this.getSelectedProjectIndex();
        if (index < this.synchronizedProjectPlans.size()) {
            if (index >= 0) {
                return (ProjectPlan)this.synchronizedProjectPlans.get(index);
            }
            return null;
        }
        int newIndex = index - this.synchronizedProjectPlans.size();
        if (newIndex < this.unSynchronizedProjectPlans.size()) {
            if (newIndex >= 0) {
                return (ProjectPlan)this.unSynchronizedProjectPlans.get(newIndex);
            }
            return null;
        }
        return null;
    }

    protected void checkPageComplete() {
        ProjectPlan projectPlan;
        boolean selection = false;
        boolean valid = false;
        boolean noPermission = false;
        int index = this.getSelectedProjectIndex();
        if (index >= 0) {
            selection = true;
            String fileName = this.getFileName();
            if (fileName.length() > 0 && AbstractSelectProjectPage.filenameHasAllowedExtension((String)fileName, PROJECT_FILE_EXTENSION)) {
                valid = true;
            }
        }
        if ((projectPlan = this.getSelectedProjectPlan()) != null && !((PermissionMgr)this.modelController.getPermissionMgr()).mayEditProjectPlan(projectPlan)) {
            noPermission = true;
        }
        if (selection && valid && !noPermission) {
            this.setErrorMessage(null);
            this.setPageComplete(true);
        } else if (noPermission) {
            this.setErrorMessage(Messages.getString("MSProjectSynchronizeSelectProjectPage.0"));
            this.setPageComplete(false);
        } else if (!selection) {
            this.setErrorMessage(Messages.getString("MSProjectSynchronizeSelectProjectPage.3"));
            this.setPageComplete(false);
        } else {
            this.setErrorMessage(Messages.getString("MSProjectSynchronizeSelectProjectPage.4"));
            this.setPageComplete(false);
        }
    }

    protected void projectSelectionChanged() {
        SourceFile sourceFile;
        this.selectionChanged();
        ProjectPlan projectPlan = this.getSelectedProjectPlan();
        if (projectPlan != null && (sourceFile = this.getSourceFile(projectPlan)) != null) {
            this.setFileName(sourceFile.getPath().getDisplayStringRepresentation());
            this.modifiedFileNameManually = false;
            return;
        }
        if (!this.modifiedFileNameManually) {
            this.setFileName("");
            this.modifiedFileNameManually = false;
        }
    }

    IProgressListener getProgressListener() {
        assert (this.progressBar != null);
        return new ProgressListener(this.progressBar);
    }

    protected void selectionChanged() {
        this.exportWizard.selectionChanged();
    }

    protected void writeMessageNoProjects() {
    }
}

