/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.projectplanningmodule2.msprojectadapter.synchronizer;

import au.com.swz.swttocom.swt.ResourceManager;
import com.arcway.cockpit.projectplanningmodule2.client.adapterlib.SelectionWrapper;
import com.arcway.cockpit.projectplanningmodule2.client.adapterlib.SynchronizeHelper;
import com.arcway.cockpit.projectplanningmodule2.client.adapterlib.gui.IProgressListener;
import com.arcway.cockpit.projectplanningmodule2.client.core.project.ModelController;
import com.arcway.cockpit.projectplanningmodule2.client.core.project.RessourceWorkCumulator;
import com.arcway.cockpit.projectplanningmodule2.client.messages.ProjectPlan;
import com.arcway.cockpit.projectplanningmodule2.msprojectadapter.synchronizer.Messages;
import com.arcway.lib.eclipse.ole.project.Application;
import com.arcway.lib.eclipse.ole.project.Assignment;
import com.arcway.lib.eclipse.ole.project.Assignments;
import com.arcway.lib.eclipse.ole.project.Project;
import com.arcway.lib.eclipse.ole.project.Resource;
import com.arcway.lib.eclipse.ole.project.Resources;
import com.arcway.lib.eclipse.ole.project.Task;
import com.arcway.lib.eclipse.ole.project.Tasks;
import com.arcway.lib.eclipse.ole.project._MSProject;
import com.arcway.lib.eclipse.ole.project.util.TypeLibPatches;
import de.plans.lib.util.Logger;
import de.plans.lib.util.valueranges.ValueRangeHelperDuration;
import de.plans.psc.client.dialogs.swt.ExceptionDialog;
import java.io.File;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.Iterator;
import java.util.TimeZone;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.ole.win32.Variant;
import org.eclipse.swt.widgets.Shell;

public class MSProjectSynchronizeManager {
    private static final Logger logger = Logger.getLogger(MSProjectSynchronizeManager.class);
    private _MSProject app;
    private Project activeProj;
    private IProgressListener progressListener = null;
    DateFormat dateFormater = null;
    private static final Calendar calendar = new GregorianCalendar(TimeZone.getDefault());

    public void synchronize(Shell shell, SelectionWrapper wrapper, IProgressListener progressListener1, boolean exportActualWork, boolean exportWorkForecast, ModelController modelController) {
        block24: {
            assert (shell != null) : "shell is null";
            assert (wrapper != null) : "wrapper list is null";
            assert (progressListener1 != null) : "progressListener is null";
            assert (modelController != null) : "modelController is null";
            this.progressListener = progressListener1;
            SynchronizeHelper synchronizeHelper = new SynchronizeHelper(modelController, wrapper.getProjectPlan(), new File(wrapper.getFileName()));
            if (!synchronizeHelper.requestLocks()) {
                progressListener1.errorOccurred();
                return;
            }
            int parts = 2;
            progressListener1.setProgressParts(parts);
            ResourceManager resourceManager = new ResourceManager();
            try {
                try {
                    progressListener1.setCurrentPartProgress(10);
                    boolean appStarted = false;
                    try {
                        this.app = Application.create((int)6, (ResourceManager)resourceManager, (boolean)true);
                        progressListener1.setCurrentPartProgress(100);
                        appStarted = true;
                    }
                    catch (Exception e) {
                        logger.error((Object)"Error when synchronizing with MSProject. Probably not installed.", (Throwable)e);
                        progressListener1.errorOccurred();
                        MessageDialog mDialog = new MessageDialog(shell, Messages.getString("MSProjectSynchronizeManager.6"), null, Messages.getString("MSProjectSynchronizeManager.7"), 2, new String[]{IDialogConstants.OK_LABEL}, 0);
                        mDialog.open();
                    }
                    if (!appStarted) break block24;
                    int dateOrder = this.app.get_Var_DateOrder();
                    switch (dateOrder) {
                        case 0: {
                            this.dateFormater = new SimpleDateFormat("dd.MM.yy");
                            break;
                        }
                        case 1: {
                            this.dateFormater = new SimpleDateFormat("MM/dd/yy");
                            break;
                        }
                        case 2: {
                            this.dateFormater = new SimpleDateFormat("yy/MM/dd");
                            break;
                        }
                        default: {
                            this.dateFormater = new SimpleDateFormat("MM/dd/yy");
                        }
                    }
                    this.app.set_Var_Visible(true);
                    boolean success = this.exportTasksToMSProjectFile(shell, wrapper, exportActualWork, exportWorkForecast, synchronizeHelper, modelController);
                    if (success) {
                        this.reimportTasksFromMSProjectFile(synchronizeHelper, modelController.getProjectUID());
                        synchronizeHelper.commitToModelController();
                        break block24;
                    }
                    synchronizeHelper.releaseLocks();
                }
                catch (Exception e) {
                    logger.error((Object)"Error when synchronizing with MSProject. Unexpected Exception: ", (Throwable)e);
                    progressListener1.errorOccurred();
                    ExceptionDialog dialog = new ExceptionDialog(shell, (Throwable)e);
                    dialog.create();
                    dialog.setTitle(Messages.getString("MSProjectSynchronizeManager.8"));
                    dialog.setMessage(Messages.getString("MSProjectSynchronizeManager.9"));
                    dialog.open();
                    if (this.app != null) {
                        if (!progressListener1.hasErrorOccured()) {
                            progressListener1.setCurrentPartProgress(50);
                        }
                        this.app = null;
                    }
                    resourceManager.shutdown();
                    if (!progressListener1.hasErrorOccured()) {
                        progressListener1.setCurrentPartProgress(100);
                    }
                }
            }
            finally {
                if (this.app != null) {
                    if (!progressListener1.hasErrorOccured()) {
                        progressListener1.setCurrentPartProgress(50);
                    }
                    this.app = null;
                }
                resourceManager.shutdown();
                if (!progressListener1.hasErrorOccured()) {
                    progressListener1.setCurrentPartProgress(100);
                }
            }
        }
    }

    private boolean exportTasksToMSProjectFile(Shell shell, SelectionWrapper wrapper, boolean exportActualWork, boolean exportWorkForecast, SynchronizeHelper synchronizeHelper, ModelController modelController) {
        assert (shell != null) : "shell is null";
        assert (wrapper != null) : "export wrapper object is null";
        ProjectPlan projectPlan = wrapper.getProjectPlan();
        File file = new File(wrapper.getFileName());
        if (file.exists()) {
            TypeLibPatches.MSProject_FileOpen((_MSProject)this.app, (String)wrapper.getFileName());
            this.activeProj = this.app.get_Var_ActiveProject();
        } else {
            if (modelController.getSourceFile(projectPlan) != null) {
                MessageDialog mDialog = new MessageDialog(shell, Messages.getString("MSProjectSynchronizeManager.0"), null, String.valueOf(Messages.getString("MSProjectSynchronizeManager.1")) + Messages.getString("MSProjectSynchronizeManager.2"), 2, new String[]{IDialogConstants.OK_LABEL}, 0);
                mDialog.open();
                if (!this.progressListener.isCurrentPartComplete()) {
                    this.progressListener.setCurrentPartProgress(100);
                }
                return false;
            }
            this.app.FileNew();
            TypeLibPatches.MSProject_FileSaveAs((_MSProject)this.app, (String)wrapper.getFileName());
            this.activeProj = this.app.get_Var_ActiveProject();
        }
        this.app.get_Var_DefaultDateFormat();
        String externalProjectUID = String.valueOf(this.activeProj.get_UniqueID());
        if (projectPlan.getExternalUID().getValue() != null) {
            if (!externalProjectUID.equals(projectPlan.getExternalUID().getValue())) {
                MessageDialog mDialog = new MessageDialog(shell, Messages.getString("MSProjectSynchronizeManager.3"), null, String.valueOf(Messages.getString("MSProjectSynchronizeManager.4")) + Messages.getString("MSProjectSynchronizeManager.5"), 2, new String[]{IDialogConstants.OK_LABEL}, 0);
                mDialog.open();
                if (!this.progressListener.isCurrentPartComplete()) {
                    this.progressListener.setCurrentPartProgress(100);
                }
                return false;
            }
        } else {
            synchronizeHelper.setExternalUIDOfProjectPlan(externalProjectUID);
        }
        Tasks tasks = this.activeProj.get_Tasks();
        int[] externalTasksUIDs = new int[tasks.get_Count()];
        int taskNumber = tasks.get_Count();
        int i = 1;
        while (i <= taskNumber) {
            Task task = tasks.get_Item((Object)new Integer(i));
            externalTasksUIDs[i - 1] = task != null ? task.get_UniqueID() : 0;
            ++i;
        }
        Arrays.sort(externalTasksUIDs);
        Collection tasksToExport = wrapper.getTasksToExport();
        int progressStep = 0;
        int progress = 100;
        if (tasksToExport.size() > 0) {
            progressStep = (int)Math.ceil(60.0 / (double)tasksToExport.size());
            progress = 20;
        }
        Iterator it = tasksToExport.iterator();
        while (it.hasNext()) {
            if (progress < 100) {
                if ((progress += progressStep) > 100) {
                    progress = 100;
                }
                this.progressListener.setCurrentPartProgress(progress);
            }
            com.arcway.cockpit.projectplanningmodule2.client.messages.Task taskToExport = (com.arcway.cockpit.projectplanningmodule2.client.messages.Task)it.next();
            RessourceWorkCumulator workComulator = modelController.getRessourceWorkCumulator(taskToExport);
            Task task = null;
            String msProjectTaskUID = taskToExport.getExternalUID().getValue();
            if (msProjectTaskUID != null) {
                int externalUID = Integer.parseInt(msProjectTaskUID);
                int index = Arrays.binarySearch(externalTasksUIDs, externalUID);
                if (index >= 0) {
                    task = tasks.get_UniqueID(externalUID);
                }
            } else {
                task = this.createTaskInMSProject(tasks, taskToExport, true);
                synchronizeHelper.taskCreatedInMSProject(taskToExport);
            }
            if (task == null) continue;
            this.exportWorkAndResources(exportActualWork, exportWorkForecast, workComulator, task);
        }
        if (progress < 100) {
            this.progressListener.setCurrentPartProgress(100);
        }
        return true;
    }

    private void exportWorkAndResources(boolean exportActualWork, boolean exportWorkForecast, RessourceWorkCumulator workComulator, Task task) {
        Assignments assignments = task.get_Assignments();
        boolean repeatExportOfWork = true;
        while (repeatExportOfWork) {
            repeatExportOfWork = false;
            HashMap<String, Assignment> assignementMap = new HashMap<String, Assignment>();
            int i = assignments.get_Count();
            while (i > 0) {
                Assignment assignment = assignments.get_Item((Object)new Integer(i));
                String resourceName = assignment.get_ResourceName();
                if (workComulator.containsRessource(resourceName)) {
                    ValueRangeHelperDuration vrh;
                    if (exportActualWork) {
                        vrh = (ValueRangeHelperDuration)workComulator.getWorkDone(resourceName).getValueRangeHelper();
                        assignment.set_ActualWork((Object)new Short((short)vrh.getDurationInSpecificUnit(2)));
                    }
                    if (exportWorkForecast) {
                        vrh = (ValueRangeHelperDuration)workComulator.getWorkForecast(resourceName).getValueRangeHelper();
                        assignment.set_Work((Object)new Short((short)vrh.getDurationInSpecificUnit(2)));
                    }
                    assignementMap.put(resourceName, assignment);
                } else {
                    assignment.Delete();
                }
                --i;
            }
            for (String resourceName : workComulator.getResourceNames()) {
                ValueRangeHelperDuration vrh;
                if (assignementMap.containsKey(resourceName)) continue;
                Resource resource = this.findOrCreateResource(resourceName, this.activeProj);
                Assignment assignment = assignments.Add((Object)task.get_ID(), (Object)resource.get_ID());
                repeatExportOfWork = true;
                if (exportActualWork) {
                    vrh = (ValueRangeHelperDuration)workComulator.getWorkDone(resourceName).getValueRangeHelper();
                    assignment.set_ActualWork((Object)new Short((short)vrh.getDurationInSpecificUnit(2)));
                }
                if (!exportWorkForecast) continue;
                vrh = (ValueRangeHelperDuration)workComulator.getWorkForecast(resourceName).getValueRangeHelper();
                assignment.set_Work((Object)new Short((short)vrh.getDurationInSpecificUnit(2)));
            }
        }
    }

    private void reimportTasksFromMSProjectFile(SynchronizeHelper synchronizeHelper, String projectUID) {
        Tasks tasks = this.activeProj.get_Tasks();
        int taskNumber = tasks.get_Count();
        int progressStep = (int)Math.ceil(100.0 / (double)taskNumber);
        int progress = 0;
        int i = 1;
        while (i <= taskNumber) {
            Task task;
            if (progress < 100) {
                if ((progress += progressStep) > 100) {
                    progress = 100;
                }
                this.progressListener.setCurrentPartProgress(progress);
            }
            if ((task = tasks.get_Item((Object)new Integer(i))) != null) {
                MSProjectSynchronizeManager.importTask(task, projectUID, synchronizeHelper);
            }
            ++i;
        }
    }

    public static void importTask(Task msProjectTask, String projectUID, SynchronizeHelper synchronizeHelper) {
        Float value;
        int msProjectTaskUID = msProjectTask.get_UniqueID();
        com.arcway.cockpit.projectplanningmodule2.client.messages.Task cockpitTask = synchronizeHelper.getExistingTaskByExternalUID(String.valueOf(msProjectTaskUID));
        if (cockpitTask == null) {
            cockpitTask = new com.arcway.cockpit.projectplanningmodule2.client.messages.Task();
            cockpitTask.getExternalUID().setValue(String.valueOf(msProjectTaskUID));
        }
        cockpitTask.setProjectUID(projectUID);
        cockpitTask.getName().setValue(msProjectTask.get_Name());
        Variant variant = msProjectTask.get_Start();
        Float f = value = variant != null && variant.getType() == 4 ? Float.valueOf(variant.getFloat()) : null;
        if (value instanceof Float) {
            cockpitTask.getStart().setValue(MSProjectSynchronizeManager.computeDate(value));
        } else {
            cockpitTask.getStart().setValue(null);
        }
        variant = msProjectTask.get_Finish();
        Float f2 = value = variant != null && variant.getType() == 4 ? Float.valueOf(variant.getFloat()) : null;
        if (value instanceof Float) {
            cockpitTask.getFinish().setValue(MSProjectSynchronizeManager.computeDate(value));
        } else {
            cockpitTask.getFinish().setValue(null);
        }
        variant = msProjectTask.get_Work();
        Float f3 = value = variant != null && variant.getType() == 4 ? Float.valueOf(variant.getFloat()) : null;
        if (value instanceof Float) {
            ValueRangeHelperDuration vrh = (ValueRangeHelperDuration)cockpitTask.getOriginalWork().getValueRangeHelper();
            vrh.setDurationInSpecificUnit(2, (long)value.intValue());
        } else {
            cockpitTask.getOriginalWork().setValue(0L);
        }
        variant = msProjectTask.get_PercentWorkComplete();
        Float f4 = value = variant != null && variant.getType() == 4 ? Float.valueOf(variant.getFloat()) : null;
        if (value instanceof Float) {
            cockpitTask.getOriginalPercentWorkComplete().setValue(value.intValue());
        } else {
            cockpitTask.getOriginalPercentWorkComplete().setValue(0);
        }
        cockpitTask.getResourceNames().setValue(msProjectTask.get_ResourceNames());
        variant = msProjectTask.get_Critical();
        Comparable<Boolean> comparable = value = variant != null && variant.getType() == 11 ? Boolean.valueOf(variant.getBoolean()) : null;
        if (value instanceof Boolean) {
            cockpitTask.isCritical().setValue(((Boolean)((Object)value)).booleanValue());
        } else {
            cockpitTask.isCritical().setValue(false);
        }
        variant = msProjectTask.get_Priority();
        Number number = value = variant != null && variant.getType() == 2 ? Short.valueOf(variant.getShort()) : null;
        if (value instanceof Short) {
            cockpitTask.getPriority().setValue(((Short)((Object)value)).intValue());
        } else {
            cockpitTask.getPriority().setValue(0);
        }
        variant = msProjectTask.get_Milestone();
        Comparable<Boolean> comparable2 = value = variant != null && variant.getType() == 11 ? Boolean.valueOf(variant.getBoolean()) : null;
        if (value instanceof Boolean) {
            cockpitTask.isMilestone().setValue(((Boolean)((Object)value)).booleanValue());
        } else {
            cockpitTask.isMilestone().setValue(false);
        }
        cockpitTask.getState().setValue(MSProjectSynchronizeManager.getStatus(msProjectTask));
        int taskID = msProjectTask.get_ID();
        cockpitTask.getID().setValue(taskID);
        synchronizeHelper.addImportedTask(cockpitTask);
        int parentID = msProjectTask.get_OutlineParent().get_ID();
        synchronizeHelper.addParentChildRelationShip(parentID, taskID);
    }

    private Task createTaskInMSProject(Tasks msProjectTasksObject, com.arcway.cockpit.projectplanningmodule2.client.messages.Task cockpitTask, boolean updateCockpitTask) {
        Task task = msProjectTasksObject.Add();
        task.set_OutlineLevel(1);
        if (cockpitTask.getStart() != null && cockpitTask.getStart().getValue() != null) {
            task.set_Start((Object)this.dateFormater.format(new Date(cockpitTask.getStart().getValue())));
        }
        if (cockpitTask.getFinish() != null && cockpitTask.getFinish().getValue() != null) {
            task.set_Finish((Object)this.dateFormater.format(new Date(cockpitTask.getFinish().getValue())));
        }
        task.set_Name(cockpitTask.getName().getValue());
        if (cockpitTask.isMilestone().getValue()) {
            task.set_Milestone((Object)Boolean.TRUE);
        }
        ValueRangeHelperDuration vrh = (ValueRangeHelperDuration)cockpitTask.getOriginalWork().getValueRangeHelper();
        task.set_Work((Object)new Short((short)vrh.getDurationInSpecificUnit(2)));
        if (updateCockpitTask) {
            cockpitTask.getID().setValue(task.get_ID());
            cockpitTask.getExternalUID().setValue(new Integer(task.get_UniqueID()).toString());
        }
        return task;
    }

    private Resource findOrCreateResource(String name, Project project) {
        Resources resources = project.get_Resources();
        int resourceCount = resources.get_Count();
        int i = 1;
        while (i < resourceCount) {
            Resource resource = resources.get_Item((Object)new Integer(i));
            if (resource.get_Name().equals(name)) {
                return resource;
            }
            ++i;
        }
        Resource resource = resources.Add((Object)name);
        return resource;
    }

    private static long computeDate(Float date) {
        calendar.set(1899, 11, 31);
        int days = date.intValue() - 1;
        calendar.add(5, days);
        return calendar.getTimeInMillis();
    }

    private static int getStatus(Task task) {
        assert (task != null) : "imported task is null";
        try {
            return task.get_Status();
        }
        catch (Exception e) {
            return 4;
        }
    }
}

