/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.projectplanningmodule2.msprojectadapter.importer;

import com.arcway.cockpit.frame.client.global.gui.wizards.NoLicenseWizardPage;
import com.arcway.cockpit.frame.client.global.license.IClientFunctionLicenseType;
import com.arcway.cockpit.projectplanningmodule2.client.ProjectPlanningModule2Plugin;
import com.arcway.cockpit.projectplanningmodule2.client.core.project.ModelController;
import com.arcway.cockpit.projectplanningmodule2.msprojectadapter.PPMMSProjectLicenseType;
import com.arcway.cockpit.projectplanningmodule2.msprojectadapter.importer.MSProjectImportManager;
import com.arcway.cockpit.projectplanningmodule2.msprojectadapter.importer.MSProjectImportSelectFilePage;
import com.arcway.cockpit.projectplanningmodule2.msprojectadapter.importer.Messages;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;

public class MSProjectImportWizard
extends Wizard {
    private final ModelController modelController;
    private MSProjectImportSelectFilePage selectFilePage;

    public MSProjectImportWizard(ModelController modelController) {
        this.modelController = modelController;
        this.setWindowTitle(Messages.getString("MSProjectImportWizard.1"));
        this.setDefaultPageImageDescriptor(ProjectPlanningModule2Plugin.getImageDescriptor((String)"export_wiz_big.gif"));
        this.addPages();
    }

    public void addPages() {
        if (this.modelController.getProjectAgent().getServerLicenseManager().isLicenseOperationAllowed((IClientFunctionLicenseType)PPMMSProjectLicenseType.getInstance())) {
            String title = Messages.getString("MSProjectImportWizard.0");
            this.selectFilePage = new MSProjectImportSelectFilePage(title, this, this.modelController);
            this.addPage((IWizardPage)this.selectFilePage);
        } else {
            NoLicenseWizardPage noLicenseWizardPage = new NoLicenseWizardPage(Messages.getString("MSProjectImportWizard.import_from_msproject"), (IClientFunctionLicenseType)PPMMSProjectLicenseType.getInstance());
            this.addPage((IWizardPage)noLicenseWizardPage);
        }
    }

    public boolean performFinish() {
        if (this.selectFilePage != null) {
            String projectName = this.selectFilePage.getProjectName();
            String fileName = this.selectFilePage.getImportFileName();
            this.importTasks(projectName, fileName);
        }
        return true;
    }

    protected void importTasks(String projectName, String fileName) {
        MSProjectImportManager importManager = new MSProjectImportManager();
        importManager.importTasks(this.getShell(), projectName, fileName, this.selectFilePage.getProgressListener(), this.modelController);
    }
}

