/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.projectplanningmodule2.msprojectadapter.importer;

import com.arcway.cockpit.projectplanningmodule2.client.adapterlib.gui.IProgressListener;
import com.arcway.cockpit.projectplanningmodule2.client.adapterlib.gui.ProgressListener;
import com.arcway.cockpit.projectplanningmodule2.client.core.project.ModelController;
import com.arcway.cockpit.projectplanningmodule2.client.core.project.PermissionMgr;
import com.arcway.cockpit.projectplanningmodule2.msprojectadapter.importer.MSProjectImportWizard;
import com.arcway.cockpit.projectplanningmodule2.msprojectadapter.importer.Messages;
import com.arcway.lib.io.FileSystemDefaultPaths;
import java.io.File;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.ProgressBar;
import org.eclipse.swt.widgets.Text;

public class MSProjectImportSelectFilePage
extends WizardPage {
    private static final String PROJECT_FILE_EXTENSION = ".mpp";
    private final MSProjectImportWizard importWizard;
    protected ModelController modelController;
    private final String fileType = ".mpp";
    protected ProgressBar progressBar;
    private Text txtProjectName;
    private Text txtFile;
    private boolean noPermission = true;

    public MSProjectImportSelectFilePage(String pageName, MSProjectImportWizard importWizard, ModelController modelController) {
        super(pageName);
        this.modelController = modelController;
        this.importWizard = importWizard;
        this.setDescription(Messages.getString("MSProjectImportSelectFilePage.1"));
        this.setPageComplete(false);
        PermissionMgr permissionMgr = (PermissionMgr)modelController.getPermissionMgr();
        if (permissionMgr.mayCreateProjectPlans()) {
            this.noPermission = false;
        } else {
            this.noPermission = true;
            this.checkPageComplete();
        }
    }

    public void createControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout(3, false));
        Label lblProjectName = new Label(composite, 0);
        lblProjectName.setText(Messages.getString("MSProjectImportSelectFilePage.2"));
        this.txtProjectName = new Text(composite, 2048);
        GridData gd = new GridData();
        gd.grabExcessHorizontalSpace = true;
        gd.horizontalAlignment = 4;
        gd.horizontalSpan = 1;
        this.txtProjectName.setLayoutData((Object)gd);
        this.txtProjectName.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                MSProjectImportSelectFilePage.this.checkPageComplete();
            }
        });
        new Label(composite, 0);
        Label lblFile = new Label(composite, 0);
        lblFile.setText(Messages.getString("MSProjectImportSelectFilePage.3"));
        this.txtFile = new Text(composite, 2048);
        gd = new GridData();
        gd.grabExcessHorizontalSpace = true;
        gd.horizontalAlignment = 4;
        this.txtFile.setLayoutData((Object)gd);
        this.txtFile.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                MSProjectImportSelectFilePage.this.checkPageComplete();
            }
        });
        Button browseButton = new Button(composite, 0);
        browseButton.setLayoutData((Object)new GridData(128));
        browseButton.setText(Messages.getString("MSProjectImportSelectFilePage.4"));
        browseButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                File file = MSProjectImportSelectFilePage.this.startFileSelectionDialog();
                if (file != null) {
                    MSProjectImportSelectFilePage.this.txtFile.setText(file.getAbsolutePath());
                    if (MSProjectImportSelectFilePage.this.txtProjectName.getText().length() == 0) {
                        MSProjectImportSelectFilePage.this.txtProjectName.setText(file.getName());
                    }
                }
            }
        });
        Label progressLabel = new Label(composite, 0);
        progressLabel.setText(Messages.getString("MSProjectImportSelectFilePage.8"));
        GridData gridData = new GridData();
        gridData.horizontalSpan = 2;
        progressLabel.setLayoutData((Object)gridData);
        this.progressBar = new ProgressBar(composite, 0);
        gridData = new GridData(776);
        gridData.horizontalSpan = 2;
        this.progressBar.setLayoutData((Object)gridData);
        this.setControl((Control)composite);
    }

    private File startFileSelectionDialog() {
        FileDialog dialog = new FileDialog(this.getShell());
        String[] extensions = new String[]{"*.mpp"};
        dialog.setFilterExtensions(extensions);
        dialog.setFilterPath(FileSystemDefaultPaths.getDefaultUserPathForLoading().getAbsolutePath());
        dialog.open();
        String fileName = dialog.getFileName();
        if (fileName == "") {
            return null;
        }
        if (!fileName.toLowerCase().endsWith(PROJECT_FILE_EXTENSION.toLowerCase())) {
            int separatorIndex = fileName.lastIndexOf(46);
            if (separatorIndex > 0) {
                fileName = fileName.substring(0, separatorIndex);
            }
            fileName = String.valueOf(fileName) + PROJECT_FILE_EXTENSION;
        }
        String filePathName = String.valueOf(dialog.getFilterPath()) + File.separator + fileName;
        return new File(filePathName);
    }

    protected void checkPageComplete() {
        if (this.noPermission) {
            this.setMessage(Messages.getString("MSProjectImportSelectFilePage.0"), 3);
            this.setPageComplete(false);
            return;
        }
        if (this.txtProjectName.getText().trim().length() == 0) {
            this.setMessage(Messages.getString("MSProjectImportSelectFilePage.5"), 3);
            this.setPageComplete(false);
            return;
        }
        String fileName = this.txtFile.getText().trim();
        if (fileName.length() == 0) {
            this.setMessage(Messages.getString("MSProjectImportSelectFilePage.6"), 3);
            this.setPageComplete(false);
            return;
        }
        File importFile = new File(fileName);
        if (!importFile.exists()) {
            this.setMessage(Messages.getString("MSProjectImportSelectFilePage.7"), 3);
            this.setPageComplete(false);
            return;
        }
        this.setMessage(null, 3);
        this.setPageComplete(true);
    }

    public String getProjectName() {
        return this.txtProjectName.getText().trim();
    }

    public String getImportFileName() {
        return this.txtFile.getText().trim();
    }

    IProgressListener getProgressListener() {
        assert (this.progressBar != null);
        return new ProgressListener(this.progressBar);
    }
}

