/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.projectplanningmodule2.msprojectadapter.importer;

import au.com.swz.swttocom.swt.ResourceManager;
import com.arcway.cockpit.projectplanningmodule2.client.adapterlib.ImportHelper;
import com.arcway.cockpit.projectplanningmodule2.client.adapterlib.gui.IProgressListener;
import com.arcway.cockpit.projectplanningmodule2.client.core.project.ModelController;
import com.arcway.cockpit.projectplanningmodule2.client.messages.ProjectPlan;
import com.arcway.cockpit.projectplanningmodule2.client.messages.Task;
import com.arcway.cockpit.projectplanningmodule2.msprojectadapter.importer.Messages;
import com.arcway.lib.eclipse.ole.project.Application;
import com.arcway.lib.eclipse.ole.project.Project;
import com.arcway.lib.eclipse.ole.project.Tasks;
import com.arcway.lib.eclipse.ole.project._MSProject;
import com.arcway.lib.eclipse.ole.project.util.TypeLibPatches;
import de.plans.lib.util.valueranges.ValueRangeHelperDuration;
import de.plans.psc.client.dialogs.swt.ExceptionDialog;
import java.io.File;
import java.io.FileNotFoundException;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.TimeZone;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.ole.win32.Variant;
import org.eclipse.swt.widgets.Shell;

public class MSProjectImportManager {
    private _MSProject app;
    private Project activeProj;
    private IProgressListener progressListener = null;
    private static final Calendar calendar = new GregorianCalendar(TimeZone.getDefault());

    protected void importTasks(Shell shell, String newPMPName, String newPMPFile, IProgressListener progressListener, ModelController modelController) {
        assert (shell != null) : "shell is null";
        assert (progressListener != null);
        this.progressListener = progressListener;
        int parts = 2;
        if (newPMPName != null && newPMPFile != null) {
            ++parts;
        }
        progressListener.setProgressParts(parts);
        ResourceManager resourceManager = new ResourceManager();
        progressListener.setCurrentPartProgress(10);
        try {
            try {
                boolean appStarted = false;
                try {
                    this.app = Application.create((int)6, (ResourceManager)resourceManager, (boolean)true);
                    progressListener.setCurrentPartProgress(100);
                    appStarted = true;
                }
                catch (Exception e) {
                    progressListener.errorOccurred();
                    MessageDialog mDialog = new MessageDialog(shell, Messages.getString("MSProjectImportManager.0"), null, Messages.getString("MSProjectImportManager.1"), 2, new String[]{IDialogConstants.OK_LABEL}, 0);
                    mDialog.open();
                }
                if (appStarted) {
                    this.app.set_Var_Visible(true);
                    if (newPMPName != null && newPMPFile != null) {
                        ProjectPlan newProjectPlan = new ProjectPlan();
                        newProjectPlan.getName().setValue(newPMPName);
                        newProjectPlan.setProjectUID(modelController.getProjectUID());
                        ImportHelper importHelper = new ImportHelper(modelController, newProjectPlan);
                        this.importTasksFromMSProjectFile(shell, newPMPFile, importHelper, modelController.getProjectUID());
                        importHelper.commitToModelController();
                    }
                }
            }
            catch (Exception e) {
                progressListener.errorOccurred();
                ExceptionDialog dialog = new ExceptionDialog(shell, (Throwable)e);
                dialog.create();
                dialog.setTitle(Messages.getString("MSProjectImportManager.2"));
                dialog.setMessage(Messages.getString("MSProjectImportManager.3"));
                dialog.open();
                if (this.app != null) {
                    if (!progressListener.hasErrorOccured()) {
                        progressListener.setCurrentPartProgress(50);
                    }
                    this.app = null;
                }
                resourceManager.shutdown();
                if (!progressListener.hasErrorOccured()) {
                    progressListener.setCurrentPartProgress(100);
                }
            }
        }
        finally {
            if (this.app != null) {
                if (!progressListener.hasErrorOccured()) {
                    progressListener.setCurrentPartProgress(50);
                }
                this.app = null;
            }
            resourceManager.shutdown();
            if (!progressListener.hasErrorOccured()) {
                progressListener.setCurrentPartProgress(100);
            }
        }
    }

    private void importTasksFromMSProjectFile(Shell shell, String projectFile, ImportHelper importHelper, String projectUID) {
        block10: {
            assert (shell != null) : "shell is null";
            assert (projectFile != null) : "projectFile is null";
            try {
                File file = new File(projectFile);
                if (!file.exists()) {
                    throw new FileNotFoundException(Messages.getString("MSProjectImportManager.Cannot_find_the_file_specified"));
                }
                TypeLibPatches.MSProject_FileOpen((_MSProject)this.app, (String)projectFile);
                this.activeProj = this.app.get_Var_ActiveProject();
                Tasks tasks = this.activeProj.get_Tasks();
                int taskNumber = tasks.get_Count();
                int progressStep = (int)Math.ceil(100.0 / (double)taskNumber);
                int progress = 0;
                int i = 1;
                while (i <= taskNumber) {
                    com.arcway.lib.eclipse.ole.project.Task task;
                    if (progress < 100) {
                        if ((progress += progressStep) > 100) {
                            progress = 100;
                        }
                        this.progressListener.setCurrentPartProgress(progress);
                    }
                    if ((task = tasks.get_Item((Object)new Integer(i))) != null) {
                        MSProjectImportManager.importTask(task, projectUID, importHelper);
                    }
                    ++i;
                }
                if (progress < 100) {
                    this.progressListener.setCurrentPartProgress(100);
                }
            }
            catch (FileNotFoundException e) {
                MessageDialog mDialog = new MessageDialog(shell, Messages.getString("MSProjectImportManager.Import_failed"), null, String.valueOf(Messages.getString("MSProjectImportManager.The_import_from_file")) + projectFile + Messages.getString("MSProjectImportManager._failed") + e.getMessage(), 2, new String[]{IDialogConstants.OK_LABEL}, 0);
                mDialog.open();
                if (this.progressListener.isCurrentPartComplete()) break block10;
                this.progressListener.setCurrentPartProgress(100);
            }
        }
    }

    public static void importTask(com.arcway.lib.eclipse.ole.project.Task msProjectTask, String projectUID, ImportHelper importHelper) {
        Float value;
        Task cockpitTask = new Task();
        cockpitTask.setProjectUID(projectUID);
        cockpitTask.getName().setValue(msProjectTask.get_Name());
        Variant variant = msProjectTask.get_Start();
        Float f = value = variant != null && variant.getType() == 4 ? Float.valueOf(variant.getFloat()) : null;
        if (value instanceof Float) {
            cockpitTask.getStart().setValue(MSProjectImportManager.computeDate(value));
        } else {
            cockpitTask.getStart().setValue(null);
        }
        variant = msProjectTask.get_Finish();
        Float f2 = value = variant != null && variant.getType() == 4 ? Float.valueOf(variant.getFloat()) : null;
        if (value instanceof Float) {
            cockpitTask.getFinish().setValue(MSProjectImportManager.computeDate(value));
        } else {
            cockpitTask.getFinish().setValue(null);
        }
        variant = msProjectTask.get_Work();
        Float f3 = value = variant != null && variant.getType() == 4 ? Float.valueOf(variant.getFloat()) : null;
        if (value instanceof Float) {
            ValueRangeHelperDuration vrh = (ValueRangeHelperDuration)cockpitTask.getOriginalWork().getValueRangeHelper();
            vrh.setDurationInSpecificUnit(2, (long)value.intValue());
        } else {
            cockpitTask.getOriginalWork().setValue(0L);
        }
        variant = msProjectTask.get_PercentWorkComplete();
        Float f4 = value = variant != null && variant.getType() == 4 ? Float.valueOf(variant.getFloat()) : null;
        if (value instanceof Float) {
            cockpitTask.getOriginalPercentWorkComplete().setValue(value.intValue());
        } else {
            cockpitTask.getOriginalPercentWorkComplete().setValue(0);
        }
        cockpitTask.getResourceNames().setValue(msProjectTask.get_ResourceNames());
        variant = msProjectTask.get_Critical();
        Comparable<Boolean> comparable = value = variant != null && variant.getType() == 11 ? Boolean.valueOf(variant.getBoolean()) : null;
        if (value instanceof Boolean) {
            cockpitTask.isCritical().setValue(((Boolean)((Object)value)).booleanValue());
        } else {
            cockpitTask.isCritical().setValue(false);
        }
        variant = msProjectTask.get_Priority();
        Number number = value = variant != null && variant.getType() == 2 ? Short.valueOf(variant.getShort()) : null;
        if (value instanceof Short) {
            cockpitTask.getPriority().setValue(((Short)((Object)value)).intValue());
        } else {
            cockpitTask.getPriority().setValue(0);
        }
        variant = msProjectTask.get_Milestone();
        Comparable<Boolean> comparable2 = value = variant != null && variant.getType() == 11 ? Boolean.valueOf(variant.getBoolean()) : null;
        if (value instanceof Boolean) {
            cockpitTask.isMilestone().setValue(((Boolean)((Object)value)).booleanValue());
        } else {
            cockpitTask.isMilestone().setValue(false);
        }
        cockpitTask.getState().setValue(MSProjectImportManager.getStatus(msProjectTask));
        int taskID = msProjectTask.get_ID();
        cockpitTask.getID().setValue(taskID);
        importHelper.addTask(cockpitTask);
        int parentID = msProjectTask.get_OutlineParent().get_ID();
        importHelper.addParentChildRelationShip(parentID, taskID);
    }

    private static int getStatus(com.arcway.lib.eclipse.ole.project.Task task) {
        assert (task != null) : "imported task is null";
        try {
            return task.get_Status();
        }
        catch (Exception e) {
            return 4;
        }
    }

    private static long computeDate(Float date) {
        calendar.set(1899, 11, 31);
        int days = date.intValue() - 1;
        calendar.add(5, days);
        return calendar.getTimeInMillis();
    }
}

