/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.projectplanningmodule2.msprojectadapter.exporter;

import com.arcway.cockpit.frame.client.global.gui.wizards.NoLicenseWizardPage;
import com.arcway.cockpit.frame.client.global.license.IClientFunctionLicenseType;
import com.arcway.cockpit.projectplanningmodule2.client.ProjectPlanningModule2Plugin;
import com.arcway.cockpit.projectplanningmodule2.client.adapterlib.SelectionWrapper;
import com.arcway.cockpit.projectplanningmodule2.client.adapterlib.gui.ExportSelectTasksPage;
import com.arcway.cockpit.projectplanningmodule2.client.adapterlib.gui.ExportWizard;
import com.arcway.cockpit.projectplanningmodule2.client.core.project.ModelController;
import com.arcway.cockpit.projectplanningmodule2.msprojectadapter.PPMMSProjectLicenseType;
import com.arcway.cockpit.projectplanningmodule2.msprojectadapter.exporter.MSProjectExportManager;
import com.arcway.cockpit.projectplanningmodule2.msprojectadapter.exporter.MSProjectExportSelectProjectPage;
import com.arcway.cockpit.projectplanningmodule2.msprojectadapter.exporter.Messages;
import java.util.Collection;
import java.util.List;
import org.eclipse.jface.wizard.IWizardPage;

public class MSProjectExportWizard
extends ExportWizard {
    public MSProjectExportWizard(String projectUID) {
        super(projectUID, (ModelController)ProjectPlanningModule2Plugin.getDefault().getProjectManager().getModelController(projectUID));
    }

    public void addPages() {
        if (this.getModelController().getProjectAgent().getServerLicenseManager().isLicenseOperationAllowed((IClientFunctionLicenseType)PPMMSProjectLicenseType.getInstance())) {
            String title = Messages.getString("MSProjectExportWizard.0");
            this.projectPage = new MSProjectExportSelectProjectPage(title, this, this.modelController);
            this.taskPage = new ExportSelectTasksPage(title, this.modelController);
            this.addPage((IWizardPage)this.projectPage);
            this.addPage((IWizardPage)this.taskPage);
        } else {
            NoLicenseWizardPage noLicenseWizardPage = new NoLicenseWizardPage(Messages.getString("MSProjectExportWizard.export2msproject"), (IClientFunctionLicenseType)PPMMSProjectLicenseType.getInstance());
            this.addPage((IWizardPage)noLicenseWizardPage);
        }
    }

    public boolean performFinish() {
        if (this.projectPage != null) {
            SelectionWrapper wrapper = this.projectPage.getWrapper();
            List selectedTasks = this.taskPage.getSelectedTasks();
            wrapper.setTasksToExport((Collection)selectedTasks);
            this.export(wrapper);
        }
        return true;
    }

    protected void export(SelectionWrapper wrapper) {
        MSProjectExportManager exportManager = new MSProjectExportManager();
        exportManager.export(this.getShell(), wrapper, this.taskPage.getProgressListener(), this.modelController);
    }

    protected void selectionChanged() {
        if (this.projectPage != null && this.taskPage != null) {
            this.taskPage.setInput(this.projectPage.getSelectedProjectPlan());
        }
    }
}

