/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.projectplanningmodule2.msprojectadapter.exporter;

import au.com.swz.swttocom.swt.ResourceManager;
import com.arcway.cockpit.projectplanningmodule2.client.adapterlib.SelectionWrapper;
import com.arcway.cockpit.projectplanningmodule2.client.adapterlib.gui.IProgressListener;
import com.arcway.cockpit.projectplanningmodule2.client.core.project.ModelController;
import com.arcway.cockpit.projectplanningmodule2.client.core.project.RessourceWorkCumulator;
import com.arcway.cockpit.projectplanningmodule2.client.messages.Task;
import com.arcway.cockpit.projectplanningmodule2.msprojectadapter.exporter.Messages;
import com.arcway.lib.eclipse.ole.project.Application;
import com.arcway.lib.eclipse.ole.project.Assignment;
import com.arcway.lib.eclipse.ole.project.Assignments;
import com.arcway.lib.eclipse.ole.project.Project;
import com.arcway.lib.eclipse.ole.project.Resource;
import com.arcway.lib.eclipse.ole.project.Resources;
import com.arcway.lib.eclipse.ole.project.Tasks;
import com.arcway.lib.eclipse.ole.project._MSProject;
import com.arcway.lib.eclipse.ole.project.util.TypeLibPatches;
import de.plans.lib.util.valueranges.ValueRangeHelperDuration;
import de.plans.psc.client.dialogs.swt.ExceptionDialog;
import java.io.File;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Shell;

public class MSProjectExportManager {
    private _MSProject app;
    private Project activeProj;
    private IProgressListener progressListener = null;
    DateFormat dateFormater = null;

    public void export(Shell shell, SelectionWrapper exportWrapper, IProgressListener p_progressListener, ModelController modelController) {
        assert (shell != null) : "shell is null";
        assert (exportWrapper != null) : "exportWrapper list is null";
        assert (p_progressListener != null) : Messages.getString("MSProjectExportManager.0");
        assert (modelController != null) : "modelController must not be null";
        this.progressListener = p_progressListener;
        int parts = 2;
        p_progressListener.setProgressParts(parts);
        ResourceManager resourceManager = new ResourceManager();
        try {
            try {
                p_progressListener.setCurrentPartProgress(10);
                boolean appStarted = false;
                try {
                    this.app = Application.create((int)6, (ResourceManager)resourceManager, (boolean)true);
                    p_progressListener.setCurrentPartProgress(100);
                    appStarted = true;
                }
                catch (Exception e) {
                    p_progressListener.errorOccurred();
                    MessageDialog mDialog = new MessageDialog(shell, Messages.getString("MSProjectExportManager.Export_failed_!_3"), null, Messages.getString("MSProjectExportManager.MS_Project_is_not_installed_on_this_computer._4"), 2, new String[]{IDialogConstants.OK_LABEL}, 0);
                    mDialog.open();
                }
                if (appStarted) {
                    int dateOrder = this.app.get_Var_DateOrder();
                    switch (dateOrder) {
                        case 0: {
                            this.dateFormater = new SimpleDateFormat("dd.MM.yy");
                            break;
                        }
                        case 1: {
                            this.dateFormater = new SimpleDateFormat("MM/dd/yy");
                            break;
                        }
                        case 2: {
                            this.dateFormater = new SimpleDateFormat("yy/MM/dd");
                            break;
                        }
                        default: {
                            this.dateFormater = new SimpleDateFormat("MM/dd/yy");
                        }
                    }
                    this.app.set_Var_Visible(true);
                    this.exportTasksToMSProjectFile(shell, exportWrapper, modelController);
                }
            }
            catch (Exception e) {
                p_progressListener.errorOccurred();
                ExceptionDialog dialog = new ExceptionDialog(shell, (Throwable)e);
                dialog.create();
                dialog.setTitle(Messages.getString("MSProjectExportManager.Export_failed_!_5"));
                dialog.setMessage(Messages.getString("MSProjectExportManager.Sorry,_an_unexpected_exception_occured._6"));
                dialog.open();
                if (this.app != null) {
                    if (!p_progressListener.hasErrorOccured()) {
                        p_progressListener.setCurrentPartProgress(50);
                    }
                    this.app = null;
                }
                resourceManager.shutdown();
                if (!p_progressListener.hasErrorOccured()) {
                    p_progressListener.setCurrentPartProgress(100);
                }
            }
        }
        finally {
            if (this.app != null) {
                if (!p_progressListener.hasErrorOccured()) {
                    p_progressListener.setCurrentPartProgress(50);
                }
                this.app = null;
            }
            resourceManager.shutdown();
            if (!p_progressListener.hasErrorOccured()) {
                p_progressListener.setCurrentPartProgress(100);
            }
        }
    }

    private boolean exportTasksToMSProjectFile(Shell shell, SelectionWrapper wrapper, ModelController modelController) {
        assert (shell != null) : "shell is null";
        assert (wrapper != null) : "export wrapper object is null";
        assert (modelController != null) : "modelController is null";
        File file = new File(wrapper.getFileName());
        if (!file.exists()) {
            this.app.FileNew();
            TypeLibPatches.MSProject_FileSaveAs((_MSProject)this.app, (String)file.getAbsolutePath());
        } else {
            TypeLibPatches.MSProject_FileOpen((_MSProject)this.app, (String)file.getAbsolutePath());
        }
        this.activeProj = this.app.get_Var_ActiveProject();
        Tasks tasks = this.activeProj.get_Tasks();
        Collection exportTasks = wrapper.getTasksToExport();
        int progressStep = 0;
        int progress = 100;
        if (exportTasks.size() > 0) {
            progressStep = (int)Math.ceil(60.0 / (double)exportTasks.size());
            progress = 20;
        }
        Iterator it = exportTasks.iterator();
        while (it.hasNext()) {
            if (progress < 100) {
                if ((progress += progressStep) > 100) {
                    progress = 100;
                }
                this.progressListener.setCurrentPartProgress(progress);
            }
            Task modifiedTask = (Task)it.next();
            RessourceWorkCumulator workComulator = modelController.getRessourceWorkCumulator(modifiedTask);
            com.arcway.lib.eclipse.ole.project.Task task = null;
            task = this.createTaskInMSProject(tasks, modifiedTask);
            if (task == null || modifiedTask.isMilestone().getValue()) continue;
            this.exportWorkAndResources(workComulator, task);
        }
        if (progress < 100) {
            this.progressListener.setCurrentPartProgress(100);
        }
        return true;
    }

    private void exportWorkAndResources(RessourceWorkCumulator workComulator, com.arcway.lib.eclipse.ole.project.Task task) {
        Assignments assignments = task.get_Assignments();
        boolean repeatExportOfWork = true;
        while (repeatExportOfWork) {
            repeatExportOfWork = false;
            HashMap<String, Assignment> assignementMap = new HashMap<String, Assignment>();
            int i = assignments.get_Count();
            while (i > 0) {
                Assignment assignment = assignments.get_Item((Object)new Integer(i));
                String resourceName = assignment.get_ResourceName();
                if (workComulator.containsRessource(resourceName)) {
                    ValueRangeHelperDuration vrh = (ValueRangeHelperDuration)workComulator.getWorkDone(resourceName).getValueRangeHelper();
                    assignment.set_ActualWork((Object)new Short((short)vrh.getDurationInSpecificUnit(2)));
                    vrh = (ValueRangeHelperDuration)workComulator.getWorkForecast(resourceName).getValueRangeHelper();
                    assignment.set_Work((Object)new Short((short)vrh.getDurationInSpecificUnit(2)));
                    assignementMap.put(resourceName, assignment);
                } else {
                    assignment.Delete();
                }
                --i;
            }
            for (String resourceName : workComulator.getResourceNames()) {
                if (assignementMap.containsKey(resourceName)) continue;
                Resource resource = this.findOrCreateResource(resourceName, this.activeProj);
                Assignment assignment = assignments.Add((Object)task.get_ID(), (Object)resource.get_ID());
                repeatExportOfWork = true;
                ValueRangeHelperDuration vrh = (ValueRangeHelperDuration)workComulator.getWorkDone(resourceName).getValueRangeHelper();
                assignment.set_ActualWork((Object)new Short((short)vrh.getDurationInSpecificUnit(2)));
                vrh = (ValueRangeHelperDuration)workComulator.getWorkForecast(resourceName).getValueRangeHelper();
                assignment.set_Work((Object)new Short((short)vrh.getDurationInSpecificUnit(2)));
            }
        }
    }

    private com.arcway.lib.eclipse.ole.project.Task createTaskInMSProject(Tasks msProjectTasksObject, Task cockpitTask) {
        com.arcway.lib.eclipse.ole.project.Task task = msProjectTasksObject.Add();
        if (cockpitTask.getStart() != null && cockpitTask.getStart().getValue() != null) {
            task.set_Start((Object)this.dateFormater.format(new Date(cockpitTask.getStart().getValue())));
        }
        if (cockpitTask.getFinish() != null && cockpitTask.getFinish().getValue() != null) {
            task.set_Finish((Object)this.dateFormater.format(new Date(cockpitTask.getFinish().getValue())));
        }
        if (cockpitTask.isMilestone().getValue()) {
            task.set_Milestone((Object)Boolean.TRUE);
        }
        ValueRangeHelperDuration vrh = (ValueRangeHelperDuration)cockpitTask.getOriginalWork().getValueRangeHelper();
        task.set_Work((Object)new Short((short)vrh.getDurationInSpecificUnit(2)));
        task.set_Name(cockpitTask.getName().getValue());
        return task;
    }

    private Resource findOrCreateResource(String name, Project project) {
        Resources resources = project.get_Resources();
        int resourceCount = resources.get_Count();
        int i = 1;
        while (i < resourceCount) {
            Resource resource = resources.get_Item((Object)new Integer(i));
            if (resource.get_Name().equals(name)) {
                return resource;
            }
            ++i;
        }
        Resource resource = resources.Add((Object)name);
        return resource;
    }
}

