/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.docgen.writer.analyse.preferences;

import com.arcway.cockpit.docgen.writer.analyse.Messages;
import com.arcway.cockpit.docgen.writer.analyse.ModulePlugin;
import com.arcway.cockpit.frame.client.global.FramePlugin;
import java.util.ArrayList;
import org.eclipse.jface.preference.BooleanFieldEditor;
import org.eclipse.jface.preference.ComboFieldEditor;
import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.jface.preference.FieldEditorPreferencePage;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.RadioGroupFieldEditor;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;

public class AnalyzeReportsPreferencePage
extends FieldEditorPreferencePage
implements IWorkbenchPreferencePage {
    public static final String SELECTED_IMAGE_FORMAT = "AnalyzeReportsPreferencePage.SELECTEDIMAGEFORMAT";
    public static final String LABELING_SectionAutolableMaxDepth = "AnalyzeReportsPreferencePage.LABELING_SectionAutolableMaxDepth";
    public static final String LABELING_SectionAutolableMaxDepth_DEFAULT = "8";
    public static final String TOC_TocSectionDepth = "AnalyzeReportsPreferencePage.TOC_TocSectionDepth";
    public static final String TOC_TocSectionDepth_DEFAULT = "8";
    public static final String CHUNKING_ENABLED = "AnalyzeReportsPreferencePage.CHUNKING_ENABLED";
    public static final String CHUNKING_ENABLED_DEFAULT = Boolean.TRUE.toString();
    public static final String CHUNKING_SectionDepth = "AnalyzeReportsPreferencePage.CHUNKING_SectionDepth";
    public static final String CHUNKING_SectionDepth_DEFAULT = "8";
    public static final String CHUNKING_DoNotChunkFirstSections = "AnalyzeReportsPreferencePage.CHUNKING_DoNotChunkFirstSections";
    public static final String CHUNKING_DoNotChunkFirstSections_DEFAULT = Boolean.TRUE.toString();

    public AnalyzeReportsPreferencePage() {
        super(1);
        IPreferenceStore store = ModulePlugin.getDefault().getPreferenceStore();
        this.setPreferenceStore(store);
    }

    public void init(IWorkbench workbench) {
    }

    public boolean performOk() {
        boolean ok = super.performOk();
        FramePlugin.getDefault().savePluginPreferences();
        return ok;
    }

    protected void createFieldEditors() {
        ArrayList<String[]> sectionDepthValueRange = new ArrayList<String[]>();
        StringBuilder chapterNum = new StringBuilder();
        int i = 0;
        while (i <= 8) {
            if (i > 1) {
                chapterNum.append(".");
            }
            chapterNum.append(1);
            if (i == 0) {
                chapterNum.append(".");
            }
            String stringValue = Integer.toString(i);
            sectionDepthValueRange.add(new String[]{chapterNum.toString(), stringValue});
            ++i;
        }
        Label label = new Label(this.getFieldEditorParent(), 0);
        GridData label2GridData = new GridData(4, 2, true, false);
        label2GridData.horizontalSpan = 2;
        label.setLayoutData((Object)label2GridData);
        this.addField((FieldEditor)new ComboFieldEditor(LABELING_SectionAutolableMaxDepth, Messages.getString("AnalyzeReportsPreferencePage.section_autolabel_max_depth"), (String[][])sectionDepthValueRange.toArray((T[])new String[0][]), this.getFieldEditorParent()));
        this.addField((FieldEditor)new ComboFieldEditor(TOC_TocSectionDepth, Messages.getString("AnalyzeReportsPreferencePage.toc_section_depth"), (String[][])sectionDepthValueRange.toArray((T[])new String[0][]), this.getFieldEditorParent()));
        label = new Label(this.getFieldEditorParent(), 0);
        label2GridData = new GridData(4, 2, true, false);
        label2GridData.horizontalSpan = 2;
        label.setLayoutData((Object)label2GridData);
        Group chunkingPrefGroup = new Group(this.getFieldEditorParent(), 0);
        chunkingPrefGroup.setText(Messages.getString("AnalyzeReportsPreferencePage.Chunking_Preferences"));
        GridData chunkingPrefGroupLayoutData = new GridData(4, 2, true, false);
        chunkingPrefGroupLayoutData.horizontalSpan = 2;
        chunkingPrefGroup.setLayoutData((Object)chunkingPrefGroupLayoutData);
        GridLayout chunkingPrefGroupLayout = new GridLayout();
        chunkingPrefGroupLayout.marginWidth = 10;
        chunkingPrefGroupLayout.marginHeight = 10;
        chunkingPrefGroup.setLayout((Layout)chunkingPrefGroupLayout);
        final Composite chunkingPrefComposite = new Composite((Composite)chunkingPrefGroup, 0);
        final ComboFieldEditor[] sectiondepthFieldEditor = new ComboFieldEditor[1];
        final BooleanFieldEditor[] do_not_chunk_first_sectionsFieldEditor = new BooleanFieldEditor[1];
        BooleanFieldEditor enableChunkingFieldEditor = new BooleanFieldEditor(CHUNKING_ENABLED, Messages.getString("AnalyzeReportsPreferencePage.Enable_Chunking"), chunkingPrefComposite){

            protected void doLoadDefault() {
                super.doLoadDefault();
                this.updateChunkingDetailsEnablement(this.getBooleanValue());
            }

            protected void doLoad() {
                super.doLoad();
                this.updateChunkingDetailsEnablement(this.getBooleanValue());
            }

            protected void valueChanged(boolean oldValue, boolean newValue) {
                super.valueChanged(oldValue, newValue);
                this.updateChunkingDetailsEnablement(newValue);
            }

            private void updateChunkingDetailsEnablement(boolean newValue) {
                if (sectiondepthFieldEditor[0] != null) {
                    if (newValue) {
                        sectiondepthFieldEditor[0].setEnabled(true, chunkingPrefComposite);
                        do_not_chunk_first_sectionsFieldEditor[0].setEnabled(true, chunkingPrefComposite);
                    } else {
                        sectiondepthFieldEditor[0].setEnabled(false, chunkingPrefComposite);
                        do_not_chunk_first_sectionsFieldEditor[0].setEnabled(false, chunkingPrefComposite);
                    }
                }
            }
        };
        this.addField((FieldEditor)enableChunkingFieldEditor);
        do_not_chunk_first_sectionsFieldEditor[0] = new BooleanFieldEditor(CHUNKING_DoNotChunkFirstSections, Messages.getString("AnalyzeReportsPreferencePage.do_not_chunk_first_sections"), chunkingPrefComposite);
        this.addField((FieldEditor)do_not_chunk_first_sectionsFieldEditor[0]);
        sectiondepthFieldEditor[0] = new ComboFieldEditor(CHUNKING_SectionDepth, Messages.getString("AnalyzeReportsPreferencePage.chunk_section_depth"), (String[][])sectionDepthValueRange.toArray((T[])new String[0][]), chunkingPrefComposite);
        this.addField((FieldEditor)sectiondepthFieldEditor[0]);
        Label label2 = new Label(this.getFieldEditorParent(), 0);
        GridData label2GridData2 = new GridData(4, 2, true, false);
        label2GridData2.horizontalSpan = 2;
        label2.setLayoutData((Object)label2GridData2);
        this.addField((FieldEditor)new RadioGroupFieldEditor(SELECTED_IMAGE_FORMAT, Messages.getString("AnalyzeReportsPreferencePage.PreferedImageFormat"), 2, (String[][])new String[][]{{Messages.getString("AnalyzeReportsPreferencePage.PNG"), ".png"}, {Messages.getString("AnalyzeReportsPreferencePage.SVG"), ".svg"}}, this.getFieldEditorParent(), true));
    }
}

