/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.docgen.writer.analyse;

import com.arcway.cockpit.docgen.writer.analyse.AnalyzeDocBook2HTMLConfigurator;
import com.arcway.cockpit.docgen.writer.analyse.gui.views.analyseview.AnalyseView;
import com.arcway.cockpit.docgen.writer.html.AbstractHTMLDocumentationWriter;
import com.arcway.cockpit.docgen.writer.html.preferences.IDocBook2HTMLConfigurator;
import com.arcway.cockpit.frame.client.project.docgenerator.ReportGenerationException;
import com.arcway.cockpit.frame.client.project.docgenerator.ReportJob;
import com.arcway.cockpit.frame.client.project.docgenerator.interFace.IReportParameters;
import com.arcway.cockpit.frame.client.project.docgenerator.interFace.IResultLauncher;
import com.arcway.cockpit.interFace.client.eclipse.interFace.ICOCKPITEclipseClientController;
import com.arcway.lib.eclipse.file.tmp.SessionTempDirectoryManager;
import com.arcway.lib.io.FileHelper;
import com.arcway.lib.logging.ILogger;
import com.arcway.lib.logging.Logger;
import com.arcway.lib.resource.JvmExternalResourceInteractionException;
import java.io.File;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;

public class AnalyseDocumentationWriter
extends AbstractHTMLDocumentationWriter {
    private static final ILogger logger = Logger.getLogger(AnalyseDocumentationWriter.class);
    private static final Set<File> TARGETS = new HashSet<File>();
    private static final IResultLauncher RESULT_LAUNCHER = new IResultLauncher(){

        public String getTinyizeContext(String resultFile) throws PartInitException {
            return resultFile;
        }

        public void showResult(IWorkbenchPage page, File resultMainFile, File resultFile, IReportParameters reportParameters) throws PartInitException {
            AnalyseDocumentationWriter.deleteAllIrrelevantTargets(resultFile);
            AnalyseView analyseView = (AnalyseView)page.showView("com.arcway.cockpit.docgen.writer.analyseview");
            analyseView.showReportResult(reportParameters, resultMainFile);
        }

        public void showErrorResult(IWorkbenchPage page, ReportGenerationException rgE, IReportParameters reportParameters) throws PartInitException {
            AnalyseDocumentationWriter.deleteAllIrrelevantTargets(null);
            AnalyseView analyseView = (AnalyseView)page.showView("com.arcway.cockpit.docgen.writer.analyseview");
            analyseView.showErrorResult(reportParameters, rgE);
        }
    };

    private static synchronized void deleteAllIrrelevantTargets(File newTarget) {
        Iterator<File> i = TARGETS.iterator();
        while (i.hasNext()) {
            File file = i.next();
            if (newTarget != null && file.getAbsolutePath().equals(newTarget.getAbsolutePath())) continue;
            try {
                ICOCKPITEclipseClientController.INSTANCE.freeTinyContext(file.getAbsolutePath());
                FileHelper.deleteFileOrDirectory((File)file);
            }
            catch (JvmExternalResourceInteractionException e) {
                logger.error("Cannot delete temp directory of analyze view", (Throwable)e);
            }
            i.remove();
        }
    }

    private static synchronized File createTempTarget() {
        try {
            SessionTempDirectoryManager.SessionTempDirectory file = SessionTempDirectoryManager.createSessionTempSubDirectory((String)"analyse-view-output");
            TARGETS.add((File)file);
            return file;
        }
        catch (JvmExternalResourceInteractionException e) {
            throw new RuntimeException("could not create temp directory for analyze view", e);
        }
    }

    public AnalyseDocumentationWriter() {
        super((IDocBook2HTMLConfigurator)new AnalyzeDocBook2HTMLConfigurator());
    }

    public boolean hasDeterminedOutputFile() {
        return true;
    }

    public File determineOutputFile(ReportJob reportJob) {
        return AnalyseDocumentationWriter.createTempTarget();
    }

    public IResultLauncher getResultLauncher() {
        return RESULT_LAUNCHER;
    }
}

