/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.usecasemodule.client.platformadapter;

import com.arcway.cockpit.interFace.ICockpitProjectData;
import com.arcway.cockpit.modulelib2.client.messages.IModuleData;
import com.arcway.cockpit.usecasemodule.client.core.project.DataManager;
import com.arcway.cockpit.usecasemodule.client.messages.ActionStep;
import com.arcway.cockpit.usecasemodule.client.messages.Scenario;
import com.arcway.repository.clientadapter.interFace.CockpitDataID;
import com.arcway.repository.clientadapter.interFace.EXCockpitLockDenied;
import com.arcway.repository.clientadapter.interFace.EXCockpitPermissionDenied;
import com.arcway.repository.clientadapter.interFace.ICockpitDataID;
import com.arcway.repository.clientadapter.interFace.ILock;
import com.arcway.repository.clientadapter.interFace.ISequenceManager;
import java.util.List;

public class ActionStepSequenceManager
implements ISequenceManager {
    private final DataManager dataManager;

    public ActionStepSequenceManager(DataManager dataManager) {
        this.dataManager = dataManager;
    }

    public ICockpitDataID getFirstObject(ICockpitDataID parent) {
        assert (parent.getCockpitDataTypeID().equals("ucm.Scenario"));
        Scenario parentScenario = (Scenario)((Object)this.dataManager.getItem(parent.getCockpitDataTypeID(), parent.getCockpitDataTypeID()));
        List<ActionStep> steps = this.dataManager.getActionSteps(parentScenario);
        ActionStep firstStep = steps.get(0);
        return new CockpitDataID((ICockpitProjectData)firstStep);
    }

    public ICockpitDataID getPredecessor(ICockpitDataID successor) {
        assert (successor.getCockpitDataTypeID().equals("ucm.ActionStep"));
        ActionStep successorStep = (ActionStep)((Object)this.dataManager.getItem(successor.getCockpitDataTypeID(), successor.getCockpitDataTypeID()));
        Scenario parentScenario = (Scenario)this.dataManager.getParent((IModuleData)successorStep);
        List<ActionStep> steps = this.dataManager.getActionSteps(parentScenario);
        int predecessorIndex = successorStep.getNumber().getValue() - 1;
        if (predecessorIndex >= 0) {
            ActionStep predecessorStep = steps.get(predecessorIndex);
            return new CockpitDataID((ICockpitProjectData)predecessorStep);
        }
        return null;
    }

    public ICockpitDataID getSuccessor(ICockpitDataID predecessor) {
        assert (predecessor.getCockpitDataTypeID().equals("ucm.ActionStep"));
        ActionStep predecessorStep = (ActionStep)((Object)this.dataManager.getItem(predecessor.getCockpitDataTypeID(), predecessor.getCockpitDataTypeID()));
        Scenario parentScenario = (Scenario)this.dataManager.getParent((IModuleData)predecessorStep);
        List<ActionStep> steps = this.dataManager.getActionSteps(parentScenario);
        int successorIndex = predecessorStep.getNumber().getValue() + 1;
        if (successorIndex < steps.size()) {
            ActionStep successorStep = steps.get(successorIndex);
            return new CockpitDataID((ICockpitProjectData)successorStep);
        }
        return null;
    }

    public ICockpitDataID getLastObject(ICockpitDataID parent) {
        assert (parent.getCockpitDataTypeID().equals("ucm.Scenario"));
        Scenario parentScenario = (Scenario)((Object)this.dataManager.getItem(parent.getCockpitDataTypeID(), parent.getCockpitDataTypeID()));
        List<ActionStep> steps = this.dataManager.getActionSteps(parentScenario);
        ActionStep lastStep = steps.get(steps.size() - 1);
        return new CockpitDataID((ICockpitProjectData)lastStep);
    }

    public void checkPermissionForSequenceModification(ICockpitDataID parent) throws EXCockpitPermissionDenied {
        throw new UnsupportedOperationException();
    }

    public ILock getLockForSequenceModification(ICockpitDataID parent) throws EXCockpitLockDenied, EXCockpitPermissionDenied {
        throw new UnsupportedOperationException();
    }

    public void insertAfter(ICockpitDataID predecessor, ICockpitDataID objectToInsert) throws EXCockpitLockDenied, EXCockpitPermissionDenied {
        throw new UnsupportedOperationException();
    }

    public void remove(ICockpitDataID objectToRemove) throws EXCockpitLockDenied, EXCockpitPermissionDenied {
        throw new UnsupportedOperationException();
    }
}

