/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.usecasemodule.client.messages;

import com.arcway.cockpit.modulelib2.client.messages.DataTypesHelper;
import com.arcway.cockpit.modulelib2.client.messages.IDataTypesHelper;
import com.arcway.cockpit.modulelib2.client.messages.IDataTypesHelper_Core;
import com.arcway.cockpit.modulelib2.client.messages.description.IModuleDataTypeDescription;
import com.arcway.cockpit.usecasemodule.client.messages.description.ActionStepDescription;
import com.arcway.cockpit.usecasemodule.client.messages.description.ActorDescription;
import com.arcway.cockpit.usecasemodule.client.messages.description.CategoryDescription;
import com.arcway.cockpit.usecasemodule.client.messages.description.ExtensionDescription;
import com.arcway.cockpit.usecasemodule.client.messages.description.GoalDescription;
import com.arcway.cockpit.usecasemodule.client.messages.description.ScenarioDescription;
import com.arcway.cockpit.usecasemodule.client.messages.description.UseCaseDescription;
import com.arcway.lib.java.collectionmaps.SetMap;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class UCMDataTypesHelper
implements IDataTypesHelper_Core {
    private static IDataTypesHelper singleton;
    private static final Collection<String> administrativeDataTypes;
    private static final Collection<String> documentationDataTypes;
    private static final Collection<String> virtualDataTypes;
    private static final SetMap<String, String> map_childTypeID_parentTypeIDs;
    private static final Map<String, IModuleDataTypeDescription> map_typeID_typeDescription;

    static {
        administrativeDataTypes = Arrays.asList("ucm.Actor");
        documentationDataTypes = Arrays.asList("ucm.category", "ucm.useCase", "ucm.Scenario", "ucm.ActionStep", "ucm.Goal", "ucm.Extension");
        virtualDataTypes = Collections.emptyList();
        map_childTypeID_parentTypeIDs = new SetMap();
        map_childTypeID_parentTypeIDs.add((Object)"ucm.category", (Object)"hierarchyroot");
        map_childTypeID_parentTypeIDs.add((Object)"ucm.useCase", (Object)"ucm.category");
        map_childTypeID_parentTypeIDs.add((Object)"ucm.Scenario", (Object)"ucm.useCase");
        map_childTypeID_parentTypeIDs.add((Object)"ucm.ActionStep", (Object)"ucm.Scenario");
        map_childTypeID_parentTypeIDs.add((Object)"ucm.Scenario", (Object)"ucm.ActionStep");
        map_childTypeID_parentTypeIDs.add((Object)"ucm.Extension", (Object)"ucm.ActionStep");
        map_childTypeID_parentTypeIDs.add((Object)"ucm.Goal", (Object)"ucm.useCase");
        map_typeID_typeDescription = new HashMap<String, IModuleDataTypeDescription>();
        map_typeID_typeDescription.put("ucm.category", (IModuleDataTypeDescription)new CategoryDescription());
        map_typeID_typeDescription.put("ucm.useCase", (IModuleDataTypeDescription)new UseCaseDescription());
        map_typeID_typeDescription.put("ucm.Scenario", (IModuleDataTypeDescription)new ScenarioDescription());
        map_typeID_typeDescription.put("ucm.ActionStep", (IModuleDataTypeDescription)new ActionStepDescription());
        map_typeID_typeDescription.put("ucm.Extension", (IModuleDataTypeDescription)new ExtensionDescription());
        map_typeID_typeDescription.put("ucm.Goal", (IModuleDataTypeDescription)new GoalDescription());
        map_typeID_typeDescription.put("ucm.Actor", (IModuleDataTypeDescription)new ActorDescription());
    }

    public static IDataTypesHelper getDefault() {
        if (singleton == null) {
            singleton = new DataTypesHelper((IDataTypesHelper_Core)new UCMDataTypesHelper());
        }
        return singleton;
    }

    private UCMDataTypesHelper() {
    }

    public Collection<String> getAdministrativeDataTypes() {
        return administrativeDataTypes;
    }

    public Collection<String> getDocumentationDataTypes() {
        return documentationDataTypes;
    }

    public Collection<String> getVirtualDataTypes() {
        return virtualDataTypes;
    }

    public Collection<String> getParentTypeIDs(String childTypeID) {
        return map_childTypeID_parentTypeIDs.get((Object)childTypeID);
    }

    public IModuleDataTypeDescription getTypeDescription(String typeID) {
        return map_typeID_typeDescription.get(typeID);
    }
}

