/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.usecasemodule.client.messages;

import com.arcway.cockpit.frame.shared.IPermissionOperand;
import com.arcway.cockpit.modulelib2.client.messages.IModuleData;
import com.arcway.cockpit.modulelib2.client.messages.attributes.ModuleDataAttributeBoolean;
import com.arcway.cockpit.modulelib2.client.messages.attributes.ModuleDataAttributeDiscrete;
import com.arcway.cockpit.modulelib2.client.messages.attributes.ModuleDataAttributeNonEmptyString;
import com.arcway.cockpit.modulelib2.client.messages.attributes.ModuleDataAttributeString;
import com.arcway.cockpit.modulelib2.client.messages.description.IModuleDataTypeDescription;
import com.arcway.cockpit.modulelib2.shared.messages.EOModuleData;
import com.arcway.cockpit.usecasemodule.client.messages.AbstractModuleDataAdapter;
import com.arcway.cockpit.usecasemodule.client.messages.description.CategoryDescription;

public class Category
extends AbstractModuleDataAdapter
implements IPermissionOperand {
    public static IModuleDataTypeDescription DATA_TYPE_DESCRIPTION = new CategoryDescription();

    public Category() {
        this.moduleAttributes.put("ucm.category.category", new ModuleDataAttributeNonEmptyString(1));
        this.moduleAttributes.put("useCase_defaultPrefix", new ModuleDataAttributeBoolean(true));
        this.moduleAttributes.put("useCase_prefix", new ModuleDataAttributeString(1));
        this.moduleAttributes.put("useCase_rolePattern", new ModuleDataAttributeDiscrete(CategoryDescription.ID_PATTERNS, 2));
    }

    public Category(EOModuleData eo) {
        this();
        assert (eo != null) : "eo must not be null";
        assert (this.getTypeID().equals(eo.getTypeID()));
        this.fillWithEncodableObject(eo);
    }

    public String getDisplayRepresentation() {
        return this.getName().getDisplayStringRepresentation();
    }

    public void setDisplayRepresentation(String displayRepresentation) {
    }

    public ModuleDataAttributeNonEmptyString getName() {
        return (ModuleDataAttributeNonEmptyString)this.moduleAttributes.get("ucm.category.category");
    }

    public String getTypeID() {
        return "ucm.category";
    }

    public boolean isIsomorphic(IModuleData item) {
        return item instanceof Category && this.getName().getValue().equals(((Category)item).getName().getValue());
    }

    public String getPermissionOperandType() {
        return "ucm.category";
    }

    public String getPermissionOperandUID() {
        return this.getUID();
    }

    public String getPermissionOperandDisplayName() {
        return this.getDisplayRepresentation();
    }

    public ModuleDataAttributeDiscrete getPattern() {
        return (ModuleDataAttributeDiscrete)this.moduleAttributes.get("useCase_rolePattern");
    }

    public void setPrefixDefault(boolean defaultPrefix) {
        ((ModuleDataAttributeBoolean)this.moduleAttributes.get("useCase_defaultPrefix")).setValue(defaultPrefix);
    }

    public boolean isDefaultPrefix() {
        return ((ModuleDataAttributeBoolean)this.moduleAttributes.get("useCase_defaultPrefix")).getValue();
    }

    public ModuleDataAttributeString getPrefix() {
        return (ModuleDataAttributeString)this.moduleAttributes.get("useCase_prefix");
    }

    public String getEffectivePrefix() {
        if (this.isDefaultPrefix()) {
            return CategoryDescription.getGenericPrefix(this.getName().getDisplayStringRepresentation());
        }
        return ((ModuleDataAttributeString)this.moduleAttributes.get("useCase_prefix")).getValue();
    }

    protected final IModuleDataTypeDescription getTypeDescription_internal() {
        return DATA_TYPE_DESCRIPTION;
    }
}

