/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.usecasemodule.client.messages;

import com.arcway.cockpit.modulelib2.client.messages.attributes.ModuleDataAttributeDiscrete;
import com.arcway.cockpit.modulelib2.client.messages.attributes.ModuleDataAttributeInteger;
import com.arcway.cockpit.modulelib2.client.messages.attributes.ModuleDataAttributeNonEmptyString;
import com.arcway.cockpit.modulelib2.client.messages.attributes.ModuleDataAttributeString;
import com.arcway.cockpit.modulelib2.client.messages.description.IModuleDataTypeDescription;
import com.arcway.cockpit.modulelib2.shared.messages.EOModuleData;
import com.arcway.cockpit.usecasemodule.client.Messages;
import com.arcway.cockpit.usecasemodule.client.messages.AbstractModuleDataAdapter;
import com.arcway.cockpit.usecasemodule.client.messages.description.ActionStepDescription;
import java.util.Locale;

public class ActionStep
extends AbstractModuleDataAdapter {
    public static IModuleDataTypeDescription DATA_TYPE_DESCRIPTION = new ActionStepDescription();
    private final ModuleDataAttributeInteger number;

    public ActionStep() {
        this.moduleAttributes.put("ucm.Step.Description", new ModuleDataAttributeString(2));
        this.moduleAttributes.put("ucm.Step.Title", new ModuleDataAttributeNonEmptyString(1));
        this.moduleAttributes.put("ucm.Step.Type", new ModuleDataAttributeDiscrete(ActionStepDescription.getTypeKeys(), 2));
        this.number = new ModuleDataAttributeInteger();
    }

    public ActionStep(EOModuleData eo) {
        this();
        assert (eo != null) : "eo must not be null";
        assert (this.getTypeID().equals(eo.getTypeID()));
        this.fillWithEncodableObject(eo);
        if (!(this.getStepType().getValue() != 0 && this.getStepType().getValue() != 1 || this.getTitle().getValue() != null && !this.getTitle().getValue().equals(""))) {
            this.getTitle().setValue("[Virtual Action Step]");
        }
    }

    public String getDisplayRepresentation() {
        return this.getDisplayRepresentation(Locale.getDefault());
    }

    public String getDisplayRepresentation(Locale locale) {
        switch (this.getStepType().getValue()) {
            case 0: {
                return Messages.getString("ActionStep.Type.Beginning", locale);
            }
            case 2: {
                return String.valueOf(this.getNumber().getDisplayStringRepresentation()) + ": " + this.getTitle().getDisplayStringRepresentation();
            }
            case 1: {
                return Messages.getString("ActionStep.Type.End", locale);
            }
        }
        return null;
    }

    public ModuleDataAttributeString getDescription() {
        return (ModuleDataAttributeString)this.moduleAttributes.get("ucm.Step.Description");
    }

    public ModuleDataAttributeNonEmptyString getTitle() {
        return (ModuleDataAttributeNonEmptyString)this.moduleAttributes.get("ucm.Step.Title");
    }

    public ModuleDataAttributeInteger getNumber() {
        return this.number;
    }

    public ModuleDataAttributeDiscrete getStepType() {
        return (ModuleDataAttributeDiscrete)this.getAttribute("ucm.Step.Type");
    }

    public void setDisplayRepresentation(String displayRepresentation) {
    }

    public String getTypeID() {
        return "ucm.ActionStep";
    }

    protected final IModuleDataTypeDescription getTypeDescription_internal() {
        return DATA_TYPE_DESCRIPTION;
    }
}

