/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.usecasemodule.client.gui.usecaserelationview.gefpatch.patched;

import com.arcway.cockpit.frame.client.lib.relationviews.gefpatch.copied.DirectedGraph;
import com.arcway.cockpit.frame.client.lib.relationviews.gefpatch.copied.Edge;
import com.arcway.cockpit.frame.client.lib.relationviews.gefpatch.copied.Node;
import com.arcway.cockpit.frame.client.lib.relationviews.gefpatch.copied.NodeList;
import com.arcway.cockpit.frame.client.lib.relationviews.gefpatch.copied.RevertableChange;
import com.arcway.cockpit.frame.client.lib.relationviews.gefpatch.copied.Subgraph;
import com.arcway.cockpit.usecasemodule.client.gui.usecaserelationview.gefpatch.derived.UseCaseGraphEdge;
import com.arcway.cockpit.usecasemodule.client.gui.usecaserelationview.gefpatch.derived.UseCaseGraphNode;
import org.eclipse.draw2d.geometry.Insets;

class UseCaseVirtualNodeCreation
extends RevertableChange {
    private final Edge edge;
    private final DirectedGraph graph;
    private final Node[] nodes;
    private final Edge[] edges;
    private static final int INNER_EDGE_X = 2;
    private static final int LONG_EDGE_X = 8;

    public UseCaseVirtualNodeCreation(Edge edge, DirectedGraph graph) {
        UseCaseGraphEdge currentEdge;
        this.edge = edge;
        this.graph = graph;
        int size = edge.target.rank - edge.source.rank - 1;
        int offset = edge.source.rank + 1;
        Object prevNode = edge.source;
        this.nodes = new Node[size];
        this.edges = new Edge[size + 1];
        Insets padding = new Insets(0, edge.padding, 0, edge.padding);
        Subgraph s = null;
        Node left = edge.source;
        Node right = edge.target;
        Subgraph parent = right instanceof Subgraph ? (Subgraph)right : right.getParent();
        while (parent != null) {
            if (parent.isNested(left)) {
                s = parent;
                break;
            }
            parent = parent.getParent();
        }
        int i = 0;
        while (i < size) {
            int nodeType = ((UseCaseGraphEdge)edge).getEdgeType() == 2 ? 7 : (((UseCaseGraphEdge)edge).getEdgeType() == 3 ? 10 : -1);
            UseCaseGraphNode currentNode = new UseCaseGraphNode("Virtual" + i + ':' + edge, nodeType);
            this.nodes[i] = currentNode;
            ((Node)currentNode).width = edge.width;
            if (s != null) {
                ((Node)currentNode).nestingIndex = s.nestingIndex;
            }
            ((Node)currentNode).height = 0;
            currentNode.setPadding(padding);
            ((Node)currentNode).rank = offset + i;
            graph.ranks.getRank(offset + i).add((Object)currentNode);
            currentEdge = new UseCaseGraphEdge((Node)prevNode, (Node)currentNode, 1, edge.weight * 8);
            currentEdge.setEdgeType(((UseCaseGraphEdge)edge).getEdgeType());
            if (i == 0) {
                ((Edge)currentEdge).weight = edge.weight * 2;
                ((Edge)currentEdge).offsetSource = edge.offsetSource;
            }
            this.edges[i] = currentEdge;
            graph.edges.add((Object)this.edges[i]);
            graph.nodes.add((Object)currentNode);
            prevNode = currentNode;
            ++i;
        }
        currentEdge = new UseCaseGraphEdge((Node)prevNode, edge.target, 1, edge.weight * 2);
        currentEdge.setEdgeType(((UseCaseGraphEdge)edge).getEdgeType());
        ((Edge)currentEdge).offsetTarget = edge.offsetTarget;
        UseCaseGraphEdge useCaseGraphEdge = currentEdge;
        this.edges[this.edges.length - 1] = useCaseGraphEdge;
        graph.edges.add((Object)useCaseGraphEdge);
        graph.removeEdge(edge);
    }

    public void revert() {
        this.edge.start = this.edges[0].start;
        this.edge.end = this.edges[this.edges.length - 1].end;
        this.edge.vNodes = new NodeList();
        Edge[] edgeArray = this.edges;
        int n = this.edges.length;
        int n2 = 0;
        while (n2 < n) {
            Edge edge2 = edgeArray[n2];
            this.graph.removeEdge(edge2);
            ++n2;
        }
        edgeArray = this.nodes;
        n = this.nodes.length;
        n2 = 0;
        while (n2 < n) {
            Edge node = edgeArray[n2];
            this.edge.vNodes.add((Object)node);
            this.graph.removeNode((Node)node);
            ++n2;
        }
        this.edge.source.outgoing.add((Object)this.edge);
        this.edge.target.incoming.add((Object)this.edge);
        this.graph.edges.add((Object)this.edge);
    }
}

