/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.usecasemodule.client.gui.usecaserelationview;

import com.arcway.cockpit.client.base.interfaces.frame.propertychanges.IPropertyChanges;
import com.arcway.cockpit.frame.client.lib.relationviews.Draw2DTextExtendCalculator;
import com.arcway.cockpit.frame.client.lib.relationviews.GraphNodeLayoutProvider;
import com.arcway.cockpit.frame.client.lib.relationviews.IGraphNodeLayoutProvider;
import com.arcway.cockpit.frame.client.lib.relationviews.IRelationGraphProvider;
import com.arcway.cockpit.frame.client.lib.relationviews.IRelationViewGraphBuilder;
import com.arcway.cockpit.frame.client.lib.relationviews.ITextExtendCalculator;
import com.arcway.cockpit.frame.client.lib.relationviews.LabelCreator;
import com.arcway.cockpit.frame.client.project.core.categories.ObjectTypeCategory;
import com.arcway.cockpit.frame.shared.message.EOLink;
import com.arcway.cockpit.modulelib2.client.core.ProjectMgr;
import com.arcway.cockpit.modulelib2.client.gui.relationviews.AbstractModuleDataRelationView;
import com.arcway.cockpit.modulelib2.client.messages.IModuleData;
import com.arcway.cockpit.usecasemodule.client.IHelpContextIDs;
import com.arcway.cockpit.usecasemodule.client.Messages;
import com.arcway.cockpit.usecasemodule.client.UseCaseModulePlugin;
import com.arcway.cockpit.usecasemodule.client.core.project.ModelController;
import com.arcway.cockpit.usecasemodule.client.gui.usecaserelationview.UseCaseRelationGraphBuilder;
import com.arcway.cockpit.usecasemodule.client.gui.usecaserelationview.UseCaseRelationGraphLayoutProvider;
import com.arcway.cockpit.usecasemodule.client.messages.ActionStep;
import com.arcway.cockpit.usecasemodule.client.messages.Scenario;
import com.arcway.cockpit.usecasemodule.client.messages.UseCase;
import java.util.Arrays;
import java.util.Collection;

public class UseCaseRelationView
extends AbstractModuleDataRelationView {
    private UseCaseRelationGraphBuilder graphBuilder;

    public void handleModelRefresh(IPropertyChanges changes, Class clazz, String projectUID) {
        block11: {
            block12: {
                block10: {
                    assert (UseCase.class.isAssignableFrom(clazz) || EOLink.class.isAssignableFrom(clazz) || ActionStep.class.isAssignableFrom(clazz) || Scenario.class.isAssignableFrom(clazz) || ObjectTypeCategory.class.isAssignableFrom(clazz));
                    if (!UseCase.class.isAssignableFrom(clazz)) break block10;
                    if (changes.getDeletedElements() != null) {
                        for (UseCase useCase : changes.getDeletedElements()) {
                            if (useCase != this.getCurrentItem()) continue;
                            this.clearCurrentItem();
                            return;
                        }
                    }
                    if (changes.getModifiedElements() == null) break block11;
                    for (UseCase useCase : changes.getModifiedElements()) {
                        if (useCase != this.getCurrentItem()) continue;
                        this.refreshCurrentItem();
                        return;
                    }
                    break block11;
                }
                if (ActionStep.class.isAssignableFrom(clazz) || Scenario.class.isAssignableFrom(clazz)) {
                    this.refreshCurrentItem();
                    return;
                }
                if (!EOLink.class.isAssignableFrom(clazz)) break block12;
                if (changes.getDeletedElements() != null) {
                    for (EOLink link : changes.getDeletedElements()) {
                        if (!link.getLinkTypeID().equals("MainScenarioUseCase") && !link.getLinkTypeID().equals("ScenarioBeginningStep") && !link.getLinkTypeID().equals("ScenarioFinalStep") && !link.getLinkTypeID().equals("StepPreviousStep") && !link.getLinkTypeID().equals("StepScenario") && !link.getLinkTypeID().equals("UseCaseExtension") && !link.getLinkTypeID().equals("ExtensionBeginningStep") && !link.getLinkTypeID().equals("ExtensionFinalStep")) continue;
                        this.refreshCurrentItem();
                        return;
                    }
                }
                if (changes.getCreatedElements() == null) break block11;
                for (EOLink link : changes.getCreatedElements()) {
                    if (!link.getLinkTypeID().equals("MainScenarioUseCase") && !link.getLinkTypeID().equals("ScenarioBeginningStep") && !link.getLinkTypeID().equals("ScenarioFinalStep") && !link.getLinkTypeID().equals("StepPreviousStep") && !link.getLinkTypeID().equals("StepScenario") && !link.getLinkTypeID().equals("UseCaseExtension") && !link.getLinkTypeID().equals("ExtensionBeginningStep") && !link.getLinkTypeID().equals("ExtensionFinalStep")) continue;
                    this.refreshCurrentItem();
                    return;
                }
                break block11;
            }
            if (ObjectTypeCategory.class.isAssignableFrom(clazz)) {
                for (Object modifiedObject : changes.getModifiedElements()) {
                    ObjectTypeCategory modifiedCategory = (ObjectTypeCategory)modifiedObject;
                    if (!modifiedCategory.getCockpitDataTypeID().equals("ucm.useCase") && !modifiedCategory.getCockpitDataTypeID().equals("ucm.Scenario")) continue;
                    this.refreshCurrentItem();
                }
            }
        }
    }

    protected void handleProjectSwitch_Before(String newProjectUID) {
    }

    protected void handleProjectSwitch_After(String newProjectUID) {
    }

    protected Collection<Class<?>> getDataTypesWhichCauseRefresh() {
        return Arrays.asList(UseCase.class, EOLink.class, ActionStep.class, Scenario.class, ObjectTypeCategory.class);
    }

    protected IModuleData translateItem(IModuleData data) {
        if (data == null) {
            return null;
        }
        if (data instanceof UseCase) {
            return data;
        }
        if (data instanceof Scenario) {
            ModelController modelController = (ModelController)UseCaseModulePlugin.getDefault().getProjectManager().getModelController(data.getProjectUID());
            UseCase useCase = modelController.getUseCase((Scenario)data);
            return useCase;
        }
        if (data instanceof ActionStep) {
            ModelController modelController = (ModelController)UseCaseModulePlugin.getDefault().getProjectManager().getModelController(data.getProjectUID());
            Scenario scenario = (Scenario)modelController.getParent(data);
            if (scenario == null) {
                return null;
            }
            UseCase useCase = modelController.getUseCase(scenario);
            return useCase;
        }
        return null;
    }

    protected String getEmptyViewMessage() {
        return Messages.getString("UseCaseRelationView.ErrorMsg.NoUseCaseSelected");
    }

    public void handleDispose() {
    }

    protected ProjectMgr getProjectManager() {
        return UseCaseModulePlugin.getDefault().getProjectManager();
    }

    protected IRelationViewGraphBuilder getGraphBuilder(LabelCreator labelCreator) {
        if (this.graphBuilder == null) {
            this.graphBuilder = new UseCaseRelationGraphBuilder(labelCreator);
        }
        return this.graphBuilder;
    }

    protected String getHelpContextID() {
        return IHelpContextIDs.USE_CASE_RELATIONS_VIEW_INDEX;
    }

    protected IGraphNodeLayoutProvider createFigureLayoutProvider() {
        Draw2DTextExtendCalculator textExtendCalculator = new Draw2DTextExtendCalculator();
        UseCaseRelationGraphLayoutProvider relationGraphProvider = new UseCaseRelationGraphLayoutProvider();
        return new GraphNodeLayoutProvider((ITextExtendCalculator)textExtendCalculator, (IRelationGraphProvider)relationGraphProvider);
    }
}

