/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.usecasemodule.client.gui.usecaserelationview;

import com.arcway.cockpit.frame.client.lib.relationviews.IRelationGraphProvider;
import com.arcway.cockpit.interFace.ICockpitProjectData;
import com.arcway.cockpit.usecasemodule.client.Messages;
import com.arcway.cockpit.usecasemodule.client.UseCaseModulePlugin;
import com.arcway.cockpit.usecasemodule.client.core.project.ModelController;
import com.arcway.cockpit.usecasemodule.client.messages.ActionStep;
import com.arcway.cockpit.usecasemodule.client.messages.Scenario;
import com.arcway.cockpit.usecasemodule.client.messages.UseCase;
import com.arcway.lib.graphics.Color;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.graphics.Image;

public class UseCaseRelationGraphLayoutProvider
implements IRelationGraphProvider {
    public Color getBackgroundColor(ICockpitProjectData data, int nodeType) {
        Color backgroundColor = Color.WHITE;
        if (nodeType == 1 || nodeType == 8) {
            backgroundColor = Color.LIGHTBLUE;
        } else if (nodeType == 2 || nodeType == 4 || nodeType == 5) {
            backgroundColor = Color.LIGHTGRAY;
        } else if (nodeType == 3) {
            backgroundColor = Color.LIGHTYELLOW;
        } else if (nodeType == 9) {
            backgroundColor = Color.WHITE;
        }
        return backgroundColor;
    }

    public Color getForegroundColor(ICockpitProjectData data, int nodeType) {
        return Color.DARKBLUE;
    }

    public Image getIcon(ICockpitProjectData data, int nodeType) {
        ImageDescriptor imageDescriptor = null;
        if (nodeType == 1 || nodeType == 8) {
            imageDescriptor = UseCaseModulePlugin.getImageDescriptor("UseCase.gif");
        } else if (nodeType == 2) {
            imageDescriptor = UseCaseModulePlugin.getImageDescriptor("Scenario.gif");
        } else if (nodeType == 3) {
            imageDescriptor = UseCaseModulePlugin.getImageDescriptor("ActionStep.gif");
        }
        Image image = null;
        if (imageDescriptor != null) {
            image = UseCaseModulePlugin.getDefault().getImageDescriptorRegistry().get(imageDescriptor);
        }
        return image;
    }

    public String getLabel(ICockpitProjectData data, int nodeType) {
        String text = "";
        switch (nodeType) {
            case 1: 
            case 8: {
                text = ((UseCase)data).getID().getDisplayStringRepresentation();
                break;
            }
            case 2: {
                ModelController modelController = (ModelController)UseCaseModulePlugin.getDefault().getProjectManager().getModelController(((Scenario)data).getProjectUID());
                text = modelController.getFullScenarioPrefix((Scenario)data);
                break;
            }
            case 3: {
                ModelController modelController = (ModelController)UseCaseModulePlugin.getDefault().getProjectManager().getModelController(((ActionStep)data).getProjectUID());
                text = modelController.getDisplayRepresentation_ActionStepWithActor((ActionStep)data);
                break;
            }
            case 4: {
                text = Messages.getString("UseCaseRelationView.EndNodeLabel");
                break;
            }
            case 5: {
                text = Messages.getString("UseCaseRelationView.EndWithSuccessNodeLabel");
                break;
            }
            case 9: {
                text = "...";
            }
        }
        return text;
    }

    public boolean hasSourceArrow(int edgeType, boolean virtualSource) {
        return false;
    }

    public boolean hasTargetArrow(int edgeType, boolean virtualTarget) {
        return this.showEdge(edgeType) && !virtualTarget;
    }

    public boolean showEdge(int edgeType) {
        return edgeType != 2 && edgeType != 3;
    }

    public Color getLineColor() {
        return Color.BLACK;
    }

    public Color getToolTipColor() {
        return Color.TOOLTIPYELLOW;
    }

    public boolean hasIcon(ICockpitProjectData data, int nodeType) {
        return this.getIcon(data, nodeType) != null;
    }

    public void dispose() {
    }
}

