/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.usecasemodule.client.gui.usecaserelationview;

import com.arcway.cockpit.frame.client.lib.relationviews.IRelationViewGraphBuilder;
import com.arcway.cockpit.frame.client.lib.relationviews.LabelCreator;
import com.arcway.cockpit.frame.client.lib.relationviews.NodeAttributes;
import com.arcway.cockpit.frame.client.lib.relationviews.gefpatch.copied.DirectedGraph;
import com.arcway.cockpit.frame.client.lib.relationviews.gefpatch.copied.InitialRankSolver;
import com.arcway.cockpit.frame.client.lib.relationviews.gefpatch.copied.MinCross;
import com.arcway.cockpit.frame.client.lib.relationviews.gefpatch.copied.Node;
import com.arcway.cockpit.frame.client.lib.relationviews.gefpatch.copied.RankAssignmentSolver;
import com.arcway.cockpit.frame.client.lib.relationviews.gefpatch.copied.TightSpanningTreeSolver;
import com.arcway.cockpit.frame.client.lib.relationviews.gefpatch.copied.VerticalPlacement;
import com.arcway.cockpit.interFace.ICockpitProjectData;
import com.arcway.cockpit.modulelib2.client.messages.IModuleData;
import com.arcway.cockpit.usecasemodule.client.UseCaseModulePlugin;
import com.arcway.cockpit.usecasemodule.client.core.project.ModelController;
import com.arcway.cockpit.usecasemodule.client.gui.usecaserelationview.UseCaseGraphHorizontalPlacement;
import com.arcway.cockpit.usecasemodule.client.gui.usecaserelationview.gefpatch.derived.UseCaseGraphEdge;
import com.arcway.cockpit.usecasemodule.client.gui.usecaserelationview.gefpatch.derived.UseCaseGraphNode;
import com.arcway.cockpit.usecasemodule.client.gui.usecaserelationview.gefpatch.patched.UseCasePopulateRanks;
import com.arcway.cockpit.usecasemodule.client.messages.ActionStep;
import com.arcway.cockpit.usecasemodule.client.messages.Extension;
import com.arcway.cockpit.usecasemodule.client.messages.Scenario;
import com.arcway.cockpit.usecasemodule.client.messages.UseCase;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.draw2d.geometry.Insets;
import org.eclipse.swt.graphics.Font;

public class UseCaseRelationGraphBuilder
implements IRelationViewGraphBuilder {
    private final LabelCreator labelCreator;

    public UseCaseRelationGraphBuilder(LabelCreator labelCreator) {
        this.labelCreator = labelCreator;
    }

    public DirectedGraph createGraph(Font labelFont, ICockpitProjectData data) {
        if (!(data instanceof UseCase)) {
            return null;
        }
        UseCase useCase = (UseCase)data;
        DirectedGraph graph = this.createUseCaseRelationGraph(labelFont, useCase);
        new InitialRankSolver().visit(graph);
        new TightSpanningTreeSolver().visit(graph);
        new RankAssignmentSolver().visit(graph);
        new UseCasePopulateRanks().visit(graph);
        new VerticalPlacement().visit(graph);
        new MinCross().visit(graph);
        new UseCaseGraphHorizontalPlacement().visit(graph);
        return graph;
    }

    private DirectedGraph createUseCaseRelationGraph(Font labelFont, UseCase useCase) {
        ModelController modelController = (ModelController)UseCaseModulePlugin.getDefault().getProjectManager().getModelController(useCase.getProjectUID());
        DirectedGraph graph = new DirectedGraph();
        graph.setDefaultPadding(new Insets(20));
        this.addUseCase(null, useCase, null, -1, new HashMap(), graph, modelController, labelFont, new ArrayList());
        return graph;
    }

    private void addUseCase(Node sourceNode, UseCase useCase, Extension extension, int extensionDepth, Map parentEndNodeMap, DirectedGraph graph, ModelController modelController, Font labelFont, Collection ancestorUseCases) {
        if (ancestorUseCases.contains((Object)useCase)) {
            this.addCycleUseCase(sourceNode, useCase, extension, extensionDepth, parentEndNodeMap, graph, labelFont);
            return;
        }
        Node root = this.createNode(1, (Object)useCase, extensionDepth);
        graph.nodes.add((Object)root);
        if (sourceNode != null) {
            graph.edges.add((Object)new UseCaseGraphEdge(sourceNode, root, 1));
        }
        ancestorUseCases.add(useCase);
        Scenario mainScenario = modelController.getMainScenario(useCase);
        this.addScenario(root, mainScenario, extension, -1, parentEndNodeMap, graph, modelController, labelFont, ancestorUseCases);
    }

    private void addCycleUseCase(Node sourceNode, UseCase useCase, Extension extension, int extensionDepth, Map parentEndNodeMap, DirectedGraph graph, Font labelFont) {
        Node root = this.createNode(8, (Object)useCase, extensionDepth);
        Node dots = this.createNode(9, (Object)useCase, -1);
        graph.nodes.add((Object)root);
        graph.nodes.add((Object)dots);
        graph.edges.add((Object)new UseCaseGraphEdge(root, dots, 1));
        if (sourceNode != null) {
            graph.edges.add((Object)new UseCaseGraphEdge(sourceNode, root, 1));
        }
        parentEndNodeMap.put(extension, dots);
    }

    private void addScenario(Node sourceNode, Scenario scenario, Extension extension, int extensionDepth, Map parentEndNodeMap, DirectedGraph graph, ModelController modelController, Font labelFont, Collection ancestorUseCases) {
        HashMap endNodeMap = new HashMap();
        Iterator<ActionStep> actionStepIterator = modelController.getActionSteps(scenario).iterator();
        ActionStep actionStep = actionStepIterator.next();
        ActionStep lastActionStep = null;
        Node currentNode = null;
        Node lastNode = null;
        boolean noMoreSteps = false;
        while (!noMoreSteps) {
            if (actionStep.getStepType().getValue() == 0) {
                currentNode = this.createNode(2, (Object)scenario, extensionDepth);
                if (sourceNode != null) {
                    graph.edges.add((Object)new UseCaseGraphEdge(sourceNode, currentNode, 1));
                }
            } else if (actionStep.getStepType().getValue() == 2) {
                currentNode = this.createNode(3, (Object)actionStep, -1);
            } else if (actionStep.getStepType().getValue() == 1) {
                int endNodeType = this.getEndNodeType(modelController, actionStep, scenario, extension);
                currentNode = this.createNode(endNodeType, (Object)scenario, -1);
                parentEndNodeMap.put(extension != null ? extension : scenario, currentNode);
            }
            graph.nodes.add((Object)currentNode);
            if (lastNode != null) {
                UseCaseGraphEdge edge = new UseCaseGraphEdge(lastNode, currentNode, 1);
                graph.edges.add((Object)edge);
            }
            for (Scenario endingScenario : modelController.getModuleData((IModuleData)actionStep, "ScenarioFinalStep")) {
                if (modelController.getExtendingScenarioEndType(endingScenario) == 5) continue;
                UseCaseGraphNode scenarioEndNode = (UseCaseGraphNode)((Object)endNodeMap.get((Object)endingScenario));
                graph.edges.add((Object)new UseCaseGraphEdge((Node)scenarioEndNode, currentNode, 1));
            }
            for (Extension endingUseCaseExtension : modelController.getModuleData((IModuleData)actionStep, "ExtensionFinalStep")) {
                if (modelController.getExtendingUseCaseEndType(endingUseCaseExtension) == 5) continue;
                UseCaseGraphNode useCaseEndNode = (UseCaseGraphNode)((Object)endNodeMap.get((Object)endingUseCaseExtension));
                if (useCaseEndNode.getNodeType() == 9) {
                    graph.edges.add((Object)new UseCaseGraphEdge((Node)useCaseEndNode, currentNode, 3));
                    continue;
                }
                if (modelController.getExtendingUseCaseEndType(endingUseCaseExtension) == 5) continue;
                graph.edges.add((Object)new UseCaseGraphEdge((Node)useCaseEndNode, currentNode, 1));
            }
            for (Scenario failureScenario : modelController.getModuleData((IModuleData)actionStep, "ScenarioBeginningStep")) {
                if (failureScenario.getSuccess().getValue() != 1) continue;
                UseCaseGraphNode failureScenarioEndNode = (UseCaseGraphNode)((Object)endNodeMap.get((Object)failureScenario));
                graph.edges.add((Object)new UseCaseGraphEdge((Node)failureScenarioEndNode, currentNode, 2));
            }
            for (Extension useCaseExtension : modelController.getModuleData((IModuleData)actionStep, "ExtensionBeginningStep")) {
                if (useCaseExtension.getSuccess().getValue() != 1) continue;
                UseCaseGraphNode useCaseEndNode = (UseCaseGraphNode)((Object)endNodeMap.get((Object)useCaseExtension));
                graph.edges.add((Object)new UseCaseGraphEdge((Node)useCaseEndNode, currentNode, 2));
            }
            if (actionStepIterator.hasNext()) {
                lastActionStep = actionStep;
                actionStep = actionStepIterator.next();
                for (Scenario extensionScenario : modelController.getModuleData((IModuleData)actionStep, "ScenarioBeginningStep")) {
                    this.addScenario(currentNode, extensionScenario, null, this.getExtensionDepth(extensionScenario, modelController), endNodeMap, graph, modelController, labelFont, new ArrayList(ancestorUseCases));
                }
                for (Extension useCaseExtension : modelController.getModuleData((IModuleData)actionStep, "ExtensionBeginningStep")) {
                    UseCase extensionUseCase = modelController.getUseCase(useCaseExtension);
                    this.addUseCase(currentNode, extensionUseCase, useCaseExtension, this.getExtensionDepth(useCaseExtension, modelController), endNodeMap, graph, modelController, labelFont, new ArrayList(ancestorUseCases));
                }
                lastNode = currentNode;
                continue;
            }
            noMoreSteps = true;
        }
    }

    private Node createNode(int type, Object data, int extensionDepth) {
        UseCaseGraphNode newNode = new UseCaseGraphNode(data, type, extensionDepth);
        NodeAttributes nodeAttributes = this.labelCreator.getNodeAttributes((ICockpitProjectData)data, type);
        ((Node)newNode).width = (int)Math.ceil(nodeAttributes.getWidth());
        ((Node)newNode).height = (int)Math.ceil(nodeAttributes.getHeight());
        newNode.setPadding(new Insets(5, 10, 5, 10));
        return newNode;
    }

    private int getExtensionDepth(Extension useCaseExtension, ModelController modelController) {
        int endType = modelController.getExtendingUseCaseEndType(useCaseExtension);
        if (endType == 4 || endType == 5) {
            ActionStep startingStep = (ActionStep)((Object)modelController.getLinkableObjects((IModuleData)useCaseExtension, "ExtensionBeginningStep").iterator().next());
            ActionStep finalStep = (ActionStep)((Object)modelController.getLinkableObjects((IModuleData)useCaseExtension, "ExtensionFinalStep").iterator().next());
            int numberStep = startingStep.getNumber().getValue();
            int numberFinalStep = finalStep.getNumber().getValue();
            return numberFinalStep - numberStep;
        }
        if (endType == 1) {
            return 0;
        }
        if (endType == 2) {
            return 1;
        }
        return -1;
    }

    private int getExtensionDepth(Scenario scenario, ModelController modelController) {
        int endType = modelController.getExtendingScenarioEndType(scenario);
        if (endType == 4 || endType == 5) {
            ActionStep startingStep = (ActionStep)((Object)modelController.getLinkableObjects((IModuleData)scenario, "ScenarioBeginningStep").iterator().next());
            ActionStep finalStep = (ActionStep)((Object)modelController.getLinkableObjects((IModuleData)scenario, "ScenarioFinalStep").iterator().next());
            int numberStep = startingStep.getNumber().getValue();
            int numberFinalStep = finalStep.getNumber().getValue();
            return numberFinalStep - numberStep;
        }
        if (endType == 1) {
            return 0;
        }
        if (endType == 2) {
            return 1;
        }
        return -1;
    }

    private int getEndNodeType(ModelController modelController, ActionStep actionStep, Scenario scenario, Extension extension) {
        if (modelController.isMainScenario(scenario)) {
            if (extension != null) {
                if (modelController.getExtendingUseCaseEndType(extension) != 5) {
                    return 5;
                }
                return 4;
            }
            return 5;
        }
        if (modelController.getExtendingScenarioEndType(scenario) != 5) {
            return 5;
        }
        return 4;
    }
}

