/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.usecasemodule.client.gui.usecaserelationview;

import com.arcway.cockpit.frame.client.lib.relationviews.gefpatch.copied.DirectedGraph;
import com.arcway.cockpit.frame.client.lib.relationviews.gefpatch.copied.Edge;
import com.arcway.cockpit.frame.client.lib.relationviews.gefpatch.copied.EdgeList;
import com.arcway.cockpit.frame.client.lib.relationviews.gefpatch.copied.Node;
import com.arcway.cockpit.frame.client.lib.relationviews.gefpatch.copied.VirtualNode;
import com.arcway.cockpit.frame.client.lib.relationviews.gefpatch.patched.GraphVisitor;
import com.arcway.cockpit.usecasemodule.client.gui.usecaserelationview.gefpatch.derived.UseCaseGraphNode;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;

public class UseCaseGraphHorizontalPlacement
extends GraphVisitor {
    private ArrayList columnWidths;
    private ArrayList columnXCoordinates;
    private ArrayList columnOccupation;

    public void visit(DirectedGraph graph) {
        this.columnWidths = new ArrayList();
        this.columnOccupation = new ArrayList();
        this.columnOccupation.add(0, new Integer(0));
        graph.nodes.normalizeRanks();
        graph.nodes.resetFlags();
        UseCaseGraphNode rootNode = (UseCaseGraphNode)graph.ranks.getRank(0).getNode(0);
        this.determineLengthOfVerticalLine(rootNode);
        graph.nodes.resetFlags();
        this.placeNode((Node)rootNode, 0, 0);
        this.columnXCoordinates = new ArrayList();
        this.calculateColumnXCoordinates();
        graph.nodes.resetFlags();
        this.setCoordinatesForNode((Node)rootNode);
    }

    private void determineLengthOfVerticalLine(UseCaseGraphNode node) {
        node.flag = true;
        EdgeList nextNodesList = node.outgoing;
        this.sortNodeList((List)nextNodesList);
        Iterator nextNodesIterator = nextNodesList.iterator();
        while (nextNodesIterator.hasNext()) {
            Node nextNode = ((Edge)nextNodesIterator.next()).target;
            if (nextNode.flag) continue;
            if (nextNode instanceof UseCaseGraphNode && ((UseCaseGraphNode)nextNode).getExtensionDepth() != -1) {
                this.determineLengthOfVerticalLine((UseCaseGraphNode)nextNode);
                continue;
            }
            node.lengthVerticalLine = this.determineLengthOfRemainingVerticalLine(nextNode);
        }
    }

    private int determineLengthOfRemainingVerticalLine(Node node) {
        int remainingVerticalLength = 1;
        node.flag = true;
        EdgeList nextNodesList = node.outgoing;
        this.sortNodeList((List)nextNodesList);
        Iterator nextNodesIterator = nextNodesList.iterator();
        while (nextNodesIterator.hasNext()) {
            Node nextNode = ((Edge)nextNodesIterator.next()).target;
            if (nextNode.flag) continue;
            if (nextNode instanceof UseCaseGraphNode && ((UseCaseGraphNode)nextNode).getExtensionDepth() != -1) {
                this.determineLengthOfVerticalLine((UseCaseGraphNode)nextNode);
                continue;
            }
            remainingVerticalLength = this.determineLengthOfRemainingVerticalLine(nextNode) + 1;
        }
        return remainingVerticalLength;
    }

    private void placeNode(Node node, int column, int nodeLevel) {
        node.x = column;
        node.flag = true;
        int newColumnWidth = 0;
        int currentNodeRequiredWidth = node.width + node.getPadding().left + node.getPadding().right;
        if (this.columnWidths.size() > column) {
            newColumnWidth = Math.max(currentNodeRequiredWidth, (Integer)this.columnWidths.get(column));
            this.columnWidths.set(column, new Integer(newColumnWidth));
        } else {
            newColumnWidth = currentNodeRequiredWidth;
            this.columnWidths.add(column, new Integer(newColumnWidth));
        }
        ArrayList nextNodeList = new ArrayList(node.outgoing);
        this.sortNodeList(nextNodeList);
        Iterator nextNodesIterator = nextNodeList.iterator();
        while (nextNodesIterator.hasNext()) {
            Node nextNode = ((Edge)nextNodesIterator.next()).target;
            if (nextNode.flag) continue;
            if (nextNode instanceof VirtualNode) {
                this.placeNode(nextNode, column, nodeLevel + 1);
                continue;
            }
            UseCaseGraphNode nextUCGNode = (UseCaseGraphNode)nextNode;
            if (nextUCGNode.getExtensionDepth() == -1) {
                this.placeNode((Node)nextUCGNode, column, nodeLevel + 1);
                continue;
            }
            int nextNodeRank = nextUCGNode.rank;
            int nextNodeLengthVerticalLine = nextUCGNode.lengthVerticalLine;
            int newColumn = column + 1;
            boolean columnIsVacant = false;
            while (!columnIsVacant && this.columnOccupation.size() > newColumn) {
                int lowestOccupiedRank = (Integer)this.columnOccupation.get(newColumn);
                if (nextNodeRank + nextNodeLengthVerticalLine < lowestOccupiedRank) {
                    this.columnOccupation.set(newColumn, new Integer(nextNodeRank));
                    columnIsVacant = true;
                    continue;
                }
                ++newColumn;
            }
            if (this.columnOccupation.size() <= newColumn) {
                this.columnOccupation.add(newColumn, new Integer(nextNodeRank));
            }
            this.placeNode((Node)nextUCGNode, newColumn, nextNodeRank);
        }
    }

    private void setCoordinatesForNode(Node node) {
        int columnX = (Integer)this.columnXCoordinates.get(node.x);
        int columnWidth = (Integer)this.columnWidths.get(node.x);
        int nodeRequiredWidth = node.width + node.getPadding().left + node.getPadding().right;
        node.x = columnX + (columnWidth - nodeRequiredWidth) / 2 + (columnWidth - nodeRequiredWidth) % 2 + node.getPadding().left;
        node.flag = true;
        Iterator nextNodesIterator = node.outgoing.iterator();
        while (nextNodesIterator.hasNext()) {
            Node nextNode = ((Edge)nextNodesIterator.next()).target;
            if (nextNode.flag) continue;
            this.setCoordinatesForNode(nextNode);
        }
    }

    private void calculateColumnXCoordinates() {
        int currentX = 0;
        int c = 0;
        while (c < this.columnWidths.size()) {
            this.columnXCoordinates.add(c, new Integer(currentX));
            currentX += ((Integer)this.columnWidths.get(c)).intValue();
            ++c;
        }
    }

    private void sortNodeList(List list) {
        Collections.sort(list, new Comparator(){

            public int compare(Object arg0, Object arg1) {
                arg0 = ((Edge)arg0).target;
                arg1 = ((Edge)arg1).target;
                if (!(arg0 instanceof UseCaseGraphNode)) {
                    if (!(arg1 instanceof UseCaseGraphNode)) {
                        return 0;
                    }
                    return -1;
                }
                if (!(arg1 instanceof UseCaseGraphNode)) {
                    return 1;
                }
                UseCaseGraphNode ucgn0 = (UseCaseGraphNode)((Object)arg0);
                UseCaseGraphNode ucgn1 = (UseCaseGraphNode)((Object)arg1);
                if (ucgn0.getExtensionDepth() != -1) {
                    if (ucgn1.getExtensionDepth() != -1) {
                        return ucgn0.getExtensionDepth() - ucgn1.getExtensionDepth();
                    }
                    return 1;
                }
                if (ucgn1.getExtensionDepth() != -1) {
                    return -1;
                }
                return 0;
            }
        });
    }
}

