/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.usecasemodule.client.gui.projection;

import com.arcway.cockpit.frame.client.global.selection.CockpitSelectionManager;
import com.arcway.cockpit.frame.client.project.modules.IModuleProjectAgent;
import com.arcway.cockpit.frame.client.project.planeditors.projections.IProjectionPreferencePage;
import com.arcway.cockpit.usecasemodule.client.Messages;
import com.arcway.cockpit.usecasemodule.client.UseCaseModulePlugin;
import com.arcway.cockpit.usecasemodule.client.gui.projection.ProjectionManager;
import com.arcway.cockpit.usecasemodule.client.gui.projection.UseCaseProjectionsLicenseHandler;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.ISelectionService;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PlatformUI;

public class ProjectionPreferencePage
extends PreferencePage
implements IProjectionPreferencePage {
    private UseCaseProjectionsLicenseHandler licenseHandler;
    private Composite parent;
    private Button btn_ucID;
    private Button btn_ucName;
    private Button btn_ucGoal;
    private Button btn_asSelectedUsesCasesOnly;
    private Button btn_asShortText;
    private Button btn_asNumber;
    private Button btn_asName;
    private Button btn_asDescription;

    protected Control createContents(Composite parentComposite) {
        if (this.licenseHandler == null) {
            this.licenseHandler = new UseCaseProjectionsLicenseHandler();
        }
        if (this.licenseHandler.anyProjectHasLicense()) {
            this.parent = parentComposite;
            Composite composite = new Composite(parentComposite, 0);
            GridLayout layout = new GridLayout();
            composite.setLayout((Layout)layout);
            composite.setLayoutData((Object)new GridData(768));
            Group grp_actionSteps = new Group(composite, 0);
            grp_actionSteps.setText(Messages.getString("ProjectionPreferencePage.ActionStepsGroupTitle"));
            layout = new GridLayout(2, false);
            layout.marginTop = 10;
            layout.horizontalSpacing = 10;
            grp_actionSteps.setLayout((Layout)layout);
            grp_actionSteps.setLayoutData((Object)new GridData(768));
            Label lbl_actionSteps = new Label((Composite)grp_actionSteps, 0);
            lbl_actionSteps.setText(Messages.getString("ProjectionPreferencePage.ActionStepsTitle"));
            GridData gd = new GridData(1, 1, false, false);
            gd.verticalSpan = 3;
            lbl_actionSteps.setLayoutData((Object)gd);
            this.btn_asNumber = new Button((Composite)grp_actionSteps, 32);
            this.btn_asNumber.setText(Messages.getString("ProjectionPreferencePage.ShowNumber"));
            gd = new GridData(768);
            this.btn_asNumber.setLayoutData((Object)gd);
            this.btn_asName = new Button((Composite)grp_actionSteps, 32);
            this.btn_asName.setText(Messages.getString("ProjectionPreferencePage.ShowName"));
            gd = new GridData(768);
            this.btn_asName.setLayoutData((Object)gd);
            this.btn_asDescription = new Button((Composite)grp_actionSteps, 32);
            this.btn_asDescription.setText(Messages.getString("ProjectionPreferencePage.ShowDesc"));
            gd = new GridData(768);
            this.btn_asDescription.setLayoutData((Object)gd);
            this.btn_asSelectedUsesCasesOnly = new Button((Composite)grp_actionSteps, 32);
            this.btn_asSelectedUsesCasesOnly.setText(Messages.getString("ProjectionPreferencePage.SelectPref"));
            gd = new GridData(768);
            gd.horizontalSpan = 2;
            gd.verticalIndent = 10;
            this.btn_asSelectedUsesCasesOnly.setLayoutData((Object)gd);
            this.btn_asShortText = new Button((Composite)grp_actionSteps, 32);
            this.btn_asShortText.setText(Messages.getString("ProjectionPreferencePage.AbbrPref"));
            gd = new GridData(768);
            gd.horizontalSpan = 2;
            this.btn_asShortText.setLayoutData((Object)gd);
            Group grp_useCases = new Group(composite, 0);
            grp_useCases.setText(Messages.getString("ProjectionPreferencePage.UseCaseGroupTitle"));
            layout = new GridLayout(2, false);
            layout.marginTop = 10;
            layout.horizontalSpacing = 10;
            grp_useCases.setLayout((Layout)layout);
            grp_useCases.setLayoutData((Object)new GridData(768));
            Label lbl_usesCases = new Label((Composite)grp_useCases, 0);
            lbl_usesCases.setText(Messages.getString("ProjectionPreferencePage.UseCaseTitle"));
            gd = new GridData(1, 1, false, false);
            gd.verticalSpan = 3;
            lbl_usesCases.setLayoutData((Object)gd);
            this.btn_ucID = new Button((Composite)grp_useCases, 32);
            this.btn_ucID.setText(Messages.getString("ProjectionPreferencePage.ShowID"));
            gd = new GridData(768);
            this.btn_ucID.setLayoutData((Object)gd);
            this.btn_ucName = new Button((Composite)grp_useCases, 32);
            this.btn_ucName.setText(Messages.getString("ProjectionPreferencePage.ShowName"));
            gd = new GridData(768);
            this.btn_ucName.setLayoutData((Object)gd);
            this.btn_ucGoal = new Button((Composite)grp_useCases, 32);
            this.btn_ucGoal.setText(Messages.getString("ProjectionPreferencePage.ShowGoal"));
            gd = new GridData(768);
            this.btn_ucGoal.setLayoutData((Object)gd);
            this.init();
            return parentComposite;
        }
        this.noDefaultAndApplyButton();
        return this.licenseHandler.createNoLicensePage(parentComposite);
    }

    private void init() {
        IPreferenceStore store = this.doGetPreferenceStore();
        this.btn_asNumber.setSelection(store.getBoolean("ucm.projections.preference.actionstep.number"));
        this.btn_asName.setSelection(store.getBoolean("ucm.projections.preference.actionstep.title"));
        this.btn_asDescription.setSelection(store.getBoolean("ucm.projections.preference.actionstep.description"));
        this.btn_asSelectedUsesCasesOnly.setSelection(store.getBoolean("ucm.projections.preference.selected_elements"));
        this.btn_asShortText.setSelection(store.getBoolean("ucm.projections.preference.usecase.wrap"));
        this.btn_ucID.setSelection(store.getBoolean("ucm.projections.preference.usecase.id"));
        this.btn_ucName.setSelection(store.getBoolean("ucm.projections.preference.usecase.name"));
        this.btn_ucGoal.setSelection(store.getBoolean("ucm.projections.preference.usecase.goal"));
    }

    protected void performApply() {
        IPreferenceStore store = this.doGetPreferenceStore();
        store.setValue("ucm.projections.preference.actionstep.number", this.btn_asNumber.getSelection());
        store.setValue("ucm.projections.preference.actionstep.title", this.btn_asName.getSelection());
        store.setValue("ucm.projections.preference.actionstep.description", this.btn_asDescription.getSelection());
        store.setValue("ucm.projections.preference.selected_elements", this.btn_asSelectedUsesCasesOnly.getSelection());
        store.setValue("ucm.projections.preference.usecase.wrap", this.btn_asShortText.getSelection());
        store.setValue("ucm.projections.preference.usecase.id", this.btn_ucID.getSelection());
        store.setValue("ucm.projections.preference.usecase.name", this.btn_ucName.getSelection());
        store.setValue("ucm.projections.preference.usecase.goal", this.btn_ucGoal.getSelection());
    }

    public boolean performOk() {
        this.performApply();
        if (this.parent.isVisible()) {
            IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
            IModuleProjectAgent projectAgent = CockpitSelectionManager.getSelectionService((ISelectionService)page.getWorkbenchWindow().getSelectionService()).getModuleProjectAgent();
            String currentProjectUid = projectAgent.getProjectUID();
            ProjectionManager currentProjectionManager = (ProjectionManager)UseCaseModulePlugin.getDefault().getProjectManager().getModelController(currentProjectUid).getProjectionManager();
            currentProjectionManager.updateProjections(page);
        }
        return true;
    }

    protected void performDefaults() {
        IPreferenceStore store = this.doGetPreferenceStore();
        this.btn_asNumber.setSelection(store.getDefaultBoolean("ucm.projections.preference.actionstep.number"));
        this.btn_asName.setSelection(store.getDefaultBoolean("ucm.projections.preference.actionstep.title"));
        this.btn_asDescription.setSelection(store.getDefaultBoolean("ucm.projections.preference.actionstep.description"));
        this.btn_asSelectedUsesCasesOnly.setSelection(store.getDefaultBoolean("ucm.projections.preference.selected_elements"));
        this.btn_asShortText.setSelection(store.getDefaultBoolean("ucm.projections.preference.usecase.wrap"));
        this.btn_ucID.setSelection(store.getDefaultBoolean("ucm.projections.preference.usecase.id"));
        this.btn_ucName.setSelection(store.getDefaultBoolean("ucm.projections.preference.usecase.name"));
        this.btn_ucGoal.setSelection(store.getDefaultBoolean("ucm.projections.preference.usecase.goal"));
        super.performDefaults();
    }

    protected IPreferenceStore doGetPreferenceStore() {
        return UseCaseModulePlugin.getDefault().getPreferenceStore();
    }

    public boolean isImmediateProjectionPossible(String projectUID) {
        return this.licenseHandler.checkLicense(projectUID);
    }
}

