/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.usecasemodule.client.gui.projection;

import com.arcway.cockpit.frame.client.global.selection.CockpitSelectionManager;
import com.arcway.cockpit.frame.client.global.selection.CockpitSelectionService;
import com.arcway.cockpit.frame.client.project.core.uniqueelements.IUniqueElement;
import com.arcway.cockpit.frame.client.project.modules.IModuleProjectAgent;
import com.arcway.cockpit.frame.client.project.modules.IUniqueElementProjectionRequest;
import com.arcway.cockpit.frame.client.project.modules.ProjectionIdentifier;
import com.arcway.cockpit.frame.client.project.modules.UniqueElementProjectionRequest;
import com.arcway.cockpit.frame.client.project.planeditors.projections.IProjectionReceiver;
import com.arcway.cockpit.modulelib2.client.core.project.IModel;
import com.arcway.cockpit.modulelib2.client.core.project.LinkMgr;
import com.arcway.cockpit.modulelib2.client.core.project.ProjectionMgr;
import com.arcway.cockpit.modulelib2.client.messages.IModuleData;
import com.arcway.cockpit.usecasemodule.client.UseCaseModulePlugin;
import com.arcway.cockpit.usecasemodule.client.core.project.ActionStepSorter;
import com.arcway.cockpit.usecasemodule.client.core.project.DataManager;
import com.arcway.cockpit.usecasemodule.client.gui.projection.BubbleContainerProjectionActionStep;
import com.arcway.cockpit.usecasemodule.client.gui.projection.IUCMProjectionConstants;
import com.arcway.cockpit.usecasemodule.client.messages.ActionStep;
import com.arcway.cockpit.usecasemodule.client.messages.Scenario;
import com.arcway.cockpit.usecasemodule.client.messages.UseCase;
import com.arcway.cockpit.usecasemodule.client.messages.description.UseCaseDescription;
import com.arcway.cockpit.usecasemodule.shared.ModuleIdentification;
import com.arcway.lib.graphics.Alignment;
import com.arcway.lib.graphics.Color;
import com.arcway.lib.graphics.text.TextStyle;
import com.arcway.lib.java.collectionmaps.SetMap;
import com.arcway.lib.stringtools.StringUtil;
import com.arcway.planagent.controllinginterface.lib.projections.TextProjection;
import com.arcway.planagent.controllinginterface.planviewer.IProjection;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.ISelectionService;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;

public class ProjectionManager
extends ProjectionMgr {
    private final Map<IWorkbenchPage, ProjectionSelectionListener> map_workbenchPage_selectionListener = new HashMap<IWorkbenchPage, ProjectionSelectionListener>();
    private final SetMap<IWorkbenchPage, IProjectionReceiver> map_workbenchPage_actionStepProjectionReceivers = new SetMap();

    public void construct(IModuleProjectAgent project, IModel model_, LinkMgr linkManager_) {
        super.construct(project, model_, linkManager_);
        UseCaseModulePlugin.getDefault().getPreferenceStore().addPropertyChangeListener((IPropertyChangeListener)this);
    }

    public void doStopProjection(IProjectionReceiver projectionReceiver, IWorkbenchPage page) {
        if (this.map_workbenchPage_actionStepProjectionReceivers.contains((Object)page, (Object)projectionReceiver)) {
            this.map_workbenchPage_actionStepProjectionReceivers.remove((Object)page, (Object)projectionReceiver);
            if (this.map_workbenchPage_actionStepProjectionReceivers.isEmpty((Object)page)) {
                CockpitSelectionService selectionService = CockpitSelectionManager.getSelectionService((ISelectionService)page);
                selectionService.removeSelectionListener((ISelectionListener)this.map_workbenchPage_selectionListener.get(page));
                this.map_workbenchPage_selectionListener.remove(page);
            }
        }
    }

    public final void closeProject_() {
        UseCaseModulePlugin.getDefault().getPreferenceStore().removePropertyChangeListener((IPropertyChangeListener)this);
    }

    protected Collection<ProjectionIdentifier> getAvailableProjections() {
        return Arrays.asList(new ProjectionIdentifier("ucm.projections.countactionsteps"), new ProjectionIdentifier("ucm.projections.usecases"));
    }

    protected Collection<Class<?>> getDatatypesWhichTriggerUpdate() {
        return Arrays.asList(ActionStep.class, Scenario.class, UseCase.class);
    }

    protected Collection<String> getLinktypesWhichTriggerUpdate() {
        return Arrays.asList("StepUniqueElement", "UseCaseUniqueElement");
    }

    protected Set<String> getPreferences() {
        return IUCMProjectionConstants.PREFERENCES;
    }

    protected ProjectionIdentifier getProjectionIdentifierForHighlighting() {
        return new ProjectionIdentifier(String.valueOf(ModuleIdentification.getModuleID()) + ".projection.highlight");
    }

    protected void doProject(ProjectionIdentifier projectionID, IProjectionReceiver projectionReceiver, IWorkbenchPage page) {
        HashSet<Object> selectedElements = new HashSet<Object>();
        ISelection selection = page.getSelection("com.arcway.cockpit.usecasemodule.client.gui.dataview");
        if (selection != null && selection instanceof IStructuredSelection) {
            selectedElements.addAll(((IStructuredSelection)selection).toList());
        }
        Collection uniqueElementsOfPlan = this.projectAgent.getModuleUniqueElementManager().getUniqueElementsOfPlan(projectionReceiver.getPlanUID());
        List<IUniqueElementProjectionRequest> requests = null;
        if (projectionID.getProjectionID().equals("ucm.projections.countactionsteps")) {
            requests = this.getRequestListSteps(uniqueElementsOfPlan, selectedElements);
            if (this.map_workbenchPage_selectionListener.get(page) == null) {
                ProjectionSelectionListener selectionListener = new ProjectionSelectionListener(page, projectionReceiver);
                CockpitSelectionService selectionService = CockpitSelectionManager.getSelectionService((ISelectionService)page);
                selectionService.addSelectionListener((ISelectionListener)selectionListener);
                this.map_workbenchPage_selectionListener.put(page, selectionListener);
            }
            this.map_workbenchPage_actionStepProjectionReceivers.add((Object)page, (Object)projectionReceiver);
        } else if (projectionID.getProjectionID().equals("ucm.projections.usecases")) {
            requests = this.getRequestListUseCases(uniqueElementsOfPlan);
        }
        if (requests != null) {
            projectionReceiver.project(Collections.EMPTY_LIST, requests);
        }
    }

    private List<IUniqueElementProjectionRequest> getRequestListSteps(Collection<IUniqueElement> uniqueElements, Collection<Object> selectedElements) {
        assert (uniqueElements != null);
        assert (selectedElements != null);
        ArrayList<IUniqueElementProjectionRequest> requests = new ArrayList<IUniqueElementProjectionRequest>();
        for (IUniqueElement ue : uniqueElements) {
            List<String> stepProjectionStrings = this.getStepProjectStrings(ue, selectedElements);
            if (stepProjectionStrings.size() <= 0) continue;
            String text = StringUtil.concatWithLineBreaks((String[])stepProjectionStrings.toArray(new String[stepProjectionStrings.size()]), (boolean)true);
            Color textColor = Color.BLACK;
            int textWidth = 250;
            int textHeight = 10;
            Alignment alignment = new Alignment(1, 16);
            TextStyle textStyle = new TextStyle("Arial");
            TextProjection textArrayProjFactory2 = new TextProjection(text, textColor, (double)textWidth, textStyle, (double)textHeight, alignment);
            BubbleContainerProjectionActionStep bubbleFactory = new BubbleContainerProjectionActionStep((IProjection)textArrayProjFactory2);
            UniqueElementProjectionRequest request = new UniqueElementProjectionRequest(ue.getUID(), (IProjection)bubbleFactory);
            requests.add((IUniqueElementProjectionRequest)request);
        }
        return requests;
    }

    private List<IUniqueElementProjectionRequest> getRequestListUseCases(Collection<IUniqueElement> uniqueElements) {
        assert (uniqueElements != null);
        ArrayList<IUniqueElementProjectionRequest> requests = new ArrayList<IUniqueElementProjectionRequest>();
        for (IUniqueElement ue : uniqueElements) {
            List<String> projectionStrings = this.getUseCaseProjectionStrings(ue);
            if (projectionStrings.size() <= 0) continue;
            String text = StringUtil.concatWithLineBreaks((String[])projectionStrings.toArray(new String[projectionStrings.size()]), (boolean)true);
            Color textColor = Color.BLACK;
            int textArrayWidthHint = 250;
            int textHeight = 10;
            Alignment alignment = new Alignment(1, 16);
            TextStyle textStyle = new TextStyle("Arial");
            TextProjection textArrayProjFactory2 = new TextProjection(text, textColor, (double)textArrayWidthHint, textStyle, (double)textHeight, alignment);
            BubbleContainerProjectionActionStep bubbleFactory = new BubbleContainerProjectionActionStep((IProjection)textArrayProjFactory2);
            UniqueElementProjectionRequest request = new UniqueElementProjectionRequest(ue.getUID(), (IProjection)bubbleFactory);
            requests.add((IUniqueElementProjectionRequest)request);
        }
        return requests;
    }

    private List<String> getStepProjectStrings(IUniqueElement ue, Collection<Object> selectedElements) {
        List<ActionStep> steps = new ArrayList<ActionStep>(this.linkManager.getModuleData(ue.getUID(), "StepUniqueElement"));
        steps = ActionStepSorter.sortStepsAccordingToUseCaseScenarioAndID(steps, (DataManager)this.model);
        ArrayList<String> texts = new ArrayList<String>();
        IPreferenceStore preferenceStore = UseCaseModulePlugin.getDefault().getPreferenceStore();
        boolean showActionStepNumber = preferenceStore.getBoolean("ucm.projections.preference.actionstep.number");
        boolean showActionStepTitle = preferenceStore.getBoolean("ucm.projections.preference.actionstep.title");
        boolean showActionStepDescription = preferenceStore.getBoolean("ucm.projections.preference.actionstep.description");
        boolean showOnlySelectedUseCases = preferenceStore.getBoolean("ucm.projections.preference.selected_elements");
        boolean shrink = preferenceStore.getBoolean("ucm.projections.preference.usecase.wrap");
        UseCase lastUseCase = null;
        Scenario lastParentScenario = null;
        for (ActionStep step : steps) {
            String number = ((DataManager)this.model).getDisplayRepresentation_ActionStepNumberWithFullScenarioPrefix(step);
            String title = step.getTitle().getDisplayStringRepresentation();
            String description = step.getDescription().getDisplayStringRepresentation();
            if (shrink) {
                title = StringUtil.shrink((String)title, (int)20);
                description = StringUtil.shrink((String)StringUtil.removeNewlines((String)description), (int)20);
            }
            Collection scenarios = this.linkManager.getLinkableObjects((IModuleData)step, "StepScenario");
            assert (scenarios.size() == 1);
            Scenario scenario = (Scenario)((Object)scenarios.iterator().next());
            UseCase useCase = ((DataManager)this.model).getUseCase(scenario);
            if (showOnlySelectedUseCases && !selectedElements.contains((Object)useCase)) continue;
            if (lastUseCase == null || !lastUseCase.equals((Object)useCase)) {
                if (lastUseCase != null) {
                    texts.add("");
                }
                texts.add(String.valueOf(UseCaseDescription.MODULE_DATA_NAME) + ": " + useCase.getDisplayRepresentation());
            }
            if ((lastParentScenario == null || !lastParentScenario.equals((Object)scenario)) && lastUseCase != null && lastUseCase.equals((Object)useCase)) {
                texts.add("");
            }
            lastUseCase = useCase;
            lastParentScenario = scenario;
            String projectionString = "";
            boolean hasNumberOrTitle = false;
            if (showActionStepNumber) {
                projectionString = String.valueOf(projectionString) + number;
                if (showActionStepTitle || showActionStepDescription) {
                    projectionString = String.valueOf(projectionString) + ": ";
                }
                hasNumberOrTitle = true;
            }
            if (showActionStepTitle) {
                projectionString = String.valueOf(projectionString) + title;
                hasNumberOrTitle = true;
            }
            if (hasNumberOrTitle) {
                texts.add(projectionString);
            }
            if (!showActionStepDescription) continue;
            texts.add(description);
        }
        return texts;
    }

    private List<String> getUseCaseProjectionStrings(IUniqueElement ue) {
        ArrayList useCases = new ArrayList(this.linkManager.getModuleData(ue.getUID(), "UseCaseUniqueElement"));
        ArrayList<String> texts = new ArrayList<String>(useCases.size());
        IPreferenceStore preferenceStore = UseCaseModulePlugin.getDefault().getPreferenceStore();
        boolean showID = preferenceStore.getBoolean("ucm.projections.preference.usecase.id");
        boolean showName = preferenceStore.getBoolean("ucm.projections.preference.usecase.name");
        boolean showGoal = preferenceStore.getBoolean("ucm.projections.preference.usecase.goal");
        boolean shrink = preferenceStore.getBoolean("ucm.projections.preference.usecase.wrap");
        for (UseCase useCase : useCases) {
            String projectionString = "";
            boolean hasIDOrName = false;
            if (showID) {
                projectionString = String.valueOf(projectionString) + useCase.getID().getDisplayStringRepresentation();
                if (showName || showGoal) {
                    projectionString = String.valueOf(projectionString) + ": ";
                }
                hasIDOrName = true;
            }
            if (showName) {
                projectionString = String.valueOf(projectionString) + useCase.getName().getDisplayStringRepresentation();
                hasIDOrName = true;
            }
            if (hasIDOrName) {
                texts.add(projectionString);
            }
            if (!showGoal) continue;
            Scenario mainScenario = (Scenario)((Object)this.model.getModuleData((IModuleData)useCase, "MainScenarioUseCase").iterator().next());
            String goal = mainScenario.getGoal().getDisplayStringRepresentation();
            if (shrink) {
                goal = StringUtil.shrink((String)StringUtil.removeNewlines((String)goal), (int)20);
            }
            texts.add(goal);
        }
        return texts;
    }

    private class ProjectionSelectionListener
    implements ISelectionListener {
        private final IWorkbenchPage page;
        private final IProjectionReceiver receiver;

        public ProjectionSelectionListener(IWorkbenchPage page, IProjectionReceiver receiver) {
            this.page = page;
            this.receiver = receiver;
        }

        public void selectionChanged(IWorkbenchPart part, ISelection selection) {
            if (part.getSite().getPage().equals(this.page)) {
                ProjectionManager.this.updateProjections(this.page);
            }
        }

        public boolean equals(Object obj) {
            return obj == this || obj instanceof ProjectionSelectionListener && ((ProjectionSelectionListener)obj).page.equals(this.page) && ((ProjectionSelectionListener)obj).receiver.equals(this.receiver);
        }

        public int hashCode() {
            return (String.valueOf(Integer.toString(this.page.hashCode())) + Integer.toString(this.receiver.hashCode())).hashCode();
        }
    }
}

