/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.usecasemodule.client.gui.menu.actions;

import com.arcway.cockpit.interFace.ICockpitProjectData;
import com.arcway.cockpit.modulelib2.client.core.project.AbstractLockManager;
import com.arcway.cockpit.modulelib2.client.core.project.IModelController;
import com.arcway.cockpit.modulelib2.client.core.project.LockAccess;
import com.arcway.cockpit.modulelib2.client.gui.editdialogs.IModuleDataEditDialogProvider;
import com.arcway.cockpit.modulelib2.client.gui.editdialogs.ModuleDataCreationWizard;
import com.arcway.cockpit.modulelib2.client.messages.IModuleData;
import com.arcway.cockpit.usecasemodule.client.Messages;
import com.arcway.cockpit.usecasemodule.client.gui.dialogues.EditUseCaseAdapter;
import com.arcway.cockpit.usecasemodule.client.messages.Category;
import com.arcway.cockpit.usecasemodule.client.messages.UseCase;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.widgets.Shell;

public class ActionNewUseCase
extends Action {
    private final IModelController modelCtrl;
    private final Category parent;
    private final Shell activeShell;

    public ActionNewUseCase(Shell activeShell, IModelController modelCtrl, Category parent) {
        this.activeShell = activeShell;
        this.modelCtrl = modelCtrl;
        this.parent = parent;
    }

    public void run() {
        assert (this.modelCtrl != null) : "model must not be null";
        AbstractLockManager lockManager = this.modelCtrl.getLockMgr();
        LockAccess lockAccess = lockManager.acquireInsertLock((ICockpitProjectData)this.parent, true);
        if (!lockAccess.hasLock()) {
            return;
        }
        ModuleDataCreationWizard moduleDataEditWizard = new ModuleDataCreationWizard((IModuleDataEditDialogProvider)new EditUseCaseAdapter(this.parent), "ucm.useCase", this.modelCtrl, Messages.getString("NewUseCaseWizard.Message"));
        UseCase item = new UseCase();
        item.setProjectUID(this.modelCtrl.getProjectUID());
        boolean creationPossible = moduleDataEditWizard.initialiseWizard(new IModuleData[]{item}, new IModuleData[]{this.parent});
        if (!creationPossible) {
            lockAccess.releaseLocks();
            return;
        }
        WizardDialog dialog = new WizardDialog(this.activeShell, (IWizard)moduleDataEditWizard);
        if (dialog.open() != 0) {
            lockAccess.releaseLocks();
        }
    }
}

