/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.usecasemodule.client.gui.menu.actions;

import com.arcway.cockpit.interFace.ICockpitProjectData;
import com.arcway.cockpit.modulelib2.client.core.project.AbstractLockManager;
import com.arcway.cockpit.modulelib2.client.core.project.IModelController;
import com.arcway.cockpit.modulelib2.client.core.project.LockAccess;
import com.arcway.cockpit.modulelib2.client.gui.editdialogs.IModuleDataEditDialogProvider;
import com.arcway.cockpit.modulelib2.client.gui.editdialogs.ModuleDataEditDialog;
import com.arcway.cockpit.modulelib2.client.messages.IModuleData;
import com.arcway.cockpit.usecasemodule.client.gui.dialogues.EditScenarioAdapter;
import com.arcway.cockpit.usecasemodule.client.messages.ActionStep;
import com.arcway.cockpit.usecasemodule.client.messages.Scenario;
import org.eclipse.jface.action.Action;
import org.eclipse.swt.widgets.Shell;

public class ActionNewScenario
extends Action {
    private final Shell activeShell;
    private final IModelController modelCtrl;
    private final Scenario parentScenario;
    private final ActionStep parentActionStep;

    public ActionNewScenario(Shell activeShell, IModelController modelCtrl, Scenario parentScenario, ActionStep parentActionStep) {
        this.activeShell = activeShell;
        this.modelCtrl = modelCtrl;
        this.parentScenario = parentScenario;
        this.parentActionStep = parentActionStep;
    }

    public void run() {
        assert (this.modelCtrl != null) : "model must not be null";
        Scenario scenario = this.parentScenario != null ? this.parentScenario : (Scenario)this.modelCtrl.getParent((IModuleData)this.parentActionStep);
        AbstractLockManager lockManager = this.modelCtrl.getLockMgr();
        LockAccess insertLock = lockManager.acquireInsertLock((ICockpitProjectData)scenario, true);
        if (!insertLock.hasLock()) {
            return;
        }
        LockAccess editLock = lockManager.acquireEditLock((ICockpitProjectData)scenario, true);
        if (!editLock.hasLock()) {
            insertLock.releaseLocks();
            return;
        }
        ModuleDataEditDialog moduleDataEditDialog = new ModuleDataEditDialog((IModuleDataEditDialogProvider)new EditScenarioAdapter(scenario, this.parentActionStep), this.activeShell);
        Scenario item = new Scenario();
        item.setProjectUID(this.modelCtrl.getProjectUID());
        boolean creationPossible = moduleDataEditDialog.initialiseDialogue(new IModuleData[]{item});
        if (!creationPossible) {
            insertLock.releaseLocks();
            editLock.releaseLocks();
            return;
        }
        if (moduleDataEditDialog.open() != 0) {
            insertLock.releaseLocks();
            editLock.releaseLocks();
        }
    }
}

