/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.usecasemodule.client.gui.menu.actions;

import com.arcway.cockpit.interFace.ICockpitProjectData;
import com.arcway.cockpit.modulelib2.client.core.project.AbstractLockManager;
import com.arcway.cockpit.modulelib2.client.core.project.IModelController;
import com.arcway.cockpit.modulelib2.client.core.project.LockAccess;
import com.arcway.cockpit.modulelib2.client.gui.editdialogs.IModuleDataEditDialogProvider;
import com.arcway.cockpit.modulelib2.client.gui.editdialogs.ModuleDataCreationWizard;
import com.arcway.cockpit.modulelib2.client.messages.IModuleData;
import com.arcway.cockpit.usecasemodule.client.Messages;
import com.arcway.cockpit.usecasemodule.client.core.project.ModelController;
import com.arcway.cockpit.usecasemodule.client.gui.dialogues.EditActionStepAdapter;
import com.arcway.cockpit.usecasemodule.client.messages.ActionStep;
import com.arcway.cockpit.usecasemodule.client.messages.Scenario;
import com.arcway.cockpit.usecasemodule.client.messages.UseCase;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.widgets.Shell;

public class ActionNewActionStep
extends Action {
    private final Shell activeShell;
    private final IModelController modelCtrl;
    private final ActionStep actionStep;
    private final boolean insertedBefore;

    public ActionNewActionStep(Shell activeShell, IModelController modelCtrl, ActionStep actionStep, boolean insertedBefore) {
        this.activeShell = activeShell;
        this.modelCtrl = modelCtrl;
        this.actionStep = actionStep;
        this.insertedBefore = insertedBefore;
    }

    public void run() {
        assert (this.modelCtrl != null) : "model must not be null";
        ActionStep item = new ActionStep();
        item.setProjectUID(this.modelCtrl.getProjectUID());
        Scenario parent = (Scenario)this.modelCtrl.getParent((IModuleData)this.actionStep);
        UseCase useCase = ((ModelController)this.modelCtrl).getUseCase(this.actionStep);
        AbstractLockManager lockManager = this.modelCtrl.getLockMgr();
        LockAccess lockAccess = lockManager.acquireEditLock((ICockpitProjectData)parent, true);
        if (!lockAccess.hasLock()) {
            return;
        }
        ModuleDataCreationWizard moduleDataEditWizard = new ModuleDataCreationWizard((IModuleDataEditDialogProvider)new EditActionStepAdapter(this.actionStep, this.insertedBefore, useCase), "ucm.ActionStep", this.modelCtrl, Messages.getString("NewActionStepWizard.Message"));
        boolean creationPossible = moduleDataEditWizard.initialiseWizard(new IModuleData[]{item}, new IModuleData[]{parent});
        if (!creationPossible) {
            lockAccess.releaseLocks();
            return;
        }
        if (new WizardDialog(this.activeShell, (IWizard)moduleDataEditWizard).open() != 0) {
            lockAccess.releaseLocks();
        }
    }
}

