/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.usecasemodule.client.gui.linkviewcontribution;

import com.arcway.cockpit.frame.client.global.gui.views.linkview.IModuleLinkLabelProvider;
import com.arcway.cockpit.modulelib2.client.gui.ImageDescriptorRegistry;
import com.arcway.cockpit.usecasemodule.client.Messages;
import com.arcway.cockpit.usecasemodule.client.UseCaseModulePlugin;
import com.arcway.cockpit.usecasemodule.client.core.project.ModelController;
import com.arcway.cockpit.usecasemodule.client.gui.linkviewcontribution.ActionStepLinks;
import com.arcway.cockpit.usecasemodule.client.gui.linkviewcontribution.UseCaseLinks;
import com.arcway.cockpit.usecasemodule.client.messages.ActionStep;
import com.arcway.cockpit.usecasemodule.client.messages.Scenario;
import com.arcway.cockpit.usecasemodule.client.messages.UseCase;
import com.arcway.lib.stringtools.StringUtil;
import de.plans.lib.util.StringCondenser;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.swt.graphics.Image;

public class LinkLabelProvider
implements IModuleLinkLabelProvider {
    private static final int DISPLAY_LENGHT = 60;
    ImageDescriptorRegistry imageDescriptorRegistry = UseCaseModulePlugin.getDefault().getImageDescriptorRegistry();

    public Image getImage(Object element) {
        Image image = null;
        ImageDescriptor desc = null;
        if (element instanceof UseCase) {
            desc = UseCaseModulePlugin.getImageDescriptor("UseCase.gif");
        } else if (element instanceof ActionStep) {
            desc = UseCaseModulePlugin.getImageDescriptor("ActionStep.gif");
        } else if (element instanceof Scenario) {
            desc = UseCaseModulePlugin.getImageDescriptor("Scenario.gif");
        } else if (element instanceof UseCaseLinks) {
            desc = UseCaseModulePlugin.getImageDescriptor("UseCase.gif");
        } else if (element instanceof ActionStepLinks) {
            desc = UseCaseModulePlugin.getImageDescriptor("ActionStep.gif");
        }
        if (desc != null) {
            image = this.imageDescriptorRegistry.get(desc);
        }
        return image;
    }

    public String getText(Object element) {
        return this.getText(element, false);
    }

    public String getText(Object element, boolean limited) {
        String text;
        String displayString = null;
        if (element instanceof UseCase) {
            displayString = ((UseCase)((Object)element)).getID().getDisplayStringRepresentation();
            displayString = StringUtil.removeNewlinesAndTrim((String)displayString);
            if (limited) {
                displayString = StringCondenser.cutOffEnd((String)displayString, (int)60);
            }
            text = displayString;
        } else if (element instanceof Scenario) {
            Scenario scenario = (Scenario)((Object)element);
            ModelController modelController = (ModelController)UseCaseModulePlugin.getDefault().getProjectManager().getModelController(scenario.getProjectUID());
            displayString = modelController.isMainScenario(scenario) ? Messages.getString("DataViewLabelProvider.MainScenarioTitle") : modelController.getFullScenarioPrefix(scenario);
            displayString = StringUtil.removeNewlinesAndTrim((String)displayString);
            if (limited) {
                displayString = StringCondenser.cutOffEnd((String)displayString, (int)60);
            }
            text = displayString;
        } else if (element instanceof ActionStep) {
            ActionStep step = (ActionStep)((Object)element);
            ModelController modelController = (ModelController)UseCaseModulePlugin.getDefault().getProjectManager().getModelController(step.getProjectUID());
            displayString = String.valueOf(modelController.getFullScenarioPrefixPlusStepNumber(step)) + " " + step.getTitle().getDisplayStringRepresentation();
            displayString = StringUtil.removeNewlinesAndTrim((String)displayString);
            if (limited) {
                displayString = StringCondenser.cutOffEnd((String)displayString, (int)60);
            }
            text = displayString;
        } else {
            text = element instanceof UseCaseLinks ? Messages.getString("LinkLabelProvider.USE_CASES") : (element instanceof ActionStepLinks ? Messages.getString("LinkLabelProvider.ACTION_STEPS") : null);
        }
        return text;
    }

    public void addListener(ILabelProviderListener listener) {
    }

    public void dispose() {
    }

    public boolean isLabelProperty(Object element, String property) {
        return true;
    }

    public void removeListener(ILabelProviderListener listener) {
    }
}

