/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.usecasemodule.client.gui.linkviewcontribution;

import com.arcway.cockpit.client.base.interfaces.frame.propertychanges.IPropertyChanges;
import com.arcway.cockpit.client.base.interfaces.frame.propertychanges.IPropertyChangesListener;
import com.arcway.cockpit.client.base.interfaces.frame.propertychanges.IPropertyChangesProviderManager;
import com.arcway.cockpit.client.base.interfaces.frame.propertychanges.PropertyChanges;
import com.arcway.cockpit.frame.client.global.gui.views.linkview.IndirectLinksContainer;
import com.arcway.cockpit.frame.client.global.license.IClientFunctionLicenseType2;
import com.arcway.cockpit.frame.client.project.core.uniqueelements.IUniqueElement;
import com.arcway.cockpit.frame.client.project.modules.IModuleProjectAgent;
import com.arcway.cockpit.interFace.ICockpitProjectData;
import com.arcway.cockpit.modulelib2.client.core.project.IModelController;
import com.arcway.cockpit.modulelib2.client.gui.AbstractLinkContentProvider;
import com.arcway.cockpit.modulelib2.client.gui.IUserInterface;
import com.arcway.cockpit.modulelib2.client.messages.IModuleData;
import com.arcway.cockpit.usecasemodule.client.Messages;
import com.arcway.cockpit.usecasemodule.client.UseCaseModulePlugin;
import com.arcway.cockpit.usecasemodule.client.core.licensetypes.ClientFunctionLicenseTypeUCMLinkItems;
import com.arcway.cockpit.usecasemodule.client.gui.UCMTreeDataViewHierarchy;
import com.arcway.cockpit.usecasemodule.client.gui.linkviewcontribution.ActionStepLinks;
import com.arcway.cockpit.usecasemodule.client.gui.linkviewcontribution.UseCaseLinks;
import com.arcway.cockpit.usecasemodule.client.messages.ActionStep;
import com.arcway.cockpit.usecasemodule.client.messages.UseCase;
import com.arcway.cockpit.usecasemodule.shared.messages.UCMLinkTypeHelper_Shared;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import org.eclipse.jface.resource.ImageDescriptor;

public class LinkContentProvider
extends AbstractLinkContentProvider
implements IPropertyChangesListener {
    private static final UCMTreeDataViewHierarchy dataViewHierarchy = new UCMTreeDataViewHierarchy();
    private String currentProjectId = null;
    private IPropertyChangesProviderManager currentPropertyChangesProviderManager = null;
    private UseCaseLinks currentLinkViewContentUseCases = null;
    private ActionStepLinks currentLinkViewContentActionSteps = null;

    public LinkContentProvider(IUserInterface UI) {
        super(UI);
    }

    public boolean hasLinks(IUniqueElement element, Collection<IUniqueElement> containedElements, Collection<IUniqueElement> containerElements) {
        return LinkContentProvider.hasLinkedInformation((IUniqueElement)element, containedElements, containerElements, (IModelController)UseCaseModulePlugin.getDefault().getProjectManager().getModelController(element.getProjectUID()), Arrays.asList("UseCaseUniqueElement", "StepUniqueElement"));
    }

    public boolean hasChildren(Object element) {
        if (element instanceof UseCaseLinks || element instanceof ActionStepLinks) {
            return true;
        }
        if (element instanceof IModuleData) {
            String newProjectId = ((IModuleData)element).getProjectUID();
            return dataViewHierarchy.hasChildren(element, null, null, newProjectId);
        }
        return false;
    }

    private IModelController getModelController(String newProjectId) {
        if (this.currentProjectId == null || !this.currentProjectId.equals(newProjectId)) {
            IModuleProjectAgent projectAgent = UseCaseModulePlugin.getDefault().getProjectManager().getProjectAgent(newProjectId);
            this.currentPropertyChangesProviderManager = projectAgent.getPropertyChangesProviderManager();
            this.currentProjectId = newProjectId;
        }
        IModelController modelController = UseCaseModulePlugin.getDefault().getProjectManager().getModelController(this.currentProjectId);
        return modelController;
    }

    public Object[] getChildren(Object parentElement) {
        if (parentElement instanceof UseCaseLinks || parentElement instanceof ActionStepLinks) {
            return ((Collection)parentElement).toArray();
        }
        if (parentElement instanceof IModuleData) {
            String newProjectId = ((IModuleData)parentElement).getProjectUID();
            return dataViewHierarchy.getChildren(parentElement, null, null, newProjectId).toArray();
        }
        return new Object[0];
    }

    public String getTypeName() {
        return Messages.getString("LinkContentProvider.USE_CASE_MODULE");
    }

    public ImageDescriptor getIcon() {
        return UseCaseModulePlugin.getImageDescriptor("UseCase.gif");
    }

    public boolean mayHaveLinksToConstructionElements(ICockpitProjectData data) {
        return data instanceof UseCase || data instanceof ActionStep;
    }

    public boolean canDeleteInfoLink(ICockpitProjectData uniqueElement, ICockpitProjectData moduleDataItem) {
        String projectUID = uniqueElement.getProjectUID();
        IModelController modelController = UseCaseModulePlugin.getDefault().getProjectManager().getModelController(projectUID);
        if (moduleDataItem instanceof ActionStep) {
            return modelController.getModuleData(uniqueElement.getUID(), "StepUniqueElement").contains(moduleDataItem);
        }
        if (moduleDataItem instanceof UseCase) {
            return modelController.getModuleData(uniqueElement.getUID(), "UseCaseUniqueElement").contains(moduleDataItem);
        }
        return false;
    }

    public void deleteInfoLink(final ICockpitProjectData uniqueElement, final ICockpitProjectData moduleDataItem) {
        String linkTypeID;
        String projectUID = uniqueElement.getProjectUID();
        final IModelController modelController = UseCaseModulePlugin.getDefault().getProjectManager().getModelController(projectUID);
        if (moduleDataItem instanceof ActionStep) {
            linkTypeID = "StepUniqueElement";
        } else if (moduleDataItem instanceof UseCase) {
            linkTypeID = "UseCaseUniqueElement";
        } else {
            return;
        }
        modelController.executeTransaction(new Runnable(){

            @Override
            public void run() {
                modelController.deleteLink(uniqueElement.getUID(), moduleDataItem.getUID(), linkTypeID);
            }
        });
    }

    public Collection getUIDsOfLinkedUniqueElement(ICockpitProjectData data) {
        return null;
    }

    public void modelRefreshed(IPropertyChanges<?> changes, Class<?> clazz, String projectUID) {
        this.triggerLinkViewRefresh();
    }

    private void triggerLinkViewRefresh() {
        PropertyChanges changes;
        ArrayList<ArrayList> modifiedElements;
        if (this.currentLinkViewContentUseCases != null) {
            modifiedElements = new ArrayList<ArrayList>();
            modifiedElements.add(this.currentLinkViewContentUseCases);
            changes = new PropertyChanges(null, modifiedElements, null);
            this.currentPropertyChangesProviderManager.modelRefreshed((IPropertyChanges)changes, UseCaseLinks.class);
        }
        if (this.currentLinkViewContentActionSteps != null) {
            modifiedElements = new ArrayList();
            modifiedElements.add(this.currentLinkViewContentActionSteps);
            changes = new PropertyChanges(null, modifiedElements, null);
            this.currentPropertyChangesProviderManager.modelRefreshed((IPropertyChanges)changes, ActionStepLinks.class);
        }
    }

    public boolean isLinkedModuleDataLinkType(String linkTypeID) {
        return UCMLinkTypeHelper_Shared.getDefault().isUELinkType(linkTypeID);
    }

    protected List doGetLinkedModuleData(IUniqueElement element, Collection containedElements, Collection containerElements) {
        String newProjectId = element.getProjectUID();
        IModelController modelController = this.getModelController(newProjectId);
        IndirectLinksContainer indirectLinksContainerComponentsUseCase = new IndirectLinksContainer(true);
        IndirectLinksContainer indirectLinksContainerStructureUseCase = new IndirectLinksContainer(false);
        IndirectLinksContainer indirectLinksContainerComponentsActionStep = new IndirectLinksContainer(true);
        IndirectLinksContainer indirectLinksContainerStructureActionStep = new IndirectLinksContainer(false);
        ActionStepLinks actionStepLinks = new ActionStepLinks(modelController.getLinksForLinkableObject(element.getUID(), "StepUniqueElement"), this.currentProjectId);
        UseCaseLinks useCaseLinks = new UseCaseLinks(modelController.getLinksForLinkableObject(element.getUID(), "UseCaseUniqueElement"), this.currentProjectId);
        HashSet containedLinksUseCase = new HashSet();
        HashSet containedLinksActionStep = new HashSet();
        for (IUniqueElement ue : containedElements) {
            Collection links = modelController.getModuleData(ue.getUID(), "UseCaseUniqueElement");
            containedLinksUseCase.addAll(links);
            links = modelController.getModuleData(ue.getUID(), "StepUniqueElement");
            containedLinksActionStep.addAll(links);
        }
        if (!containedLinksUseCase.isEmpty()) {
            indirectLinksContainerComponentsUseCase.setLinkedModuleData(new ArrayList(containedLinksUseCase));
            useCaseLinks.add(indirectLinksContainerComponentsUseCase);
        }
        if (!containedLinksActionStep.isEmpty()) {
            indirectLinksContainerComponentsActionStep.setLinkedModuleData(new ArrayList(containedLinksActionStep));
            actionStepLinks.add(indirectLinksContainerComponentsActionStep);
        }
        HashSet containerLinksUseCase = new HashSet();
        HashSet containerLinksActionStep = new HashSet();
        for (IUniqueElement ue : containerElements) {
            Collection links = modelController.getModuleData(ue.getUID(), "UseCaseUniqueElement");
            containerLinksUseCase.addAll(links);
            links = modelController.getModuleData(ue.getUID(), "StepUniqueElement");
            containerLinksActionStep.addAll(links);
        }
        if (!containerLinksUseCase.isEmpty()) {
            indirectLinksContainerStructureUseCase.setLinkedModuleData(new ArrayList(containerLinksUseCase));
            useCaseLinks.add(indirectLinksContainerStructureUseCase);
        }
        if (!containerLinksActionStep.isEmpty()) {
            indirectLinksContainerStructureActionStep.setLinkedModuleData(new ArrayList(containerLinksActionStep));
            actionStepLinks.add(indirectLinksContainerStructureActionStep);
        }
        ArrayList<ArrayList> linkList = new ArrayList<ArrayList>();
        if (!useCaseLinks.isEmpty()) {
            linkList.add(useCaseLinks);
        }
        if (!actionStepLinks.isEmpty()) {
            linkList.add(actionStepLinks);
        }
        this.currentLinkViewContentUseCases = useCaseLinks;
        this.currentLinkViewContentActionSteps = actionStepLinks;
        return linkList;
    }

    public IClientFunctionLicenseType2 getRequiredLicenseTypeForUnlinking() {
        return ClientFunctionLicenseTypeUCMLinkItems.getInstance();
    }
}

