/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.usecasemodule.client.gui.dnd;

import com.arcway.cockpit.frame.client.global.license.IClientFunctionLicenseType2;
import com.arcway.cockpit.frame.client.lib.dataviews.dnd.DragSource;
import com.arcway.cockpit.frame.client.lib.dataviews.dnd.DropTarget;
import com.arcway.cockpit.frame.client.lib.dataviews.util.IActiveProjectProvider;
import com.arcway.cockpit.frame.client.lib.dataviews.util.IModuleProjectSwitchListener;
import com.arcway.cockpit.frame.client.lib.dataviews.util.IProjectAgentProvider;
import com.arcway.cockpit.frame.client.lib.dataviews.view.AbstractDataView;
import com.arcway.cockpit.interFace.ICockpitProjectData;
import com.arcway.cockpit.modulelib2.client.core.project.IModelController;
import com.arcway.cockpit.modulelib2.client.core.project.LockAccess;
import com.arcway.cockpit.modulelib2.client.gui.dnd.ModuleDataInternalTransfer;
import com.arcway.cockpit.modulelib2.client.messages.IModuleData;
import com.arcway.cockpit.usecasemodule.client.Messages;
import com.arcway.cockpit.usecasemodule.client.UseCaseModulePlugin;
import com.arcway.cockpit.usecasemodule.client.core.licensetypes.ClientFunctionLicenseTypeUCMModifyItems;
import com.arcway.cockpit.usecasemodule.client.core.project.ModelController;
import com.arcway.cockpit.usecasemodule.client.messages.ActionStep;
import com.arcway.cockpit.usecasemodule.client.messages.Extension;
import com.arcway.cockpit.usecasemodule.client.messages.Scenario;
import com.arcway.lib.UUIDGenerator;
import com.arcway.lib.eclipse.transfer.dnd.DropTargetParameters;
import com.arcway.lib.eclipse.transfer.dnd.IDragHandler;
import com.arcway.lib.eclipse.transfer.dnd.IDropHandler;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.dnd.DragSourceEvent;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.dnd.TransferData;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;

public class ReorderActionStepsDragNDropSupport
implements IModuleProjectSwitchListener,
IActiveProjectProvider {
    private static final String TRANSFER_TYPE = "ReorderActionSteps";
    private final Transfer transfer;
    protected IModelController modelController;
    protected AbstractDataView dataView;
    private static ReorderActionStepsTransferContent transferData = null;

    public ReorderActionStepsDragNDropSupport(IModelController modelController, AbstractDataView dataView) {
        this.dataView = dataView;
        this.modelController = modelController;
        this.transfer = new ModuleDataInternalTransfer(TRANSFER_TYPE);
    }

    public DragSource getDragSource() {
        return new DragSource(this.getDragOperations(), this.getTransfers(), this.getDragHandler(), (IClientFunctionLicenseType2)ClientFunctionLicenseTypeUCMModifyItems.getInstance(), (IProjectAgentProvider)UseCaseModulePlugin.getDefault().getProjectManager(), (IActiveProjectProvider)this);
    }

    public DropTarget getDropTarget() {
        return new DropTarget(this.getDropOperations(), this.getTransfers(), this.getDropHandler(), (IClientFunctionLicenseType2)ClientFunctionLicenseTypeUCMModifyItems.getInstance(), (IProjectAgentProvider)UseCaseModulePlugin.getDefault().getProjectManager(), (IActiveProjectProvider)this);
    }

    private int getDragOperations() {
        return 18;
    }

    private int getDropOperations() {
        return 18;
    }

    private Set<Transfer> getTransfers() {
        return Collections.singleton(this.transfer);
    }

    private IDragHandler getDragHandler() {
        IDragHandler dragHandler = new IDragHandler(){

            public boolean isDragPossible(DragSourceEvent event, ISelectionProvider selectionProvider) {
                IStructuredSelection selection;
                transferData = null;
                try {
                    selection = (IStructuredSelection)ReorderActionStepsDragNDropSupport.this.dataView.getSelection();
                }
                catch (ClassCastException e) {
                    return false;
                }
                if (selection.size() != 1) {
                    return false;
                }
                Object selectedItem = selection.iterator().next();
                if (!(selectedItem instanceof ActionStep)) {
                    return false;
                }
                ActionStep actionStep = (ActionStep)((Object)selectedItem);
                transferData = new ReorderActionStepsTransferContent(actionStep);
                return true;
            }

            public Object getDragData(DragSourceEvent event, ISelectionProvider selectionProvider) {
                return transferData.uid;
            }

            public void finishDrag(DragSourceEvent event, ISelectionProvider selectionProvider) {
                transferData = null;
            }
        };
        return dragHandler;
    }

    private IDropHandler getDropHandler() {
        IDropHandler dropHandler = new IDropHandler(){

            public boolean isDropPossible(DropTargetEvent event, int location, Control targetControl, DropTargetParameters parametersToChoose) {
                if (transferData == null) {
                    return false;
                }
                if (event.item != null && event.item.getData() != null && event.item.getData() instanceof ActionStep) {
                    TransferData dataType = ReorderActionStepsDragNDropSupport.this.extractRequiredDatatype(event.dataTypes);
                    if (dataType == null) {
                        return false;
                    }
                    parametersToChoose.requestedTransferType = dataType;
                    int operation = ReorderActionStepsDragNDropSupport.this.extractRequiredOperation(event.operations, event.detail);
                    if (operation == 0) {
                        return false;
                    }
                    parametersToChoose.requestedOperation = operation;
                    if (location != 1 && location != 2) {
                        return false;
                    }
                    ActionStep targetStep = (ActionStep)((Object)event.item.getData());
                    Scenario targetScenario = (Scenario)ReorderActionStepsDragNDropSupport.this.modelController.getParent((IModuleData)targetStep);
                    Scenario sourceScenario = (Scenario)ReorderActionStepsDragNDropSupport.this.modelController.getParent((IModuleData)transferData.actionStep);
                    if (transferData.actionStep.equals((Object)targetStep)) {
                        return false;
                    }
                    if (!sourceScenario.equals((Object)targetScenario)) {
                        return false;
                    }
                    parametersToChoose.requestedFeedbackTypes = 14;
                    return true;
                }
                return false;
            }

            public boolean performDrop(DropTargetEvent event, int location, Control targetControl) {
                ActionStep target = (ActionStep)((Object)event.item.getData());
                ReorderActionStepsDragNDropSupport.this.reorderActionStep(transferData.actionStep, target, location, targetControl.getShell());
                return true;
            }
        };
        return dropHandler;
    }

    private int extractRequiredOperation(int operations, int requestedOperation) {
        if (requestedOperation == 16) {
            if ((operations & 0x10) != 0 || (operations & 2) != 0) {
                return 2;
            }
            return 0;
        }
        if ((requestedOperation & 2) != 0) {
            return 2;
        }
        return 0;
    }

    private TransferData extractRequiredDatatype(TransferData[] dataTypes) {
        TransferData[] transferDataArray = dataTypes;
        int n = dataTypes.length;
        int n2 = 0;
        while (n2 < n) {
            TransferData dataType = transferDataArray[n2];
            if (this.transfer.isSupportedType(dataType)) {
                return dataType;
            }
            ++n2;
        }
        return null;
    }

    private void reorderActionStep(final ActionStep sourceStep, final ActionStep targetStep, int location, Shell shell) {
        assert (sourceStep != null);
        assert (targetStep != null);
        final ModelController modelCtrl = (ModelController)this.modelController;
        switch (location) {
            case 1: {
                if (!modelCtrl.getNextStep(sourceStep).equals((Object)targetStep)) break;
                return;
            }
            case 2: {
                if (!modelCtrl.getPreviousStep(sourceStep).equals((Object)targetStep)) break;
                return;
            }
            default: {
                return;
            }
        }
        if (!modelCtrl.getPermissionMgr().mayEditItemStructurally((IModuleData)sourceStep, (IModuleData)modelCtrl.getUseCase(sourceStep))) {
            MessageDialog.openInformation((Shell)shell, (String)Messages.getString("ReorderActionStepDragNDropSupport.NoPermissionDialogue.Title"), (String)Messages.getString("ReorderActionStepDragNDropSupport.NoPermissionDialogue.Message"));
            return;
        }
        LockAccess lock = modelCtrl.getLockMgr().acquireEditLock((ICockpitProjectData)modelCtrl.getParent((IModuleData)sourceStep));
        if (!lock.hasLock()) {
            return;
        }
        final int dropLocation = location;
        modelCtrl.executeTransaction(new Runnable(){

            @Override
            public void run() {
                ActionStep targetPredecessor = (ActionStep)((Object)modelCtrl.getLinkableObjects((IModuleData)targetStep, "StepPreviousStep").iterator().next());
                ActionStep targetSuccessor = (ActionStep)((Object)modelCtrl.getModuleData((IModuleData)targetStep, "StepPreviousStep").iterator().next());
                if (!$assertionsDisabled && targetPredecessor == null) {
                    throw new AssertionError();
                }
                if (!$assertionsDisabled && targetSuccessor == null) {
                    throw new AssertionError();
                }
                ActionStep sourcePredecessor = (ActionStep)((Object)modelCtrl.getLinkableObjects((IModuleData)sourceStep, "StepPreviousStep").iterator().next());
                ActionStep sourceSuccessor = (ActionStep)((Object)modelCtrl.getModuleData((IModuleData)sourceStep, "StepPreviousStep").iterator().next());
                if (!$assertionsDisabled && sourcePredecessor == null) {
                    throw new AssertionError();
                }
                if (!$assertionsDisabled && sourceSuccessor == null) {
                    throw new AssertionError();
                }
                modelCtrl.deleteLink(sourcePredecessor.getUID(), sourceStep.getUID(), "StepPreviousStep");
                modelCtrl.deleteLink(sourceStep.getUID(), sourceSuccessor.getUID(), "StepPreviousStep");
                modelCtrl.createLink(sourcePredecessor.getUID(), (IModuleData)sourceSuccessor, "StepPreviousStep");
                ActionStep newPredecessor = null;
                ActionStep newSuccessor = null;
                switch (dropLocation) {
                    case 1: {
                        newPredecessor = targetPredecessor;
                        newSuccessor = targetStep;
                        break;
                    }
                    case 2: {
                        newPredecessor = targetStep;
                        newSuccessor = targetSuccessor;
                        break;
                    }
                    default: {
                        if (!$assertionsDisabled) {
                            throw new AssertionError();
                        }
                        break;
                    }
                }
                if (!$assertionsDisabled && newPredecessor == null) {
                    throw new AssertionError();
                }
                if (!$assertionsDisabled && newSuccessor == null) {
                    throw new AssertionError();
                }
                modelCtrl.deleteLink(newPredecessor.getUID(), newSuccessor.getUID(), "StepPreviousStep");
                modelCtrl.createLink(newPredecessor.getUID(), (IModuleData)sourceStep, "StepPreviousStep");
                modelCtrl.createLink(sourceStep.getUID(), (IModuleData)newSuccessor, "StepPreviousStep");
                for (Scenario beginningScenario : ((ModelController)ReorderActionStepsDragNDropSupport.this.modelController).getModuleData(sourceStep.getUID(), "ScenarioBeginningStep")) {
                    modelCtrl.deleteLink(sourceStep.getUID(), beginningScenario.getUID(), "ScenarioBeginningStep");
                    modelCtrl.createLink(sourceSuccessor.getUID(), (IModuleData)beginningScenario, "ScenarioBeginningStep");
                }
                for (Scenario endingScenario : ((ModelController)ReorderActionStepsDragNDropSupport.this.modelController).getModuleData(sourceStep.getUID(), "ScenarioFinalStep")) {
                    modelCtrl.deleteLink(sourceStep.getUID(), endingScenario.getUID(), "ScenarioFinalStep");
                    modelCtrl.createLink(sourceSuccessor.getUID(), (IModuleData)endingScenario, "ScenarioFinalStep");
                    if (sourceSuccessor.getStepType().getValue() != 1) continue;
                    endingScenario.getSuccess().setValue(0);
                }
                for (Extension beginningExtension : ((ModelController)ReorderActionStepsDragNDropSupport.this.modelController).getModuleData(sourceStep.getUID(), "ExtensionBeginningStep")) {
                    modelCtrl.deleteLink(sourceStep.getUID(), beginningExtension.getUID(), "ExtensionBeginningStep");
                    modelCtrl.createLink(sourceSuccessor.getUID(), (IModuleData)beginningExtension, "ExtensionBeginningStep");
                }
                for (Extension endingExtension : ((ModelController)ReorderActionStepsDragNDropSupport.this.modelController).getModuleData(sourceStep.getUID(), "ExtensionFinalStep")) {
                    modelCtrl.deleteLink(sourceStep.getUID(), endingExtension.getUID(), "ExtensionFinalStep");
                    modelCtrl.createLink(sourceSuccessor.getUID(), (IModuleData)endingExtension, "ExtensionFinalStep");
                    if (sourceSuccessor.getStepType().getValue() != 1) continue;
                    endingExtension.getSuccess().setValue(0);
                }
                if (newSuccessor.getStepType().getValue() != 1) {
                    Collection newPredBeginScenarios = ReorderActionStepsDragNDropSupport.this.modelController.getModuleData(newPredecessor.getUID(), "ScenarioBeginningStep");
                    Collection newSuccEndScenarios = ReorderActionStepsDragNDropSupport.this.modelController.getModuleData(newSuccessor.getUID(), "ScenarioFinalStep");
                    newPredBeginScenarios.retainAll(newSuccEndScenarios);
                    for (Scenario scenario : newPredBeginScenarios) {
                        modelCtrl.deleteLink(newSuccessor.getUID(), scenario.getUID(), "ScenarioFinalStep");
                        modelCtrl.createLink(sourceStep.getUID(), (IModuleData)scenario, "ScenarioFinalStep");
                    }
                    Collection newPredBeginExtensions = ReorderActionStepsDragNDropSupport.this.modelController.getModuleData(newPredecessor.getUID(), "ExtensionBeginningStep");
                    Collection newSuccEndExtensions = ReorderActionStepsDragNDropSupport.this.modelController.getModuleData(newSuccessor.getUID(), "ExtensionFinalStep");
                    newPredBeginExtensions.retainAll(newSuccEndExtensions);
                    for (Extension extension : newPredBeginExtensions) {
                        modelCtrl.deleteLink(newSuccessor.getUID(), extension.getUID(), "ExtensionFinalStep");
                        modelCtrl.createLink(sourceStep.getUID(), (IModuleData)extension, "ExtensionFinalStep");
                    }
                }
            }
        });
        modelCtrl.recalculateScenarioOrder((Scenario)modelCtrl.getParent((IModuleData)sourceStep));
    }

    public void projectSwitched(String projectUID) {
        this.modelController = UseCaseModulePlugin.getDefault().getProjectManager().getModelController(projectUID);
    }

    public String getActiveProject() {
        return this.modelController != null ? this.modelController.getProjectUID() : null;
    }

    private class ReorderActionStepsTransferContent {
        public String uid;
        public ActionStep actionStep;

        public ReorderActionStepsTransferContent(ActionStep actionStep) {
            this.actionStep = actionStep;
            this.uid = UUIDGenerator.getUniqueID();
        }
    }
}

