/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.usecasemodule.client.gui.dialogues;

import com.arcway.cockpit.usecasemodule.client.Messages;
import com.arcway.cockpit.usecasemodule.client.gui.dialogues.GoalWrapper;
import com.arcway.cockpit.usecasemodule.client.messages.Actor;
import com.arcway.cockpit.usecasemodule.client.messages.Goal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.ListIterator;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class SelectGoalDialog
extends TitleAreaDialog
implements ModifyListener {
    private final List actors;
    private final String[] actorStrings;
    private GoalWrapper selectedGoal;
    private Text goalText;
    private Combo actorCombo;
    private final String message;
    private final String title;
    private final String projectUID;
    private static final String ERR_MSG_EMPTY_ACTOR = Messages.getString("SelectGoalDialog.ErrNoActor");

    public SelectGoalDialog(Shell parentShell, Collection actors, Collection existingActors, String title, String message, String projectUID) {
        super(parentShell);
        this.actors = new ArrayList(actors);
        this.actors.removeAll(existingActors);
        Collections.sort(this.actors, new Comparator(){

            public int compare(Object o1, Object o2) {
                Actor a1 = (Actor)((Object)o1);
                Actor a2 = (Actor)((Object)o2);
                return a1.getDisplayRepresentation().compareTo(a2.getDisplayRepresentation());
            }
        });
        this.actorStrings = new String[this.actors.size()];
        ListIterator i = this.actors.listIterator();
        while (i.hasNext()) {
            Actor actor = (Actor)((Object)i.next());
            this.actorStrings[i.nextIndex() - 1] = actor.getDisplayRepresentation();
        }
        this.message = message;
        this.title = title;
        this.projectUID = projectUID;
    }

    protected Control createDialogArea(Composite parent) {
        this.setMessage(this.message);
        this.setTitle(this.title);
        Composite dialogComposite = new Composite(parent, 0);
        dialogComposite.setLayoutData((Object)new GridData(4, 4, true, true));
        dialogComposite.setLayout((Layout)new GridLayout(3, true));
        Label actorLabel = new Label(dialogComposite, 0);
        actorLabel.setText(Messages.getString("SelectGoalDialog.ActorLabel"));
        actorLabel.setLayoutData((Object)new GridData(4, 0, true, false));
        Label goalLabel = new Label(dialogComposite, 0);
        goalLabel.setText(Messages.getString("SelectGoalDialog.GoalLabel"));
        GridData gridData = new GridData(4, 0, true, false);
        gridData.horizontalSpan = 2;
        goalLabel.setLayoutData((Object)gridData);
        this.actorCombo = new Combo(dialogComposite, 12);
        this.actorCombo.setItems(this.actorStrings);
        this.actorCombo.setLayoutData((Object)new GridData(4, 0, true, false));
        this.actorCombo.addModifyListener((ModifyListener)this);
        this.goalText = new Text(dialogComposite, 2052);
        gridData = new GridData(4, 0, true, false);
        gridData.horizontalSpan = 2;
        this.goalText.setLayoutData((Object)gridData);
        this.goalText.addModifyListener((ModifyListener)this);
        return dialogComposite;
    }

    protected Control createButtonBar(Composite parent) {
        Control control = super.createButtonBar(parent);
        this.getButton(0).setEnabled(false);
        return control;
    }

    protected void okPressed() {
        int selectionIndex = this.actorCombo.getSelectionIndex();
        Actor actor = (Actor)((Object)this.actors.get(selectionIndex));
        Goal goal = new Goal();
        goal.setProjectUID(this.projectUID);
        goal.getDescription().setValue(this.goalText.getText());
        this.selectedGoal = new GoalWrapper(actor, goal);
        super.okPressed();
    }

    public void modifyText(ModifyEvent e) {
        this.check(true);
    }

    private void check(boolean showErrMsg) {
        String errMsg = null;
        if (this.actorCombo.getSelectionIndex() < 0) {
            errMsg = ERR_MSG_EMPTY_ACTOR;
        }
        this.getButton(0).setEnabled(errMsg == null);
        if (errMsg != null && showErrMsg) {
            this.setMessage(errMsg, 3);
        } else {
            this.setMessage(this.message);
        }
    }

    public GoalWrapper getSelectedGoal() {
        return this.selectedGoal;
    }
}

