/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.usecasemodule.client.gui.dialogues;

import com.arcway.cockpit.usecasemodule.client.Messages;
import com.arcway.cockpit.usecasemodule.client.UseCaseModulePlugin;
import com.arcway.cockpit.usecasemodule.client.core.project.ModelController;
import com.arcway.cockpit.usecasemodule.client.gui.dialogues.ActionStepInEditDialogue;
import com.arcway.cockpit.usecasemodule.client.gui.dialogues.ExtensionWrapper;
import com.arcway.cockpit.usecasemodule.client.messages.ActionStep;
import com.arcway.cockpit.usecasemodule.client.messages.Extension;
import com.arcway.cockpit.usecasemodule.client.messages.Scenario;
import com.arcway.cockpit.usecasemodule.client.messages.UseCase;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public class SelectExtensionDialog
extends TitleAreaDialog
implements ModifyListener {
    private final List<UseCase> sortedUseCases;
    private final String[] sortedUseCaseStrings;
    private final List<ActionStepInEditDialogue> actionSteps;
    private final String[] beginningStepStrings;
    private final Scenario scenario;
    private static final int JOIN_BEFORE = 0;
    private static final int JOIN_AFTER = 1;
    private static final int JOIN_END_SUCCESS = 2;
    private static final int JOIN_END_FAILURE = 3;
    private static final String JOIN_BEFORE_MSG = Messages.getString("SelectExtensionDialog.JoinBefore");
    private static final String JOIN_AFTER_MSG = Messages.getString("SelectExtensionDialog.JoinAfter");
    private static final String JOIN_END_SUCCESS_MSG = Messages.getString("SelectExtensionDialog.EndWithSuccess");
    private static final String JOIN_END_FAILURE_MSG = Messages.getString("SelectExtensionDialog.EndWithFailure");
    private static final String[] JOIN_MSGS = new String[]{JOIN_BEFORE_MSG, JOIN_AFTER_MSG, JOIN_END_SUCCESS_MSG, JOIN_END_FAILURE_MSG};
    private ExtensionWrapper selectedExtension;
    private Combo useCaseCombo;
    private Combo beginningStepCombo;
    private Combo finalStepCombo;
    private final Collection<ExtensionWrapper> existingExtensions;
    private final String message;
    private final String title;
    private static final String ERR_MSG = Messages.getString("SelectExtensionDialog.ErrMsg");

    public SelectExtensionDialog(Shell parentShell, Collection<UseCase> useCases, List<ActionStepInEditDialogue> actionSteps, Scenario scenario, Collection<ExtensionWrapper> existingExtensions, String title, String message) {
        super(parentShell);
        this.sortedUseCases = new ArrayList<UseCase>(useCases);
        Collections.sort(this.sortedUseCases, new Comparator<UseCase>(){

            @Override
            public int compare(UseCase o1, UseCase o2) {
                return o1.getDisplayRepresentation().compareTo(o2.getDisplayRepresentation());
            }
        });
        this.sortedUseCaseStrings = new String[useCases.size()];
        int ucIndex = 0;
        for (UseCase useCase : this.sortedUseCases) {
            this.sortedUseCaseStrings[ucIndex] = useCase.getDisplayRepresentation();
            ++ucIndex;
        }
        this.actionSteps = actionSteps;
        this.beginningStepStrings = new String[actionSteps.size() - 1];
        ModelController modelController = null;
        int asIndex = -1;
        for (ActionStepInEditDialogue actionStep : actionSteps) {
            if (++asIndex == 0) continue;
            if (modelController == null) {
                modelController = (ModelController)UseCaseModulePlugin.getDefault().getProjectManager().getModelController(actionStep.getActionStep().getProjectUID());
            }
            String string = asIndex == actionSteps.size() - 1 ? Messages.getString("ActionStep.END") : String.valueOf(actionStep.getActorAndGoal().actor.getDisplayRepresentation()) + " " + actionStep.getTitle();
            this.beginningStepStrings[asIndex - 1] = string;
        }
        this.existingExtensions = existingExtensions;
        this.message = message;
        this.title = title;
        this.scenario = scenario;
    }

    protected Control createDialogArea(Composite parent) {
        this.setMessage(this.message);
        this.setTitle(this.title);
        Composite dialogComposite = new Composite(parent, 0);
        dialogComposite.setLayoutData((Object)new GridData(4, 4, true, true));
        dialogComposite.setLayout((Layout)new GridLayout(3, false));
        Label useCaseLabel = new Label(dialogComposite, 0);
        useCaseLabel.setText(Messages.getString("SelectExtensionDialog.UseCaseLabelText"));
        Label beginningStepLabel = new Label(dialogComposite, 0);
        beginningStepLabel.setText(Messages.getString("SelectExtensionDialog.BeginningStepLabelText"));
        Label finalStepLabel = new Label(dialogComposite, 0);
        finalStepLabel.setText(Messages.getString("SelectExtensionDialog.FinalStepLabelText"));
        this.useCaseCombo = new Combo(dialogComposite, 12);
        this.useCaseCombo.setItems(this.sortedUseCaseStrings);
        this.useCaseCombo.setLayoutData((Object)new GridData(4, 128, true, false));
        this.beginningStepCombo = new Combo(dialogComposite, 12);
        this.beginningStepCombo.setItems(this.beginningStepStrings);
        this.beginningStepCombo.setLayoutData((Object)new GridData(4, 128, true, false));
        this.finalStepCombo = new Combo(dialogComposite, 12);
        this.finalStepCombo.setItems(JOIN_MSGS);
        this.finalStepCombo.setLayoutData((Object)new GridData(4, 128, true, false));
        this.initSelection();
        this.useCaseCombo.addModifyListener((ModifyListener)this);
        this.beginningStepCombo.addModifyListener((ModifyListener)this);
        return dialogComposite;
    }

    protected void okPressed() {
        ActionStepInEditDialogue selectedFinalStep;
        int joinType = 2;
        UseCase selectedUseCase = this.sortedUseCases.get(this.useCaseCombo.getSelectionIndex());
        int beginningStepIndex = this.beginningStepCombo.getSelectionIndex();
        ActionStepInEditDialogue selectedBeginningStep = this.actionSteps.get(beginningStepIndex + 1);
        switch (this.finalStepCombo.getSelectionIndex()) {
            case 0: {
                selectedFinalStep = selectedBeginningStep;
                if (beginningStepIndex != this.actionSteps.size() - 2) break;
                joinType = 0;
                break;
            }
            case 1: {
                if (beginningStepIndex >= this.actionSteps.size() - 3) {
                    joinType = 0;
                    selectedFinalStep = this.actionSteps.get(this.actionSteps.size() - 1);
                    break;
                }
                selectedFinalStep = this.actionSteps.get(beginningStepIndex + 2);
                break;
            }
            case 2: {
                selectedFinalStep = this.actionSteps.get(this.actionSteps.size() - 1);
                joinType = 0;
                break;
            }
            default: {
                selectedFinalStep = this.actionSteps.get(this.actionSteps.size() - 1);
                joinType = 1;
            }
        }
        this.selectedExtension = new ExtensionWrapper(selectedUseCase, selectedBeginningStep.getActionStep(), selectedFinalStep.getActionStep(), joinType, new Extension(), this.scenario);
        super.okPressed();
    }

    public ExtensionWrapper getSelectedExtension() {
        return this.selectedExtension;
    }

    private void check() {
        UseCase useCase = this.sortedUseCases.get(this.useCaseCombo.getSelectionIndex());
        ActionStep forkingStep = this.actionSteps.get(this.beginningStepCombo.getSelectionIndex() + 1).getActionStep();
        for (ExtensionWrapper extension : this.existingExtensions) {
            if (!extension.useCase.equals((Object)useCase) || !extension.forkingStep.equals((Object)forkingStep)) continue;
            this.setMessage(ERR_MSG, 3);
            this.getButton(0).setEnabled(false);
            return;
        }
        this.setMessage(this.message);
        this.getButton(0).setEnabled(true);
    }

    public void modifyText(ModifyEvent e) {
        this.check();
    }

    private void initSelection() {
        this.finalStepCombo.select(0);
        int ucIndex = 0;
        for (UseCase useCase : this.sortedUseCases) {
            int asIndex = -1;
            for (ActionStepInEditDialogue step : this.actionSteps) {
                if (++asIndex == 0 || asIndex == this.actionSteps.size() - 1) continue;
                boolean isInUse = false;
                for (ExtensionWrapper extension : this.existingExtensions) {
                    if (useCase.equals((Object)extension.useCase) && step.getActionStep().equals((Object)extension.forkingStep)) continue;
                    isInUse = true;
                    break;
                }
                if (isInUse) continue;
                this.useCaseCombo.select(ucIndex);
                this.beginningStepCombo.select(asIndex - 1);
                return;
            }
            ++ucIndex;
        }
    }
}

