/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.usecasemodule.client.gui.dialogues;

import com.arcway.cockpit.usecasemodule.client.Messages;
import com.arcway.cockpit.usecasemodule.client.messages.Category;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.ListIterator;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public class SelectCategoryDialog
extends TitleAreaDialog {
    private final List categories;
    private final String[] categoryNames;
    private final String message;
    private final String title;
    private Category selectedCategory;

    public SelectCategoryDialog(Shell parentShell, Collection categories, String title, String message) {
        super(parentShell);
        assert (categories != null) : "categories must not be null";
        assert (categories.size() > 0);
        assert (title != null) : "title must not be null";
        assert (message != null) : "message must not be null";
        this.categories = new ArrayList(categories);
        Collections.sort(this.categories, new Comparator(){

            public int compare(Object o1, Object o2) {
                Category c1 = (Category)((Object)o1);
                Category c2 = (Category)((Object)o2);
                return c1.getName().getDisplayStringRepresentation().compareTo(c2.getName().getDisplayStringRepresentation());
            }
        });
        this.categoryNames = new String[this.categories.size()];
        ListIterator i = this.categories.listIterator();
        while (i.hasNext()) {
            Category element = (Category)((Object)i.next());
            this.categoryNames[i.previousIndex()] = element.getName().getDisplayStringRepresentation();
        }
        this.title = title;
        this.message = message;
    }

    protected Control createDialogArea(Composite parent) {
        this.setTitle(this.title);
        this.setMessage(this.message);
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout());
        Label label = new Label(composite, 0);
        label.setLayoutData((Object)new GridData(4, 4, true, true));
        label.setText(Messages.getString("SelectCategoryDialog.Label"));
        final Combo combo = new Combo(composite, 12);
        combo.setLayoutData((Object)new GridData(4, 4, true, true));
        combo.setItems(this.categoryNames);
        combo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SelectCategoryDialog.this.selectedCategory = (Category)((Object)SelectCategoryDialog.this.categories.get(combo.getSelectionIndex()));
            }
        });
        combo.select(0);
        this.selectedCategory = (Category)((Object)this.categories.get(0));
        return combo;
    }

    public Category getSelectedCategory() {
        return this.selectedCategory;
    }
}

