/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.usecasemodule.client.gui.dialogues;

import com.arcway.cockpit.interFace.ICockpitProjectData;
import com.arcway.cockpit.modulelib2.client.core.project.AbstractLockManager;
import com.arcway.cockpit.modulelib2.client.core.project.IModelController;
import com.arcway.cockpit.modulelib2.client.core.project.LockAccess;
import com.arcway.cockpit.modulelib2.client.gui.editdialogs.IEditDialogErrorCallback;
import com.arcway.cockpit.modulelib2.client.gui.editdialogs.ModuleDataEditPropertyAdapter;
import com.arcway.cockpit.modulelib2.client.messages.IModuleData;
import com.arcway.cockpit.usecasemodule.client.Messages;
import com.arcway.cockpit.usecasemodule.client.UseCaseModulePlugin;
import com.arcway.cockpit.usecasemodule.client.core.project.ModelController;
import com.arcway.cockpit.usecasemodule.client.core.project.PermissionMgr;
import com.arcway.cockpit.usecasemodule.client.gui.dialogues.ActionStepInEditDialogue;
import com.arcway.cockpit.usecasemodule.client.gui.dialogues.EditUseCaseAdapter;
import com.arcway.cockpit.usecasemodule.client.gui.dialogues.ExtensionTableContentProvider;
import com.arcway.cockpit.usecasemodule.client.gui.dialogues.ExtensionTableViewer;
import com.arcway.cockpit.usecasemodule.client.gui.dialogues.ExtensionWrapper;
import com.arcway.cockpit.usecasemodule.client.gui.dialogues.GoalWrapper;
import com.arcway.cockpit.usecasemodule.client.gui.dialogues.SelectExtensionDialog;
import com.arcway.cockpit.usecasemodule.client.messages.ActionStep;
import com.arcway.cockpit.usecasemodule.client.messages.Category;
import com.arcway.cockpit.usecasemodule.client.messages.Extension;
import com.arcway.cockpit.usecasemodule.client.messages.Scenario;
import com.arcway.cockpit.usecasemodule.client.messages.UseCase;
import com.arcway.cockpit.usecasemodule.client.messages.description.ScenarioDescription;
import com.arcway.repository.clientadapter.interFace.EXCockpitLockDenied;
import de.plans.lib.util.collections.ArrayUtil;
import de.plans.lib.util.gui.elements.IUIElement;
import de.plans.lib.util.gui.elements.UIETextField;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.swt.widgets.Text;

public class ScenarioWidgetCreator
implements ModifyListener,
IEditDialogErrorCallback {
    private Scenario scenario;
    private final IModelController modelController;
    private IEditDialogErrorCallback callback = IEditDialogErrorCallback.DUMMY;
    private UIETextField idField;
    private UIETextField goalField;
    private UIETextField preconditionField;
    private UIETextField postconditionSuccesField;
    private UIETextField postConditionFailureField;
    private UIETextField triggerField;
    private List<IUIElement> allCurrentFieldWidgets;
    private Collection<IUIElement> currentFieldWidgetsOfSteps = new HashSet<IUIElement>();
    private static final String ERR_MSG_NON_UNIQUE = Messages.getString("ScenarioWidgetCreator.ID_ALREADDY_IN_USE");
    private List<ActionStepInEditDialogue> actionSteps;
    private List<ActionStep> originalActionSteps;
    private final ActionStep finalStep;
    private List<ExtensionWrapper> originalExtensions;
    private final List<GoalWrapper> allGoalWrappers;
    private final Map<ActionStep, GoalWrapper> originalMapping_step_actor;
    private String oldID;
    private final boolean isNew;
    private TabFolder tabFolder;
    private TabItem stepTab;
    private Composite stepGroup;
    private Composite stepComposite;
    private Group extensionGroup;
    private ScrolledComposite scComp;
    private Control idFieldControl;
    private Label startStepLabel;
    private static final String[] JOINING_STEPS = new String[]{Messages.getString("ScenarioWidgetCreator.JoiningStep.Before"), Messages.getString("ScenarioWidgetCreator.JoiningStep.After"), Messages.getString("ScenarioWidgetCreator.JoiningStep.EndSuccess"), Messages.getString("ScenarioWidgetCreator.JoiningStep.EndFailure")};
    public static final int BEFORE_FORKING = 0;
    public static final int AFTER_FORKING = 1;
    public static final int END_SUCCESS = 2;
    public static final int END_FAILURE = 3;
    private int[] currentJoiningPossibilities;
    private static final int[] joiningValuesNormal;
    private static final int[] joiningValuesForLastRealStep;
    private static final int[] joiningValuesForEnd;
    private Combo joiningStepDropDown;
    private Combo forkingStepDropDown;
    private boolean isMainScenario;
    private Scenario parentScenario;
    private ActionStep extensionStartingStep;
    private GoalWrapper mainActor;
    private final ModifyListener checkListener;
    private static Image plusImage;
    private static Image minusImage;
    private ExtensionTableContentProvider extensionTableContentProvider;
    private boolean initialized;
    private final PermissionMgr permissionMgr;
    private EditUseCaseAdapter adapter;
    private boolean sendModifyEvents;
    private boolean stepsEnabled;
    private Button endPlusButton;
    private LockAccess editLock;
    private final IModuleData permissionParent;
    private boolean generalPartCreated;
    private boolean isNewScenario;
    private LockAccess idLock;
    private boolean isExclusiveProjectLockSet;

    static {
        int[] nArray = new int[4];
        nArray[1] = 1;
        nArray[2] = 2;
        nArray[3] = 3;
        joiningValuesNormal = nArray;
        int[] nArray2 = new int[3];
        nArray2[1] = 2;
        nArray2[2] = 3;
        joiningValuesForLastRealStep = nArray2;
        joiningValuesForEnd = new int[]{2, 3};
        plusImage = UseCaseModulePlugin.getDefault().getImageDescriptorRegistry().get(UseCaseModulePlugin.getImageDescriptor("NewActionStep.gif"));
        minusImage = UseCaseModulePlugin.getDefault().getImageDescriptorRegistry().get(UseCaseModulePlugin.getImageDescriptor("delete.gif"));
    }

    public ScenarioWidgetCreator(Scenario scenario, boolean isMainScenario, IModelController model, List<ActionStep> actionSteps, boolean isNew, PermissionMgr permissionManager, Category category, UseCase useCase, List<GoalWrapper> goalWrappers, Map<ActionStep, GoalWrapper> mapStep_GoalWrapper) {
        int[] nArray = new int[4];
        nArray[1] = 1;
        nArray[2] = 2;
        nArray[3] = 3;
        this.currentJoiningPossibilities = nArray;
        this.checkListener = new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                ScenarioWidgetCreator.this.check();
                if (ScenarioWidgetCreator.this.initialized) {
                    ScenarioWidgetCreator.this.setDirty();
                }
            }
        };
        this.initialized = false;
        this.sendModifyEvents = true;
        this.stepsEnabled = true;
        this.generalPartCreated = false;
        this.isExclusiveProjectLockSet = false;
        assert (scenario != null) : "scenario must not be null";
        assert (model != null) : "model must not be null";
        assert (actionSteps != null) : "actionSteps must not be null";
        this.modelController = model;
        this.permissionMgr = permissionManager;
        this.scenario = scenario;
        this.originalActionSteps = new ArrayList<ActionStep>(actionSteps);
        this.finalStep = actionSteps.get(actionSteps.size() - 1);
        this.allGoalWrappers = goalWrappers;
        this.originalMapping_step_actor = mapStep_GoalWrapper;
        this.isNew = isNew;
        this.isMainScenario = isMainScenario;
        this.permissionParent = useCase != null ? useCase : category;
    }

    public ScenarioWidgetCreator(Scenario scenario, IModelController model, List<ActionStep> actionSteps, boolean isNew, PermissionMgr permissionManager, Category category, UseCase useCase, List<GoalWrapper> goalWrappers, Map<ActionStep, GoalWrapper> mapStep_GoalWrapper, EditUseCaseAdapter adapter) {
        this(scenario, true, model, actionSteps, isNew, permissionManager, category, useCase, goalWrappers, mapStep_GoalWrapper);
        this.adapter = adapter;
    }

    public Composite createControl(Composite parent, ModuleDataEditPropertyAdapter propertyAdapter) {
        Composite composite = new Composite(parent, 0);
        GridData gd = new GridData(1808);
        composite.setLayoutData((Object)gd);
        GridLayout gridLayout = new GridLayout(1, false);
        composite.setLayout((Layout)gridLayout);
        this.tabFolder = new TabFolder(composite, 0);
        this.tabFolder.setLayoutData((Object)new GridData(1808));
        this.tabFolder.setLayout((Layout)new GridLayout());
        if (this.adapter == null) {
            TabItem generalItem = new TabItem(this.tabFolder, 0);
            generalItem.setText(Messages.getString("ScenarioWidgetCreator.TabTitle.ScenarioAttributes"));
            Composite genComp = new Composite((Composite)this.tabFolder, 0);
            genComp.setLayoutData((Object)new GridData(1808));
            genComp.setLayout((Layout)new GridLayout());
            propertyAdapter.createCategoryWidget(genComp, 2, (IModuleData)this.scenario);
            if (!this.isMainScenario) {
                this.createExtensionPart(genComp);
                this.createGeneralPart(genComp);
            }
            generalItem.setControl((Control)genComp);
        }
        this.stepGroup = new Group((Composite)this.tabFolder, 0);
        this.stepTab = new TabItem(this.tabFolder, 0);
        this.stepTab.setText(Messages.getString("ScenarioWidgetCreator.TabTitle.ActionSteps"));
        this.stepTab.setControl((Control)this.stepGroup);
        this.stepGroup.setLayout((Layout)new GridLayout());
        GridDataFactory.fillDefaults().grab(true, true).align(4, 4).hint(600, 200).applyTo((Control)this.stepGroup);
        this.createStepPart(this.stepGroup, this.tabFolder);
        if (this.actionSteps.size() > 2) {
            TabItem extensionItem = new TabItem(this.tabFolder, 0);
            extensionItem.setText(Messages.getString("ScenarioWidgetCreator.ExtensionTabTitle"));
            this.extensionGroup = new Group((Composite)this.tabFolder, 0);
            extensionItem.setControl((Control)this.extensionGroup);
            this.extensionGroup.setLayout((Layout)new GridLayout(2, false));
            GridData gridData = new GridData(4, 4, true, true);
            this.extensionGroup.setLayoutData((Object)gridData);
            this.createUseCaseExtensionPart((Composite)this.extensionGroup);
        }
        this.initializeUI();
        return composite;
    }

    private void createUseCaseExtensionPart(Composite extensionComposite) {
        final ExtensionTableViewer tableViewer = new ExtensionTableViewer(extensionComposite, this, 65538);
        tableViewer.getTable().setLayoutData((Object)new GridData(4, 4, true, true));
        this.originalExtensions = new ArrayList<ExtensionWrapper>();
        Collection modelExtensions = ((ModelController)this.modelController).getAllExtensions(this.scenario);
        for (Extension modelExtension : modelExtensions) {
            ActionStep forkingStep = (ActionStep)((Object)this.modelController.getLinkableObjects((IModuleData)modelExtension, "ExtensionBeginningStep").iterator().next());
            ActionStep joiningStep = (ActionStep)((Object)this.modelController.getLinkableObjects((IModuleData)modelExtension, "ExtensionFinalStep").iterator().next());
            UseCase useCase = (UseCase)((Object)this.modelController.getModuleData((IModuleData)modelExtension, "UseCaseExtension").iterator().next());
            int joinEndType = modelExtension.getSuccess().getValue();
            this.originalExtensions.add(new ExtensionWrapper(useCase, forkingStep, joiningStep, joinEndType, modelExtension, this.scenario));
        }
        this.extensionTableContentProvider = new ExtensionTableContentProvider(tableViewer, this);
        Composite buttonComposite = new Composite(extensionComposite, 0);
        buttonComposite.setLayoutData((Object)new GridData(131072, 128, false, false));
        buttonComposite.setLayout((Layout)new GridLayout());
        final Collection<? extends IModuleData> useCases = this.getPossibleExtensionUseCases();
        final int numberOfPossibleExtensions = (this.originalActionSteps.size() - 2) * useCases.size();
        final Button addButton = new Button(buttonComposite, 8);
        addButton.setLayoutData((Object)new GridData(4, 0, false, false));
        addButton.setText(Messages.getString("ScenarioWidgetCreator.AddButtonTitle"));
        addButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ScenarioWidgetCreator.this.storeCurrentStepProperties();
                SelectExtensionDialog selectExtensionDialog = new SelectExtensionDialog(addButton.getShell(), useCases, ScenarioWidgetCreator.this.actionSteps, ScenarioWidgetCreator.this.scenario, ScenarioWidgetCreator.this.extensionTableContentProvider.getCurrentlyShownExtensions(), Messages.getString("ScenarioWidgetCreator.ExtensionDialogTitle"), Messages.getString("ScenarioWidgetCreator.ExtensionDialogMessage"));
                if (selectExtensionDialog.open() == 0) {
                    ScenarioWidgetCreator.this.extensionTableContentProvider.addExtension(selectExtensionDialog.getSelectedExtension());
                    addButton.setEnabled((ScenarioWidgetCreator.this.isNewScenario || ScenarioWidgetCreator.this.editLock.hasLock()) && ScenarioWidgetCreator.this.extensionTableContentProvider.getCurrentlyShownExtensions().size() < numberOfPossibleExtensions);
                }
            }
        });
        addButton.setEnabled((this.isNewScenario || this.editLock.hasLock()) && this.extensionTableContentProvider.getCurrentlyShownExtensions().size() < numberOfPossibleExtensions && this.permissionMgr.mayEditItemStructurally((IModuleData)this.scenario, this.permissionParent));
        final Button removeButton = new Button(buttonComposite, 8);
        removeButton.setLayoutData((Object)new GridData(4, 0, false, false));
        removeButton.setText(Messages.getString("ScenarioWidgetCreator.RemoveButtonTitle"));
        removeButton.setEnabled(false);
        removeButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                for (ExtensionWrapper extension : tableViewer.getSelectedExtensions()) {
                    ScenarioWidgetCreator.this.extensionTableContentProvider.removeExtension(extension);
                }
                addButton.setEnabled((ScenarioWidgetCreator.this.isNewScenario || ScenarioWidgetCreator.this.editLock.hasLock()) && ScenarioWidgetCreator.this.extensionTableContentProvider.getCurrentlyShownExtensions().size() < numberOfPossibleExtensions && ScenarioWidgetCreator.this.permissionMgr.mayEditItemStructurally((IModuleData)ScenarioWidgetCreator.this.scenario, ScenarioWidgetCreator.this.permissionParent));
            }
        });
        tableViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                removeButton.setEnabled((ScenarioWidgetCreator.this.isNewScenario || ScenarioWidgetCreator.this.editLock.hasLock()) && !tableViewer.getSelectedExtensions().isEmpty() && ScenarioWidgetCreator.this.permissionMgr.mayEditItemStructurally((IModuleData)ScenarioWidgetCreator.this.scenario, ScenarioWidgetCreator.this.permissionParent));
            }
        });
    }

    private Collection<? extends IModuleData> getPossibleExtensionUseCases() {
        Collection useCases = this.modelController.getAllItems("ucm.useCase");
        UseCase useCase = null;
        if (this.isMainScenario) {
            if (this.modelController.itemExists("ucm.Scenario", this.scenario.getUID())) {
                useCase = ((ModelController)this.modelController).getUseCase(this.scenario);
            }
        } else if (this.modelController.itemExists("ucm.Scenario", this.scenario.getUID())) {
            useCase = ((ModelController)this.modelController).getUseCase(this.scenario);
        } else if (this.parentScenario != null && this.modelController.itemExists("ucm.Scenario", this.scenario.getUID())) {
            useCase = ((ModelController)this.modelController).getUseCase(this.scenario);
        }
        if (useCase != null) {
            useCases.remove((Object)useCase);
        }
        return useCases;
    }

    private void createWidget(IUIElement element, String name, Composite parent, int heightHint, int numColumns) {
        Composite composite = new Composite(parent, 0);
        GridData gridData = new GridData(4, 4, true, false);
        gridData.horizontalSpan = numColumns;
        composite.setLayoutData((Object)gridData);
        composite.setLayout((Layout)new GridLayout(1, false));
        this.createLabel(composite, String.valueOf(name) + ":", 1);
        Control widget = element.getControl(composite);
        gridData = new GridData(4, 4, true, true);
        if (heightHint > 0) {
            gridData.heightHint = heightHint;
        }
        widget.setLayoutData((Object)gridData);
    }

    private void createExtensionPart(Composite parent) {
        if (!this.isMainScenario) {
            Group extensionPart = new Group(parent, 0);
            GridData gridData = new GridData(4, 4, true, false);
            extensionPart.setLayoutData((Object)gridData);
            GridLayout gridLayout = new GridLayout(2, true);
            extensionPart.setLayout((Layout)gridLayout);
            this.createIDControl((Composite)extensionPart);
            List<ActionStep> parentSteps = ((ModelController)this.modelController).getActionSteps(this.parentScenario);
            parentSteps.remove(0);
            String[] actionStepNames = new String[parentSteps.size()];
            ListIterator<ActionStep> i = parentSteps.listIterator();
            while (i.hasNext()) {
                ActionStep step = i.next();
                actionStepNames[i.nextIndex() - 1] = ((ModelController)this.modelController).getDisplayRepresentation_ActionStepWithActor(step);
            }
            this.forkingStepDropDown = this.createDropDown((Composite)extensionPart, Messages.getString("ScenarioWidgetCreator.ForkingDropDown.Title"), actionStepNames);
            this.forkingStepDropDown.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    int stepNumber = ScenarioWidgetCreator.this.forkingStepDropDown.getSelectionIndex();
                    ScenarioWidgetCreator.this.startStepLabel.setText(Integer.toString(stepNumber + 1));
                    List<ActionStep> parentActionSteps = ((ModelController)ScenarioWidgetCreator.this.modelController).getActionSteps(ScenarioWidgetCreator.this.parentScenario);
                    parentActionSteps.remove(0);
                    ActionStep forkingStep = parentActionSteps.get(stepNumber);
                    Set idsOnSameLevel = ScenarioWidgetCreator.this.getIDsOnSameLevel(ScenarioWidgetCreator.this.parentScenario);
                    if (idsOnSameLevel.contains(ScenarioWidgetCreator.this.getCurrentID())) {
                        Collection items = ScenarioWidgetCreator.this.modelController.getModuleData((IModuleData)forkingStep, "ScenarioBeginningStep");
                        try {
                            String newID = ScenarioWidgetCreator.this.modelController.generateNewID(1, "", "", null, items, "ucm.Scenario.ID", false, ScenarioWidgetCreator.this.getLockTypeIDForScenarioIDLock(forkingStep), null);
                            ((Text)ScenarioWidgetCreator.this.idFieldControl).setText(newID);
                            ScenarioWidgetCreator.this.isExclusiveProjectLockSet = false;
                        }
                        catch (EXCockpitLockDenied e1) {
                            ScenarioWidgetCreator.this.isExclusiveProjectLockSet = true;
                        }
                    }
                }
            });
            this.joiningStepDropDown = this.createDropDown((Composite)extensionPart, Messages.getString("ScenarioWidgetCreator.JoiningDropDown.Title"), JOINING_STEPS);
            if (!this.isNewScenario && !this.editLock.hasLock() || !this.permissionMgr.mayEditItemStructurally((IModuleData)this.scenario, this.permissionParent)) {
                this.forkingStepDropDown.setEnabled(false);
                this.joiningStepDropDown.setEnabled(false);
                this.idFieldControl.setEnabled(false);
            }
        }
    }

    private void initializeUI() {
        ActionStep beginningStep = null;
        if (!this.isMainScenario) {
            if (!this.isNew) {
                beginningStep = (ActionStep)((Object)this.modelController.getLinkableObjects((IModuleData)this.scenario, "ScenarioBeginningStep").iterator().next());
                this.forkingStepDropDown.select(beginningStep.getNumber().getValue() - 1);
                this.selectJoiningStep(1);
            } else {
                String newID;
                List<ActionStep> parentActionSteps = ((ModelController)this.modelController).getActionSteps(this.parentScenario);
                parentActionSteps.remove(0);
                this.forkingStepDropDown.select(this.extensionStartingStep != null ? this.extensionStartingStep.getNumber().getValue() - 1 : 0);
                ActionStep forkingStep = parentActionSteps.get(this.getCurrentForkingStep());
                Collection items = this.modelController.getModuleData((IModuleData)forkingStep, "ScenarioBeginningStep");
                try {
                    newID = this.modelController.generateNewID(1, "", "", null, items, "ucm.Scenario.ID", false, this.getLockTypeIDForScenarioIDLock(forkingStep), null);
                }
                catch (EXCockpitLockDenied e) {
                    throw new RuntimeException();
                }
                this.scenario.getID().setValue(newID);
                this.startStepLabel.setText(Integer.toString(this.getCurrentForkingStep() + 1));
            }
            this.forkingStepDropDown.addSelectionListener((SelectionListener)new ForkingListener(this.forkingStepDropDown.getItemCount()));
            this.fillJoiningDropdownList(this.forkingStepDropDown.getItemCount());
            if (!this.isNew) {
                ActionStep joningStep = (ActionStep)((Object)this.modelController.getLinkableObjects((IModuleData)this.scenario, "ScenarioFinalStep").iterator().next());
                if (((ModelController)this.modelController).before(joningStep, beginningStep) <= 0) {
                    this.selectJoiningStep(0);
                } else if (joningStep.getStepType().getValue() == 1) {
                    if (this.scenario.getSuccess().getValue() == 0) {
                        this.selectJoiningStep(2);
                    } else {
                        this.selectJoiningStep(3);
                    }
                } else {
                    this.selectJoiningStep(1);
                }
            } else {
                this.selectJoiningStep(1);
            }
        }
        this.callback.setChangedStatus(false);
    }

    private void fillJoiningDropdownList(int numberOfSteps) {
        int forkingIndex = this.getCurrentForkingStep();
        if (forkingIndex < numberOfSteps - 2) {
            this.setJoiningDropdownValues(joiningValuesNormal);
        } else if (forkingIndex < numberOfSteps - 1) {
            this.setJoiningDropdownValues(joiningValuesForLastRealStep);
        } else {
            this.setJoiningDropdownValues(joiningValuesForEnd);
        }
    }

    private Combo createDropDown(Composite parent, String name, String[] values) {
        Composite composite = new Composite(parent, 0);
        composite.setLayoutData((Object)new GridData(4, 4, true, false));
        composite.setLayout((Layout)new GridLayout());
        this.createLabel(composite, name, 1);
        Combo combo = new Combo(composite, 2060);
        combo.setLayoutData((Object)new GridData(4, 4, true, false));
        combo.setItems(values);
        return combo;
    }

    public Control createGeneralPart(Composite parent) {
        if (this.isMainScenario) {
            this.allCurrentFieldWidgets.add((IUIElement)this.goalField);
        }
        this.allCurrentFieldWidgets.add((IUIElement)this.preconditionField);
        this.allCurrentFieldWidgets.add((IUIElement)this.postconditionSuccesField);
        this.allCurrentFieldWidgets.add((IUIElement)this.postConditionFailureField);
        this.allCurrentFieldWidgets.add((IUIElement)this.triggerField);
        if (this.idField != null) {
            this.allCurrentFieldWidgets.add((IUIElement)this.idField);
        }
        Group generalPart = new Group(parent, 0);
        GridData gridData = new GridData(4, 4, true, false);
        generalPart.setLayoutData((Object)gridData);
        GridLayout gridLayout = new GridLayout(2, true);
        generalPart.setLayout((Layout)gridLayout);
        if (this.isMainScenario) {
            this.createWidget((IUIElement)this.goalField, ScenarioDescription.NAME_GOAL, (Composite)generalPart, 80, 2);
        }
        this.createWidget((IUIElement)this.preconditionField, ScenarioDescription.NAME_PRE, (Composite)generalPart, 120, 1);
        this.createWidget((IUIElement)this.triggerField, ScenarioDescription.NAME_TRIGGER, (Composite)generalPart, 120, 1);
        this.createWidget((IUIElement)this.postconditionSuccesField, ScenarioDescription.NAME_POST_SUCC, (Composite)generalPart, 120, 1);
        this.createWidget((IUIElement)this.postConditionFailureField, ScenarioDescription.NAME_POST_FAIL, (Composite)generalPart, 120, 1);
        this.generalPartCreated = true;
        return generalPart;
    }

    private void createIDControl(Composite generalPart) {
        ActionStep forkingStep;
        Composite composite = new Composite(generalPart, 0);
        GridData gridData = new GridData(4, 4, true, false);
        gridData.horizontalSpan = 2;
        composite.setLayoutData((Object)gridData);
        composite.setLayout((Layout)new GridLayout(1, false));
        this.createLabel(composite, ScenarioDescription.NAME_ID, 1);
        Composite idComposite = new Composite(composite, 0);
        gridData = new GridData(4, 4, false, false);
        idComposite.setLayoutData((Object)gridData);
        idComposite.setLayout((Layout)new GridLayout(2, false));
        this.startStepLabel = new Label(idComposite, 0);
        this.startStepLabel.setLayoutData((Object)new GridData(4, 3, false, false));
        if (this.isNew) {
            Iterator<ActionStep> parentSteps = ((ModelController)this.modelController).getActionSteps(this.parentScenario).iterator();
            parentSteps.next();
            forkingStep = parentSteps.next();
        } else {
            forkingStep = (ActionStep)((Object)this.modelController.getLinkableObjects((IModuleData)this.scenario, "ScenarioBeginningStep").iterator().next());
        }
        this.startStepLabel.setText(forkingStep.getNumber().getDisplayStringRepresentation());
        this.idFieldControl = this.idField.getControl(idComposite);
        gridData = new GridData(1, 4, false, false);
        gridData.widthHint = 40;
        this.idFieldControl.setLayoutData((Object)gridData);
    }

    private void createStepPart(Composite parent, TabFolder tabFolder_) {
        this.scComp = new ScrolledComposite(parent, 512);
        this.scComp.setBackground(parent.getDisplay().getSystemColor(1));
        this.scComp.setBackgroundMode(1);
        GridData gridData = new GridData(4, 4, true, true);
        this.scComp.setLayoutData((Object)gridData);
        this.scComp.getVerticalBar().setIncrement(15);
        this.stepComposite = new Composite((Composite)this.scComp, 0);
        this.scComp.setContent((Control)this.stepComposite);
        this.scComp.addControlListener((ControlListener)new ControlAdapter(){

            public void controlResized(ControlEvent e) {
                Rectangle r = ScenarioWidgetCreator.this.scComp.getClientArea();
                ScenarioWidgetCreator.this.stepComposite.setSize(ScenarioWidgetCreator.this.stepComposite.computeSize(r.width, -1));
                Rectangle r2 = ScenarioWidgetCreator.this.scComp.getClientArea();
                ScenarioWidgetCreator.this.stepComposite.setSize(ScenarioWidgetCreator.this.stepComposite.computeSize(r2.width, -1));
            }
        });
        this.stepComposite.setLayout((Layout)new GridLayout(2, false));
        String[] actorNames = this.extractActorNames();
        int index = 1;
        for (ActionStepInEditDialogue step : this.actionSteps) {
            if (step.getState() != 2 && step.getState() != 3) continue;
            this.createStepField(step, index, actorNames);
            ++index;
        }
        this.endPlusButton = new Button(this.stepComposite, 0x800008);
        this.endPlusButton.setImage(plusImage);
        this.endPlusButton.setToolTipText(Messages.getString("ScenarioWidgetCreator.PlusButton.Tooltip"));
        if (this.editLock != null) {
            this.stepsEnabled = this.stepsEnabled && this.editLock.hasLock();
        }
        this.endPlusButton.setEnabled(this.stepsEnabled && this.permissionMgr.mayEditItemStructurally((IModuleData)this.scenario, this.permissionParent));
        SelectionAdapter plusListener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ScenarioWidgetCreator.this.createAndInsertActionStep(ScenarioWidgetCreator.this.finalStep);
                ScenarioWidgetCreator.this.rebuildStepPart();
                ScenarioWidgetCreator.this.scComp.getVerticalBar().setSelection(ScenarioWidgetCreator.this.scComp.getVerticalBar().getMaximum());
                ScenarioWidgetCreator.this.scComp.layout();
                if (ScenarioWidgetCreator.this.extensionTableContentProvider != null) {
                    ScenarioWidgetCreator.this.extensionTableContentProvider.setActionSteps(ScenarioWidgetCreator.getListOfCurrentActionSteps(ScenarioWidgetCreator.this.actionSteps));
                }
            }
        };
        this.endPlusButton.addSelectionListener((SelectionListener)plusListener);
        gridData = new GridData();
        gridData.widthHint = 20;
        this.endPlusButton.setLayoutData((Object)gridData);
        parent.layout();
        this.scComp.layout();
        tabFolder_.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                if (e.item != ScenarioWidgetCreator.this.stepTab && ScenarioWidgetCreator.this.extensionTableContentProvider != null) {
                    ScenarioWidgetCreator.this.extensionTableContentProvider.setActionSteps(ScenarioWidgetCreator.getListOfCurrentActionSteps(ScenarioWidgetCreator.this.actionSteps));
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
    }

    private void rebuildStepPart() {
        for (ActionStepInEditDialogue step : this.actionSteps) {
            int actorSelectionIndex;
            if (step.getState() != 2 && step.getState() != 3) continue;
            if (step.getControls().titleText != null) {
                step.setTitle(step.getControls().titleText.getText());
            }
            if (step.getControls().descriptionText != null) {
                step.setDescription(step.getControls().descriptionText.getText());
            }
            if (step.getControls().actorCombo == null || (actorSelectionIndex = step.getControls().actorCombo.getSelectionIndex()) < 0) continue;
            step.setActorAndGoal(this.allGoalWrappers.get(actorSelectionIndex));
        }
        this.allCurrentFieldWidgets.removeAll(this.currentFieldWidgetsOfSteps);
        this.currentFieldWidgetsOfSteps.clear();
        this.scComp.dispose();
        this.createStepPart(this.stepGroup, this.tabFolder);
        if (this.adapter != null) {
            this.adapter.actorStateChanged(this.getUsedGoalWrappers());
        }
        if (this.initialized) {
            this.setDirty();
        }
        this.check();
    }

    private void storeCurrentStepProperties() {
        for (ActionStepInEditDialogue step : this.actionSteps) {
            int actorSelectionIndex;
            if (step.getState() != 2 && step.getState() != 3) continue;
            if (step.getControls().titleText != null) {
                step.setTitle(step.getControls().titleText.getText());
            }
            if (step.getControls().descriptionText != null) {
                step.setDescription(step.getControls().descriptionText.getText());
            }
            if (step.getControls().actorCombo == null || (actorSelectionIndex = step.getControls().actorCombo.getSelectionIndex()) < 0) continue;
            step.setActorAndGoal(this.allGoalWrappers.get(actorSelectionIndex));
        }
    }

    private Collection<GoalWrapper> getUsedGoalWrappers() {
        HashSet<GoalWrapper> usedGoalWrappers = new HashSet<GoalWrapper>();
        for (ActionStepInEditDialogue step : this.actionSteps) {
            if (step.getState() != 2 && step.getState() != 3) continue;
            usedGoalWrappers.add(this.allGoalWrappers.get(step.getControls().actorCombo.getSelectionIndex()));
        }
        return usedGoalWrappers;
    }

    private void createStepField(ActionStepInEditDialogue step, int number, String[] actorNames) {
        int index;
        Composite plusminusComposite = new Composite(this.stepComposite, 0);
        GridData gridData = new GridData(0, 4, false, false);
        plusminusComposite.setLayoutData((Object)gridData);
        GridLayout gridLayout = new GridLayout();
        plusminusComposite.setLayout((Layout)gridLayout);
        this.createPlusButton(step.getActionStep(), plusminusComposite);
        step.getControls().minusButton = this.createMinusButton(step.getActionStep(), plusminusComposite);
        Group stepFieldsGroup = new Group(this.stepComposite, 0);
        gridData = new GridData(4, 0, true, false);
        stepFieldsGroup.setLayoutData((Object)gridData);
        stepFieldsGroup.setLayout((Layout)new GridLayout());
        stepFieldsGroup.setText(String.valueOf(Messages.getString("ScenarioWidgetCreator.StepFieldText")) + number + ":");
        Composite titleComposite = new Composite((Composite)stepFieldsGroup, 0);
        titleComposite.setLayout((Layout)new GridLayout(2, false));
        gridData = new GridData(4, 0, true, false);
        titleComposite.setLayoutData((Object)gridData);
        Label actorLabel = new Label(titleComposite, 0);
        actorLabel.setText(Messages.getString("ScenarioWidgetCreator.ActorLabelText"));
        gridData = new GridData(4, 0, false, false);
        actorLabel.setLayoutData((Object)gridData);
        Label titleLabel = new Label(titleComposite, 0);
        titleLabel.setText(Messages.getString("ScenarioWidgetCreator.TitleLabelText"));
        gridData = new GridData(4, 0, true, false);
        titleLabel.setLayoutData((Object)gridData);
        Combo actorCombo = new Combo(titleComposite, 8);
        actorCombo.setLayoutData((Object)new GridData(4, 0, false, false));
        actorCombo.setItems(actorNames);
        GoalWrapper goalWrapper = step.getActorAndGoal();
        if (goalWrapper == null) {
            goalWrapper = this.getMainActor();
        }
        if (goalWrapper != null && (index = this.allGoalWrappers.indexOf(goalWrapper)) >= 0) {
            actorCombo.select(index);
        }
        step.getControls().actorCombo = actorCombo;
        if (this.adapter != null) {
            actorCombo.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    if (ScenarioWidgetCreator.this.sendModifyEvents) {
                        ScenarioWidgetCreator.this.adapter.actorStateChanged(ScenarioWidgetCreator.this.getUsedGoalWrappers());
                    }
                }
            });
        }
        UIETextField titleField = new UIETextField(String.valueOf(Messages.getString("ScenarioWidgetCreator.TitleField.1")) + number + Messages.getString("ScenarioWidgetCreator.TitleField.2"), step.getActionStep().getTitle().getValueRangeHelper(), false);
        Control titleControl = titleField.getControl(titleComposite);
        titleControl.setLayoutData((Object)new GridData(4, 0, true, false));
        Composite descComposite = new Composite((Composite)stepFieldsGroup, 0);
        descComposite.setLayout((Layout)new GridLayout());
        gridData = new GridData(4, 0, true, false);
        descComposite.setLayoutData((Object)gridData);
        Label descLabel = new Label(descComposite, 0);
        descLabel.setLayoutData((Object)new GridData(4, 0, true, false));
        descLabel.setText(Messages.getString("ScenarioWidgetCreator.DescriptionLabelText"));
        UIETextField descField = new UIETextField(String.valueOf(Messages.getString("ScenarioWidgetCreator.DescField.1")) + number + Messages.getString("ScenarioWidgetCreator.DescField.2"), step.getActionStep().getDescription().getValueRangeHelper(), true);
        Control descControl = descField.getControl(descComposite);
        if (step.getState() != 3) {
            if (!this.isNewScenario && !this.editLock.hasLock() || !this.permissionMgr.mayEditAttribute((IModuleData)step.getActionStep(), this.permissionParent, "ucm.Step.Title")) {
                titleField.setEditable(false);
            }
            if (!this.isNewScenario && !this.editLock.hasLock() || !this.permissionMgr.mayEditAttribute((IModuleData)step.getActionStep(), this.permissionParent, "ucm.Step.Description")) {
                descField.setEditable(false);
            }
            if (!this.isNewScenario && !this.editLock.hasLock() || !this.permissionMgr.mayEditAttribute((IModuleData)step.getActionStep(), this.permissionParent, "ucm.step.Actor")) {
                actorCombo.setEnabled(false);
            }
        }
        gridData = new GridData(1808);
        gridData.heightHint = 50;
        descControl.setLayoutData((Object)gridData);
        if (step.getTitle() != null) {
            ((Text)titleControl).setText(step.getTitle());
        }
        if (step.getDescription() != null) {
            ((Text)descControl).setText(step.getDescription());
        }
        step.getControls().titleText = (Text)titleControl;
        step.getControls().descriptionText = (Text)descControl;
        descField.addModifyListener(this.checkListener);
        titleField.addModifyListener(this.checkListener);
        this.currentFieldWidgetsOfSteps.add((IUIElement)titleField);
        this.currentFieldWidgetsOfSteps.add((IUIElement)descField);
        this.allCurrentFieldWidgets.add((IUIElement)titleField);
        this.allCurrentFieldWidgets.add((IUIElement)descField);
    }

    private GoalWrapper getMainActor() {
        Iterator<GoalWrapper> i = this.allGoalWrappers.iterator();
        while (this.mainActor == null && i.hasNext()) {
            GoalWrapper actor = i.next();
            if (!actor.isMainActor) continue;
            this.mainActor = actor;
        }
        return this.mainActor;
    }

    private String[] extractActorNames() {
        String[] actorNames = new String[this.allGoalWrappers.size()];
        ListIterator<GoalWrapper> i = this.allGoalWrappers.listIterator();
        while (i.hasNext()) {
            GoalWrapper goalWrapper = i.next();
            int index = i.nextIndex() - 1;
            actorNames[index] = goalWrapper.actor.getName().getDisplayStringRepresentation();
        }
        return actorNames;
    }

    private void createPlusButton(final ActionStep _step, Composite parent) {
        Button plusButton = new Button(parent, 0x800008);
        plusButton.setImage(plusImage);
        plusButton.setToolTipText(Messages.getString("ScenarioWidgetCreator.PlusButton.Tooltip"));
        GridData gridData = new GridData(4, 128, false, false);
        gridData.widthHint = 20;
        plusButton.setLayoutData((Object)gridData);
        SelectionAdapter selectionListener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ScenarioWidgetCreator.this.createAndInsertActionStep(_step);
                Point currentScrollbarPosition = ScenarioWidgetCreator.this.scComp.getOrigin();
                ScenarioWidgetCreator.this.rebuildStepPart();
                ScenarioWidgetCreator.this.scComp.setOrigin(currentScrollbarPosition);
                if (ScenarioWidgetCreator.this.extensionTableContentProvider != null) {
                    ScenarioWidgetCreator.this.extensionTableContentProvider.setActionSteps(ScenarioWidgetCreator.getListOfCurrentActionSteps(ScenarioWidgetCreator.this.actionSteps));
                }
            }
        };
        plusButton.addSelectionListener((SelectionListener)selectionListener);
        if (!((this.isNewScenario || this.editLock != null && this.editLock.hasLock()) && this.permissionMgr.mayEditItemStructurally((IModuleData)_step, this.permissionParent))) {
            plusButton.setEnabled(false);
        }
    }

    private Button createMinusButton(final ActionStep step, Composite parent) {
        Button minusButton = new Button(parent, 0x800008);
        minusButton.setImage(minusImage);
        minusButton.setToolTipText(Messages.getString("ScenarioWidgetCreator.MinusButton.Tooltip"));
        GridData gridData = new GridData(4, 128, false, false);
        gridData.widthHint = 20;
        minusButton.setLayoutData((Object)gridData);
        SelectionAdapter selectionListener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ScenarioWidgetCreator.this.removeActionStep(step);
                Point currentScrollbarPosition = ScenarioWidgetCreator.this.scComp.getOrigin();
                ScenarioWidgetCreator.this.rebuildStepPart();
                ScenarioWidgetCreator.this.scComp.setOrigin(currentScrollbarPosition);
                if (ScenarioWidgetCreator.this.extensionTableContentProvider != null) {
                    ScenarioWidgetCreator.this.extensionTableContentProvider.setActionSteps(ScenarioWidgetCreator.getListOfCurrentActionSteps(ScenarioWidgetCreator.this.actionSteps));
                }
            }
        };
        minusButton.addSelectionListener((SelectionListener)selectionListener);
        this.setMinusButtonEnablement(minusButton, step, Collections.emptySet());
        return minusButton;
    }

    private void setMinusButtonEnablement(Button minusButton, ActionStep step, Collection<ActionStep> stepsUsedByUseCaseExtensions) {
        minusButton.setEnabled((this.isNewScenario || this.editLock.hasLock()) && this.permissionMgr.mayEditItemStructurally((IModuleData)this.scenario, this.permissionParent) && !this.hasAnyExtensions(step, stepsUsedByUseCaseExtensions));
    }

    private boolean hasAnyExtensions(ActionStep step, Collection<ActionStep> stepsUsedByUseCaseExtensions) {
        boolean hasExtensions = !this.modelController.getModuleData((IModuleData)step, "ScenarioBeginningStep").isEmpty() || !this.modelController.getModuleData((IModuleData)step, "ScenarioFinalStep").isEmpty();
        return hasExtensions |= stepsUsedByUseCaseExtensions.contains((Object)step);
    }

    void handleExtensionsChanged(Set<ActionStep> allActionStepsWithUseCaseExtensions) {
        for (ActionStepInEditDialogue step : this.actionSteps) {
            if (step.getState() != 2 && step.getState() != 3) continue;
            this.setMinusButtonEnablement(step.getControls().minusButton, step.getActionStep(), allActionStepsWithUseCaseExtensions);
        }
    }

    private ActionStep createAndInsertActionStep(ActionStep successor) {
        ActionStep newStep = new ActionStep();
        newStep.setProjectUID(this.scenario.getProjectUID());
        int index = 0;
        for (ActionStepInEditDialogue currentStep : this.actionSteps) {
            if (currentStep.getActionStep().equals((Object)successor)) {
                ActionStepInEditDialogue newStepWrapper = new ActionStepInEditDialogue(newStep, 3);
                newStepWrapper.setActorAndGoal(this.getMainActor());
                this.actionSteps.add(index, newStepWrapper);
                break;
            }
            ++index;
        }
        return newStep;
    }

    private void removeActionStep(ActionStep step) {
        int index = 0;
        for (ActionStepInEditDialogue currentStep : this.actionSteps) {
            if (currentStep.getActionStep().equals((Object)step)) {
                if (currentStep.getState() == 2) {
                    currentStep.setState(4);
                    break;
                }
                this.actionSteps.remove(index);
                break;
            }
            ++index;
        }
    }

    private static List<ActionStep> getListOfCurrentActionSteps(List<ActionStepInEditDialogue> wrappers) {
        ArrayList<ActionStep> steps = new ArrayList<ActionStep>(wrappers.size());
        for (ActionStepInEditDialogue wrappedStep : wrappers) {
            if (wrappedStep.getState() == 4) continue;
            steps.add(wrappedStep.getActionStep());
        }
        return steps;
    }

    protected void createLabel(Composite parent, String text, int span) {
        Label label = new Label(parent, 0);
        label.setText(text);
        GridData gridData = new GridData(1808);
        gridData.horizontalSpan = span;
        label.setLayoutData((Object)gridData);
    }

    public void modifyText(ModifyEvent e) {
        if (this.initialized) {
            this.setDirty();
        }
        this.check();
    }

    boolean check() {
        Set<String> ids;
        if (!this.initialized) {
            return true;
        }
        String errMsg = "";
        if (errMsg.length() == 0) {
            for (IUIElement element : this.allCurrentFieldWidgets) {
                String checkResult = element.checkCurrentValue();
                if (checkResult == null) continue;
                errMsg = checkResult;
                break;
            }
        }
        if (errMsg.length() == 0 && !this.isMainScenario && (ids = this.getIDsOnSameLevel(this.parentScenario)).contains(this.idField.getCurrentValue().trim())) {
            errMsg = ERR_MSG_NON_UNIQUE;
        }
        if (this.isExclusiveProjectLockSet) {
            this.callback.setErrMsg(com.arcway.cockpit.modulelib2.client.Messages.getString((String)"CreationDialogs.ExclusiveProjectLock"));
            this.callback.setCommitable(errMsg.length() == 0);
            return false;
        }
        if (errMsg.length() > 0) {
            this.callback.setErrMsg(errMsg);
            this.callback.setCommitable(false);
            return false;
        }
        this.callback.clearErrorMessage();
        this.callback.setCommitable(true);
        return true;
    }

    private Set<String> getIDsOnSameLevel(Scenario parent) {
        int currentForkingStepNumber = this.getCurrentForkingStep();
        List<ActionStep> parentActionSteps = ((ModelController)this.modelController).getActionSteps(parent);
        parentActionSteps.remove(0);
        ActionStep forkingStep = parentActionSteps.get(currentForkingStepNumber);
        Collection scenariosOnSameLevel = this.modelController.getModuleData((IModuleData)forkingStep, "ScenarioBeginningStep");
        HashSet<String> ids = new HashSet<String>(scenariosOnSameLevel.size());
        for (Scenario element : scenariosOnSameLevel) {
            if (element.equals((Object)this.scenario)) continue;
            ids.add(element.getID().getValue());
        }
        return ids;
    }

    public String getCurrentID() {
        if (!this.isMainScenario) {
            return this.idField.getCurrentValue().trim();
        }
        return null;
    }

    public int getCurrentForkingStep() {
        return this.forkingStepDropDown != null ? this.forkingStepDropDown.getSelectionIndex() : -1;
    }

    public int getCurrentJoiningType() {
        return this.joiningStepDropDown != null ? this.currentJoiningPossibilities[this.joiningStepDropDown.getSelectionIndex()] : -1;
    }

    public boolean getIDLock() {
        if (!this.isMainScenario) {
            String newID = this.idField.getCurrentValue().trim();
            if (this.isNew || !newID.equals(this.oldID)) {
                AbstractLockManager lockManager = this.modelController.getLockMgr();
                List<ActionStep> parentActionSteps = ((ModelController)this.modelController).getActionSteps(this.parentScenario);
                parentActionSteps.remove(0);
                ActionStep beginningStep = parentActionSteps.get(this.getCurrentForkingStep());
                this.idLock = lockManager.acquireUniqueIDLock(newID, this.getLockTypeIDForScenarioIDLock(beginningStep));
                if (!this.idLock.hasLock()) {
                    this.isExclusiveProjectLockSet = this.idLock.isExclusiveProjectLockConflicting();
                    return false;
                }
                this.isExclusiveProjectLockSet = false;
                return true;
            }
        }
        return true;
    }

    public void releaseIDLock() {
        this.idLock.releaseLocks();
    }

    public void releaseOldIDLock() {
        if (this.idField != null && !this.isNew && !this.idField.getCurrentValue().trim().equals(this.oldID)) {
            AbstractLockManager lockManager = this.modelController.getLockMgr();
            lockManager.releaseUniqueIdLock("ucm.Scenario", this.oldID);
        }
    }

    private void addListener() {
        for (IUIElement element : this.allCurrentFieldWidgets) {
            element.addModifyListener((ModifyListener)this);
        }
    }

    public boolean isExclusiveProjectLockConflicting() {
        return this.isExclusiveProjectLockSet;
    }

    public boolean init() {
        if (!this.isNew && !this.isMainScenario) {
            this.idField = new UIETextField(ScenarioDescription.NAME_ID, this.scenario.getID().getValueRangeHelper(), false);
            this.parentScenario = (Scenario)this.modelController.getParent(this.modelController.getParent((IModuleData)this.scenario));
            this.oldID = this.scenario.getID().getValue();
        }
        boolean bl = this.isNewScenario = this.isNew || this.modelController.isNew((ICockpitProjectData)this.scenario);
        if (!this.isNewScenario) {
            this.editLock = this.modelController.getLockMgr().acquireEditLock((ICockpitProjectData)this.scenario, false);
            this.scenario = (Scenario)this.modelController.getItem("ucm.Scenario", this.scenario.getUID());
            if (this.scenario == null) {
                return false;
            }
            this.originalActionSteps = new ArrayList<ActionStep>(((ModelController)this.modelController).getActionSteps(this.scenario));
        }
        this.actionSteps = new LinkedList<ActionStepInEditDialogue>();
        for (ActionStep step : this.originalActionSteps) {
            int state = step.getStepType().getValue() == 0 ? 1 : (step.getStepType().getValue() == 1 ? 5 : 2);
            ActionStepInEditDialogue stepWrapper = new ActionStepInEditDialogue(step, state);
            stepWrapper.setActorAndGoal(this.originalMapping_step_actor.get((Object)step));
            this.actionSteps.add(stepWrapper);
        }
        this.allCurrentFieldWidgets = new LinkedList<IUIElement>();
        this.currentFieldWidgetsOfSteps = new LinkedList<IUIElement>();
        if (this.isMainScenario) {
            this.goalField = new UIETextField(ScenarioDescription.NAME_GOAL, this.scenario.getGoal().getValueRangeHelper(), true);
        }
        this.preconditionField = new UIETextField(ScenarioDescription.NAME_PRE, this.scenario.getPrecondition().getValueRangeHelper(), true);
        this.postconditionSuccesField = new UIETextField(ScenarioDescription.NAME_POST_SUCC, this.scenario.getSuccessPostcondition().getValueRangeHelper(), true);
        this.postConditionFailureField = new UIETextField(ScenarioDescription.NAME_POST_FAIL, this.scenario.getFailurePostcondition().getValueRangeHelper(), true);
        this.triggerField = new UIETextField(ScenarioDescription.NAME_TRIGGER, this.scenario.getTrigger().getValueRangeHelper(), true);
        return true;
    }

    public List<ActionStepInEditDialogue> getActionSteps() {
        return this.actionSteps;
    }

    public void addGoalWrapper(GoalWrapper goalWrapper) {
        this.storeCurrentStepProperties();
        this.allGoalWrappers.add(goalWrapper);
        this.updateActorIndexes();
        this.enablePlusButton(true);
    }

    public void removeGoalWrapper(GoalWrapper goalWrapper) {
        this.storeCurrentStepProperties();
        this.allGoalWrappers.remove(goalWrapper);
        this.updateActorIndexes();
    }

    private void updateActorIndexes() {
        this.sendModifyEvents = false;
        String[] actorNames = this.extractActorNames();
        for (ActionStepInEditDialogue step : this.actionSteps) {
            if (step.getState() != 2 && step.getState() != 3) continue;
            step.getControls().actorCombo.setItems(actorNames);
            step.getControls().actorCombo.select(this.allGoalWrappers.indexOf(step.getActorAndGoal()));
        }
        this.sendModifyEvents = true;
    }

    void setValues() {
        for (IUIElement element : this.allCurrentFieldWidgets) {
            element.setValue();
        }
        if (this.extensionTableContentProvider != null) {
            this.extensionTableContentProvider.setActionSteps(this.originalActionSteps);
            this.extensionTableContentProvider.addCurrentExtensions(this.originalExtensions);
        }
        this.addListener();
        this.initialized = true;
        this.check();
    }

    void getValues() {
        for (IUIElement element : this.allCurrentFieldWidgets) {
            element.getValue();
        }
        for (ActionStepInEditDialogue step : this.actionSteps) {
            if (step.getState() != 2 && step.getState() != 3) continue;
            step.setActorAndGoal(this.allGoalWrappers.get(step.getControls().actorCombo.getSelectionIndex()));
        }
    }

    public Collection<ExtensionWrapper> getAddedExtensions() {
        if (this.extensionTableContentProvider != null) {
            return this.extensionTableContentProvider.getAddedExtensions();
        }
        return Collections.emptyList();
    }

    public Collection<ExtensionWrapper> getModifiedExtensions() {
        if (this.extensionTableContentProvider != null) {
            return this.extensionTableContentProvider.getModifiedExtensions();
        }
        return Collections.emptyList();
    }

    public Collection<ExtensionWrapper> getRemovedExtensions() {
        if (this.extensionTableContentProvider != null) {
            return this.extensionTableContentProvider.getRemovedExtensions();
        }
        return Collections.emptyList();
    }

    public void setParentScenario(Scenario parentScenario, ActionStep startingStep) {
        assert (parentScenario != null) : "parentScenario must not be null";
        this.parentScenario = parentScenario;
        this.extensionStartingStep = startingStep;
        this.isMainScenario = false;
        this.idField = new UIETextField(ScenarioDescription.NAME_ID, this.scenario.getID().getValueRangeHelper(), false);
    }

    protected void setWidgetState(ModuleDataEditPropertyAdapter propertyAdapter) {
        if (this.idField != null) {
            if ((this.isNewScenario || this.editLock.hasLock()) && this.permissionMgr.mayEditAttribute((IModuleData)this.scenario, this.permissionParent, "ucm.Scenario.ID")) {
                this.idField.setEditable(true);
                this.idField.setEnabled(true);
            } else {
                this.idField.setEditable(false);
            }
        }
        boolean mayEditItemStructurally = (this.isNewScenario || this.editLock.hasLock()) && this.permissionMgr.mayEditItemStructurally((IModuleData)this.scenario, this.permissionParent);
        propertyAdapter.setCategoryEditable(mayEditItemStructurally);
        if (!this.generalPartCreated) {
            return;
        }
        if (this.isMainScenario && this.goalField != null) {
            this.goalField.setEditable((this.isNewScenario || this.editLock.hasLock()) && this.permissionMgr.mayEditAttribute((IModuleData)this.scenario, this.permissionParent, "ucm.Scenario.Goal"));
        }
        if (this.preconditionField != null) {
            this.preconditionField.setEditable((this.isNewScenario || this.editLock.hasLock()) && this.permissionMgr.mayEditAttribute((IModuleData)this.scenario, this.permissionParent, "ucm.Scenario.Precondition"));
        }
        if (this.postconditionSuccesField != null) {
            this.postconditionSuccesField.setEditable((this.isNewScenario || this.editLock.hasLock()) && this.permissionMgr.mayEditAttribute((IModuleData)this.scenario, this.permissionParent, "ucm.Scenario.PostconditionSuccess"));
        }
        if (this.postConditionFailureField != null) {
            this.postConditionFailureField.setEditable((this.isNewScenario || this.editLock.hasLock()) && this.permissionMgr.mayEditAttribute((IModuleData)this.scenario, this.permissionParent, "ucm.Scenario.PostconditionFailure"));
        }
        if (this.triggerField != null) {
            this.triggerField.setEditable((this.isNewScenario || this.editLock.hasLock()) && this.permissionMgr.mayEditAttribute((IModuleData)this.scenario, this.permissionParent, "ucm.Scenario.Trigger"));
        }
        if (this.forkingStepDropDown != null) {
            this.forkingStepDropDown.setEnabled(mayEditItemStructurally);
        }
        if (this.joiningStepDropDown != null) {
            this.joiningStepDropDown.setEnabled(mayEditItemStructurally);
        }
    }

    public void setErrMsg(String errorMessage) {
        if (!this.check()) {
            this.callback.setErrMsg(errorMessage);
        }
    }

    public void setMessage(String message, int type) {
        if (type == 3) {
            this.setErrMsg(message);
        } else {
            this.callback.setMessage(message, type);
        }
    }

    public void clearErrorMessage() {
        this.check();
    }

    public void setChangedStatus(boolean hasChanged) {
    }

    public void setCommitable(boolean commitable) {
    }

    protected boolean isMainScenario() {
        return this.isMainScenario;
    }

    private void setJoiningDropdownValues(int[] values) {
        String[] strings = new String[values.length];
        int i = 0;
        while (i < values.length) {
            int type = values[i];
            strings[i] = JOINING_STEPS[type];
            ++i;
        }
        if (this.joiningStepDropDown != null) {
            int oldJoiningType = -1;
            if (this.joiningStepDropDown.getSelectionIndex() >= 0) {
                oldJoiningType = this.currentJoiningPossibilities[this.joiningStepDropDown.getSelectionIndex()];
            }
            this.currentJoiningPossibilities = values;
            this.joiningStepDropDown.setItems(strings);
            if (oldJoiningType >= 0 && this.selectJoiningStep(oldJoiningType)) {
                return;
            }
        }
    }

    private boolean selectJoiningStep(int type) {
        assert (this.joiningStepDropDown.getItemCount() == this.currentJoiningPossibilities.length);
        int selectionIndex = ArrayUtil.indexOf((int)type, (int[])this.currentJoiningPossibilities);
        if (selectionIndex >= 0) {
            this.joiningStepDropDown.select(selectionIndex);
            return true;
        }
        if (this.joiningStepDropDown.getItemCount() > 0) {
            this.joiningStepDropDown.select(0);
        }
        return false;
    }

    public void actorsNamesChanged() {
        this.updateActorIndexes();
    }

    public void setCallback(IEditDialogErrorCallback callback) {
        assert (callback != null) : "callback must not be null";
        this.callback = callback;
        this.check();
    }

    public void cancelChanges() {
        if (!this.isNewScenario) {
            this.editLock.releaseLocks();
        }
    }

    void enablePlusButton(boolean p_enablement) {
        boolean enablement;
        boolean bl = enablement = p_enablement && (this.isNewScenario || this.editLock != null && this.editLock.hasLock()) && this.permissionMgr.mayEditItemStructurally((IModuleData)this.scenario, this.permissionParent);
        if (this.endPlusButton != null) {
            this.endPlusButton.setEnabled(enablement);
        }
        this.stepsEnabled = enablement;
    }

    public void setDirty() {
        this.callback.setDirty();
    }

    private String getLockTypeIDForScenarioIDLock(ActionStep forkingStep) {
        return "ucm.Scenario-ForkingStep=" + forkingStep.getUID();
    }

    String getStepLabel(ActionStep step) {
        int stepNumber = 1;
        ActionStepInEditDialogue wrappedStep = null;
        for (ActionStepInEditDialogue currentWrappedStep : this.actionSteps) {
            if (currentWrappedStep.getActionStep() == step) {
                wrappedStep = currentWrappedStep;
                break;
            }
            if (currentWrappedStep.getState() != 2 && currentWrappedStep.getState() != 3) continue;
            ++stepNumber;
        }
        if (wrappedStep != null) {
            if (wrappedStep.getState() == 5) {
                return Messages.getString("ActionStep.END");
            }
            String stepNumberString = new Integer(stepNumber).toString();
            String actorName = this.allGoalWrappers.get((int)wrappedStep.getControls().actorCombo.getSelectionIndex()).actor.getDisplayRepresentation();
            String stepTitle = wrappedStep.getControls().titleText.getText();
            return String.valueOf(stepNumberString) + ": " + actorName + " " + stepTitle;
        }
        return null;
    }

    private class ForkingListener
    extends SelectionAdapter {
        private final int numberOfSteps;

        ForkingListener(int numberOfSteps) {
            this.numberOfSteps = numberOfSteps;
        }

        public void widgetSelected(SelectionEvent e) {
            ScenarioWidgetCreator.this.fillJoiningDropdownList(this.numberOfSteps);
        }
    }
}

